/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.states;

import com.thecoderscorner.menu.remote.AuthStatus;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommandType;
import com.thecoderscorner.menu.remote.commands.MenuHeartbeatCommand;
import com.thecoderscorner.menu.remote.states.BaseMessageProcessingState;
import com.thecoderscorner.menu.remote.states.RemoteConnectorContext;
import com.thecoderscorner.menu.remote.states.RemoteConnectorState;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ConnectionReadyState
extends BaseMessageProcessingState {
    private AtomicLong lastTx = new AtomicLong();
    private AtomicInteger heartbeatInterval = new AtomicInteger(5000);
    private ScheduledFuture<?> hbTask = null;

    public ConnectionReadyState(RemoteConnectorContext context) {
        super(context);
    }

    @Override
    public AuthStatus getAuthenticationStatus() {
        return AuthStatus.CONNECTION_READY;
    }

    @Override
    public boolean canSendCommandToRemote(MenuCommand command) {
        this.lastTx.set(this.context.getClock().millis());
        return true;
    }

    @Override
    public void enterState() {
        this.lastReception.set(this.context.getClock().millis());
        this.disconnectInterval.set(this.heartbeatInterval.get() * 3);
        this.hbTask = this.context.getScheduledExecutor().scheduleAtFixedRate(this::hbChecker, 1L, 1L, TimeUnit.SECONDS);
        super.enterState();
    }

    @Override
    public void exitState(RemoteConnectorState nextState) {
        if (this.hbTask != null) {
            this.hbTask.cancel(true);
        }
        super.exitState(nextState);
    }

    private void hbChecker() {
        long now = this.context.getClock().millis();
        if (now - this.lastTx.get() > (long)this.heartbeatInterval.get()) {
            this.logger.log(System.Logger.Level.INFO, "Heartbeat being sent due to inactivity " + this.context.getConnectionName());
            this.context.sendHeartbeat(this.heartbeatInterval.get(), MenuHeartbeatCommand.HeartbeatMode.NORMAL);
        }
        if (now - this.lastReception.get() > (long)this.disconnectInterval.get()) {
            this.logger.log(System.Logger.Level.ERROR, "Connection closed due to inactivity " + this.context.getConnectionName());
            this.processTimeout();
        }
    }

    @Override
    protected void processTimeout() {
        this.context.close();
        this.markDone();
        this.context.changeState(AuthStatus.AWAITING_CONNECTION);
    }

    @Override
    protected boolean processMessage(MenuCommand cmd) {
        if (this.checkIfThereIsAnHbEnd(cmd)) {
            return true;
        }
        if (cmd.getCommandType() == MenuCommandType.HEARTBEAT) {
            MenuHeartbeatCommand hb = (MenuHeartbeatCommand)cmd;
            this.heartbeatInterval.set(hb.getHearbeatInterval());
            this.disconnectInterval.set(hb.getHearbeatInterval() * 3);
            this.logger.log(System.Logger.Level.INFO, "Heartbeat interval is " + hb.getHearbeatInterval());
        }
        this.context.notifyListeners(cmd);
        return true;
    }
}

