/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote;

import com.thecoderscorner.menu.remote.AuthStatus;
import com.thecoderscorner.menu.remote.ConnectMode;
import com.thecoderscorner.menu.remote.ConnectionChangeListener;
import com.thecoderscorner.menu.remote.LocalIdentifier;
import com.thecoderscorner.menu.remote.MenuCommandProtocol;
import com.thecoderscorner.menu.remote.RemoteConnector;
import com.thecoderscorner.menu.remote.RemoteConnectorListener;
import com.thecoderscorner.menu.remote.RemoteInformation;
import com.thecoderscorner.menu.remote.commands.AckStatus;
import com.thecoderscorner.menu.remote.commands.CommandFactory;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.commands.MenuHeartbeatCommand;
import com.thecoderscorner.menu.remote.protocol.CorrelationId;
import com.thecoderscorner.menu.remote.protocol.TcProtocolException;
import com.thecoderscorner.menu.remote.states.AwaitingBootstrapState;
import com.thecoderscorner.menu.remote.states.BootstrapInProgressState;
import com.thecoderscorner.menu.remote.states.ConnectionReadyState;
import com.thecoderscorner.menu.remote.states.JoinMessageArrivedState;
import com.thecoderscorner.menu.remote.states.NoOperationInitialState;
import com.thecoderscorner.menu.remote.states.PairingAuthFailedState;
import com.thecoderscorner.menu.remote.states.PairingAuthSuccessState;
import com.thecoderscorner.menu.remote.states.RemoteConnectorContext;
import com.thecoderscorner.menu.remote.states.RemoteConnectorState;
import com.thecoderscorner.menu.remote.states.SendPairingMessageState;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Clock;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;

public abstract class StreamRemoteConnector
implements RemoteConnector,
RemoteConnectorContext {
    private static final int MAX_MSG_EXPECTED = 1024;
    protected final System.Logger logger = System.getLogger(this.getClass().getSimpleName());
    protected final ScheduledExecutorService executor;
    protected final Clock clock;
    protected final Map<AuthStatus, Class<? extends RemoteConnectorState>> stateMachineMappings = new HashMap<AuthStatus, Class<? extends RemoteConnectorState>>();
    private final MenuCommandProtocol protocol;
    private final List<RemoteConnectorListener> connectorListeners = new CopyOnWriteArrayList<RemoteConnectorListener>();
    private final List<ConnectionChangeListener> connectionListeners = new CopyOnWriteArrayList<ConnectionChangeListener>();
    private final ByteBuffer inputBuffer = ByteBuffer.allocate(1024).order(ByteOrder.BIG_ENDIAN);
    private final ByteBuffer outputBuffer = ByteBuffer.allocate(1024).order(ByteOrder.BIG_ENDIAN);
    private final ByteBuffer cmdBuffer = ByteBuffer.allocate(1024).order(ByteOrder.BIG_ENDIAN);
    private final LocalIdentifier ourLocalId;
    private final AtomicReference<RemoteConnectorState> connectorState = new AtomicReference();
    private final AtomicReference<RemoteInformation> remoteParty = new AtomicReference<RemoteInformation>(RemoteInformation.NOT_CONNECTED);

    protected StreamRemoteConnector(LocalIdentifier ourLocalId, MenuCommandProtocol protocol, ScheduledExecutorService executor, Clock clock) {
        this.ourLocalId = ourLocalId;
        this.protocol = protocol;
        this.executor = executor;
        this.clock = clock;
        this.changeState(new NoOperationInitialState(this));
    }

    @Override
    public MenuCommand readCommandFromStream() throws IOException {
        try {
            byte byStart = 0;
            while (byStart != 1) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new IOException("Connection thread interrupted");
                }
                if (!this.isDeviceConnected()) {
                    throw new IOException("Connection thread not connected");
                }
                byStart = this.nextByte(this.inputBuffer);
            }
            this.readCompleteMessage(this.inputBuffer);
            this.logByteBuffer("Line read from stream", this.inputBuffer);
            byte protoId = this.inputBuffer.get();
            if (protoId != this.protocol.getKeyIdentifier()) {
                throw new TcProtocolException("Bad protocol " + protoId);
            }
            MenuCommand mc = this.protocol.fromChannel(this.inputBuffer);
            if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
                this.logger.log(System.Logger.Level.DEBUG, "Menu command read: " + mc);
            }
            return mc;
        }
        catch (TcProtocolException ex) {
            this.logger.log(System.Logger.Level.WARNING, "Protocol error: " + ex.getMessage() + ", remote=" + this.getConnectionName());
            return null;
        }
    }

    @Override
    public void close() {
        this.notifyConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMenuCommand(MenuCommand msg) throws IOException {
        if (this.connectorState.get().canSendCommandToRemote(msg)) {
            ByteBuffer byteBuffer = this.outputBuffer;
            synchronized (byteBuffer) {
                this.cmdBuffer.clear();
                this.protocol.toChannel(this.cmdBuffer, msg);
                this.cmdBuffer.flip();
                this.outputBuffer.clear();
                this.outputBuffer.put((byte)1);
                this.outputBuffer.put(this.protocol.getKeyIdentifier());
                this.outputBuffer.put((byte)msg.getCommandType().getHigh());
                this.outputBuffer.put((byte)msg.getCommandType().getLow());
                this.outputBuffer.put(this.cmdBuffer);
                this.outputBuffer.flip();
                this.logByteBuffer("Sending message on " + this.getConnectionName(), this.outputBuffer);
                this.sendInternal(this.outputBuffer);
                this.outputBuffer.clear();
            }
        } else {
            throw new IOException("Not connected to port");
        }
    }

    protected void handleCoreConnectionStates(ConnectMode connectMode) {
        if (connectMode == ConnectMode.PAIRING_CONNECTION) {
            this.stateMachineMappings.put(AuthStatus.SEND_AUTH, SendPairingMessageState.class);
            this.stateMachineMappings.put(AuthStatus.AUTHENTICATED, PairingAuthSuccessState.class);
            this.stateMachineMappings.put(AuthStatus.FAILED_AUTH, PairingAuthFailedState.class);
        } else {
            this.stateMachineMappings.put(AuthStatus.SEND_AUTH, JoinMessageArrivedState.class);
            this.stateMachineMappings.put(AuthStatus.AUTHENTICATED, AwaitingBootstrapState.class);
            this.stateMachineMappings.put(AuthStatus.BOOTSTRAPPING, BootstrapInProgressState.class);
            this.stateMachineMappings.put(AuthStatus.CONNECTION_READY, ConnectionReadyState.class);
        }
    }

    protected abstract void sendInternal(ByteBuffer var1) throws IOException;

    private byte nextByte(ByteBuffer inputBuffer) throws IOException {
        this.getAtLeastBytes(inputBuffer, 1, ReadMode.ONLY_WHEN_EMPTY);
        return inputBuffer.get();
    }

    protected abstract void getAtLeastBytes(ByteBuffer var1, int var2, ReadMode var3) throws IOException;

    protected void readCompleteMessage(ByteBuffer inputBuffer) throws IOException {
        while (!StreamRemoteConnector.doesBufferHaveEOM(inputBuffer)) {
            if (inputBuffer.remaining() > 1024) {
                throw new TcProtocolException("Message corrupt, no EOM");
            }
            this.getAtLeastBytes(inputBuffer, 1, ReadMode.READ_MORE);
        }
    }

    @Override
    public void registerConnectorListener(RemoteConnectorListener listener) {
        this.connectorListeners.add(listener);
    }

    @Override
    public void registerConnectionChangeListener(ConnectionChangeListener listener) {
        this.connectionListeners.add(listener);
        this.executor.execute(() -> listener.connectionChange(this, this.getAuthenticationStatus()));
    }

    @Override
    public void notifyListeners(MenuCommand mc) {
        this.connectorListeners.forEach(listener -> listener.onCommand(this, mc));
    }

    protected void notifyConnection() {
        this.connectionListeners.forEach(listener -> listener.connectionChange(this, this.getAuthenticationStatus()));
    }

    protected void logByteBuffer(String msg, ByteBuffer inBuffer) {
        if (!this.logger.isLoggable(System.Logger.Level.DEBUG)) {
            return;
        }
        ByteBuffer bb = inBuffer.duplicate();
        StringBuilder sb = new StringBuilder(256);
        sb.append(msg).append(". Content: ");
        int len = Math.min(400, bb.remaining());
        for (int pos = 0; pos < len; ++pos) {
            byte dataByte = bb.get();
            if (dataByte > 31) {
                sb.append((char)dataByte);
                continue;
            }
            sb.append(String.format("<0x%02x>", dataByte));
        }
        this.logger.log(System.Logger.Level.DEBUG, sb.toString());
    }

    public static boolean doesBufferHaveEOM(ByteBuffer inputBuffer) {
        ByteBuffer bbCopy = inputBuffer.slice();
        boolean foundMsg = false;
        while (!foundMsg && bbCopy.hasRemaining()) {
            foundMsg = bbCopy.get() == 124 && bbCopy.hasRemaining() && bbCopy.get() == 2;
        }
        return foundMsg;
    }

    @Override
    public void changeState(AuthStatus desiredState) {
        Class<? extends RemoteConnectorState> state = this.stateMachineMappings.get((Object)desiredState);
        if (state == null) {
            throw new IllegalArgumentException(desiredState + " not available in mappings");
        }
        try {
            this.changeState(state.getConstructor(RemoteConnectorContext.class).newInstance(this));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(desiredState + " caused an exception", e);
        }
    }

    @Override
    public void changeState(RemoteConnectorState newState) {
        RemoteConnectorState oldState = this.connectorState.get();
        this.logger.log(System.Logger.Level.INFO, "Transition " + this.stateName(oldState) + "->" + this.stateName(newState) + " for " + this.getConnectionName());
        if (oldState != null) {
            oldState.exitState(newState);
        }
        this.connectorState.set(newState);
        newState.enterState();
        this.notifyConnection();
    }

    private String stateName(RemoteConnectorState state) {
        if (state == null) {
            return "NoState";
        }
        return state.getClass().getSimpleName();
    }

    @Override
    public RemoteInformation getRemoteParty() {
        return this.remoteParty.get();
    }

    @Override
    public void setRemoteParty(RemoteInformation remote) {
        this.remoteParty.set(remote);
    }

    @Override
    public AuthStatus getAuthenticationStatus() {
        return this.connectorState.get().getAuthenticationStatus();
    }

    @Override
    public void sendHeartbeat(int frequency, MenuHeartbeatCommand.HeartbeatMode mode) {
        try {
            this.sendMenuCommand(CommandFactory.newHeartbeatCommand(frequency, mode));
        }
        catch (IOException e) {
            this.logger.log(System.Logger.Level.ERROR, "Exception sending heartbeat on channel", (Throwable)e);
        }
    }

    @Override
    public void sendJoin() throws IOException {
        this.sendMenuCommand(CommandFactory.newJoinCommand(this.ourLocalId.getName(), this.ourLocalId.getUuid()));
    }

    @Override
    public void sendAcknowledgement(AckStatus ackStatus) throws IOException {
        this.sendMenuCommand(CommandFactory.newAcknowledgementCommand(CorrelationId.EMPTY_CORRELATION, ackStatus));
    }

    @Override
    public void sendPairing() throws IOException {
        this.sendMenuCommand(CommandFactory.newPairingCommand(this.ourLocalId.getName(), this.ourLocalId.getUuid()));
    }

    @Override
    public ScheduledExecutorService getScheduledExecutor() {
        return this.executor;
    }

    @Override
    public Clock getClock() {
        return this.clock;
    }

    public static enum ReadMode {
        ONLY_WHEN_EMPTY,
        READ_MORE;

    }
}

