/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.protocol;

import com.thecoderscorner.menu.remote.protocol.ApiPlatform;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProtocolUtil {
    private static AtomicReference<String> version = new AtomicReference();
    private static AtomicReference<Map<Integer, ApiPlatform>> keyToPlatform = new AtomicReference();
    private static Pattern versionPattern = Pattern.compile(".*(\\d+)\\.(\\d+).*");

    public static int getVersionFromProperties() {
        String ver = version.get();
        if (ver == null) {
            try {
                InputStream resourceAsStream = ProtocolUtil.class.getResourceAsStream("/japi-version.properties");
                Properties props = new Properties();
                props.load(resourceAsStream);
                ver = props.getProperty("build.version");
                Matcher verMatch = versionPattern.matcher(ver);
                if (verMatch.matches() && verMatch.groupCount() == 2) {
                    int major = Integer.parseInt(verMatch.group(1));
                    int minor = Integer.parseInt(verMatch.group(2));
                    return major * 100 + minor;
                }
            }
            catch (Exception e) {
                System.getLogger("ProtocolUtil").log(System.Logger.Level.ERROR, "Did not successfully obtain version", (Throwable)e);
            }
        }
        return 0;
    }

    public static ApiPlatform fromKeyToApiPlatform(int key) {
        if (keyToPlatform.get() == null) {
            HashMap<Integer, ApiPlatform> map = new HashMap<Integer, ApiPlatform>();
            for (ApiPlatform apiPlatform : ApiPlatform.values()) {
                map.put(apiPlatform.getKey(), apiPlatform);
            }
            keyToPlatform.set(Collections.unmodifiableMap(map));
        }
        return keyToPlatform.get().get(key);
    }
}

