/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.commands;

import com.thecoderscorner.menu.remote.commands.AckStatus;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommandType;
import com.thecoderscorner.menu.remote.protocol.CorrelationId;
import java.util.Objects;

public class MenuAcknowledgementCommand
implements MenuCommand {
    private final CorrelationId correlationId;
    private final AckStatus ackStatus;

    public MenuAcknowledgementCommand(CorrelationId correlationId, AckStatus ackStatus) {
        this.correlationId = correlationId;
        this.ackStatus = ackStatus;
    }

    public CorrelationId getCorrelationId() {
        return this.correlationId;
    }

    public AckStatus getAckStatus() {
        return this.ackStatus;
    }

    @Override
    public MenuCommandType getCommandType() {
        return MenuCommandType.ACKNOWLEDGEMENT;
    }

    public String toString() {
        return "MenuAcknowledgementCommand{correlationId=" + this.correlationId + ", ackStatus=" + this.ackStatus + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenuAcknowledgementCommand that = (MenuAcknowledgementCommand)o;
        return Objects.equals(this.correlationId, that.correlationId) && this.ackStatus == that.ackStatus;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.correlationId, this.ackStatus});
    }
}

