/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.states;

import com.thecoderscorner.menu.remote.AuthStatus;
import com.thecoderscorner.menu.remote.commands.MenuBootstrapCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommandType;
import com.thecoderscorner.menu.remote.states.BaseMessageProcessingState;
import com.thecoderscorner.menu.remote.states.RemoteConnectorContext;
import java.util.Set;

public class BootstrapInProgressState
extends BaseMessageProcessingState {
    private static final Set<MenuCommandType> BOOT_TYPES = Set.of(MenuCommandType.ANALOG_BOOT_ITEM, MenuCommandType.ACTION_BOOT_ITEM, MenuCommandType.SUBMENU_BOOT_ITEM, MenuCommandType.ENUM_BOOT_ITEM, MenuCommandType.BOOLEAN_BOOT_ITEM, MenuCommandType.TEXT_BOOT_ITEM, MenuCommandType.RUNTIME_LIST_BOOT, MenuCommandType.LARGE_NUM_BOOT_ITEM, MenuCommandType.FLOAT_BOOT_ITEM, MenuCommandType.REMOTE_BOOT_ITEM);

    public BootstrapInProgressState(RemoteConnectorContext context) {
        super(context);
    }

    @Override
    public AuthStatus getAuthenticationStatus() {
        return AuthStatus.BOOTSTRAPPING;
    }

    @Override
    public boolean canSendCommandToRemote(MenuCommand command) {
        return command.getCommandType() == MenuCommandType.HEARTBEAT;
    }

    @Override
    protected void processTimeout() {
        this.context.close();
        this.context.changeState(AuthStatus.AWAITING_CONNECTION);
        this.markDone();
    }

    @Override
    protected boolean processMessage(MenuCommand cmd) {
        if (this.checkIfThereIsAnHbEnd(cmd)) {
            return true;
        }
        if (cmd.getCommandType() == MenuCommandType.BOOTSTRAP) {
            MenuBootstrapCommand bs = (MenuBootstrapCommand)cmd;
            if (bs.getBootType() == MenuBootstrapCommand.BootType.END) {
                this.markDone();
                this.context.changeState(AuthStatus.CONNECTION_READY);
                this.context.notifyListeners(cmd);
                return true;
            }
            this.markDone();
            this.logger.log(System.Logger.Level.ERROR, "Received a boot start unexpectedly", this.context.getConnectionName());
            this.context.changeState(AuthStatus.AWAITING_CONNECTION);
            this.context.close();
            return true;
        }
        if (BOOT_TYPES.contains((Object)cmd.getCommandType())) {
            this.context.notifyListeners(cmd);
            return true;
        }
        if (cmd.getCommandType() == MenuCommandType.CHANGE_INT_FIELD) {
            this.context.notifyListeners(cmd);
            return true;
        }
        return false;
    }
}

