/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain;

import com.thecoderscorner.menu.domain.EditItemType;
import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.state.MenuState;
import com.thecoderscorner.menu.domain.state.StringMenuState;
import com.thecoderscorner.menu.domain.util.MenuItemVisitor;
import java.util.Objects;

public class EditableTextMenuItem
extends MenuItem<String> {
    private final int textLength;
    private final EditItemType itemType;

    public EditableTextMenuItem() {
        super("", -1, -1, null, false, false, true);
        this.textLength = 0;
        this.itemType = EditItemType.PLAIN_TEXT;
    }

    public EditableTextMenuItem(String name, int id, int eepromAddress, String functionName, int length, EditItemType itemType, boolean readOnly, boolean localOnly, boolean visible) {
        super(name, id, eepromAddress, functionName, readOnly, localOnly, visible);
        this.textLength = length;
        this.itemType = itemType;
    }

    public int getTextLength() {
        return this.textLength;
    }

    public EditItemType getItemType() {
        return this.itemType;
    }

    @Override
    public MenuState<String> newMenuState(String value, boolean changed, boolean active) {
        return new StringMenuState(this, changed, active, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EditableTextMenuItem that = (EditableTextMenuItem)o;
        return this.getTextLength() == that.getTextLength() && this.getId() == that.getId() && this.getEepromAddress() == that.getEepromAddress() && this.getItemType() == that.getItemType() && this.isVisible() == that.isVisible() && this.isReadOnly() == that.isReadOnly() && this.isLocalOnly() == that.isLocalOnly() && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getFunctionName(), that.getFunctionName());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getTextLength(), this.getName(), this.getId(), this.getEepromAddress(), this.getFunctionName(), this.getItemType()});
    }

    @Override
    public void accept(MenuItemVisitor visitor) {
        visitor.visit(this);
    }
}

