/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain;

import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.state.MenuState;
import com.thecoderscorner.menu.domain.state.PortableColor;
import com.thecoderscorner.menu.domain.state.PortableColorMenuState;
import com.thecoderscorner.menu.domain.util.MenuItemVisitor;
import java.util.Objects;

public class Rgb32MenuItem
extends MenuItem<PortableColor> {
    private final boolean includeAlphaChannel;

    public Rgb32MenuItem() {
        super("", -1, -1, null, false, false, true);
        this.includeAlphaChannel = false;
    }

    public Rgb32MenuItem(String name, int id, int eepromAddress, String functionName, boolean includeAlphaChannel, boolean readOnly, boolean localOnly, boolean visible) {
        super(name, id, eepromAddress, functionName, readOnly, localOnly, visible);
        this.includeAlphaChannel = includeAlphaChannel;
    }

    public boolean isIncludeAlphaChannel() {
        return this.includeAlphaChannel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rgb32MenuItem that = (Rgb32MenuItem)o;
        return this.getId() == that.getId() && this.getEepromAddress() == that.getEepromAddress() && this.isReadOnly() == that.isReadOnly() && this.isLocalOnly() == that.isLocalOnly() && this.isVisible() == that.isVisible() && this.includeAlphaChannel == that.includeAlphaChannel && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getFunctionName(), that.getFunctionName());
    }

    public int hashCode() {
        return Objects.hash(this.includeAlphaChannel, this.getId(), this.getEepromAddress(), this.getFunctionName(), this.isReadOnly());
    }

    @Override
    public MenuState<PortableColor> newMenuState(PortableColor value, boolean changed, boolean active) {
        return new PortableColorMenuState(this, changed, active, value);
    }

    @Override
    public void accept(MenuItemVisitor visitor) {
        visitor.visit(this);
    }
}

