/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain;

import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.state.CurrentScrollPosition;
import com.thecoderscorner.menu.domain.state.CurrentScrollPositionMenuState;
import com.thecoderscorner.menu.domain.state.MenuState;
import com.thecoderscorner.menu.domain.util.MenuItemVisitor;

public class ScrollChoiceMenuItem
extends MenuItem<CurrentScrollPosition> {
    private final int itemWidth;
    private final int eepromOffset;
    private final int numEntries;
    private final ScrollChoiceMode choiceMode;
    private final String variable;

    public ScrollChoiceMenuItem() {
        super("", -1, -1, null, false, false, true);
        this.variable = null;
        this.choiceMode = ScrollChoiceMode.ARRAY_IN_EEPROM;
        this.eepromOffset = 0;
        this.numEntries = 0;
        this.itemWidth = 0;
    }

    public ScrollChoiceMenuItem(String name, int id, int eepromAddress, String functionName, int itemWidth, int eepromOffset, int numEntries, ScrollChoiceMode mode, String variable, boolean readOnly, boolean localOnly, boolean visible) {
        super(name, id, eepromAddress, functionName, readOnly, localOnly, visible);
        this.numEntries = numEntries;
        this.itemWidth = itemWidth;
        this.eepromOffset = eepromOffset;
        this.choiceMode = mode;
        this.variable = variable;
    }

    public int getItemWidth() {
        return this.itemWidth;
    }

    public int getEepromOffset() {
        return this.eepromOffset;
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public ScrollChoiceMode getChoiceMode() {
        return this.choiceMode;
    }

    public String getVariable() {
        return this.variable;
    }

    @Override
    public MenuState<CurrentScrollPosition> newMenuState(CurrentScrollPosition value, boolean changed, boolean active) {
        return new CurrentScrollPositionMenuState(this, changed, active, value);
    }

    @Override
    public void accept(MenuItemVisitor visitor) {
        visitor.visit(this);
    }

    public static enum ScrollChoiceMode {
        ARRAY_IN_EEPROM,
        ARRAY_IN_RAM,
        CUSTOM_RENDERFN;

    }
}

