/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain.state;

import java.util.Objects;

public class CurrentScrollPosition {
    private final int position;
    private final String value;

    public CurrentScrollPosition(int position, String value) {
        this.position = position;
        this.value = value;
    }

    public CurrentScrollPosition(String text) {
        int splitPoint = text.indexOf(45);
        if (splitPoint != -1) {
            String numStr = text.substring(0, splitPoint);
            int pos = 0;
            try {
                pos = Integer.parseInt(numStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.position = pos;
            this.value = text.substring(splitPoint + 1);
            return;
        }
        this.position = 0;
        this.value = "Unknown";
    }

    public int getPosition() {
        return this.position;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.position + "-" + this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CurrentScrollPosition that = (CurrentScrollPosition)o;
        return this.position == that.position && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.position, this.value);
    }
}

