/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote;

import com.thecoderscorner.menu.domain.ActionMenuItem;
import com.thecoderscorner.menu.domain.AnalogMenuItem;
import com.thecoderscorner.menu.domain.BooleanMenuItem;
import com.thecoderscorner.menu.domain.EditableLargeNumberMenuItem;
import com.thecoderscorner.menu.domain.EditableTextMenuItem;
import com.thecoderscorner.menu.domain.EnumMenuItem;
import com.thecoderscorner.menu.domain.FloatMenuItem;
import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.Rgb32MenuItem;
import com.thecoderscorner.menu.domain.RuntimeListMenuItem;
import com.thecoderscorner.menu.domain.ScrollChoiceMenuItem;
import com.thecoderscorner.menu.domain.SubMenuItem;
import com.thecoderscorner.menu.domain.state.CurrentScrollPosition;
import com.thecoderscorner.menu.domain.state.MenuTree;
import com.thecoderscorner.menu.domain.state.PortableColor;
import com.thecoderscorner.menu.domain.util.MenuItemVisitor;
import com.thecoderscorner.menu.remote.AuthStatus;
import com.thecoderscorner.menu.remote.RemoteConnector;
import com.thecoderscorner.menu.remote.RemoteControllerListener;
import com.thecoderscorner.menu.remote.RemoteInformation;
import com.thecoderscorner.menu.remote.commands.AckStatus;
import com.thecoderscorner.menu.remote.commands.BootItemMenuCommand;
import com.thecoderscorner.menu.remote.commands.CommandFactory;
import com.thecoderscorner.menu.remote.commands.DialogMode;
import com.thecoderscorner.menu.remote.commands.MenuAcknowledgementCommand;
import com.thecoderscorner.menu.remote.commands.MenuBootstrapCommand;
import com.thecoderscorner.menu.remote.commands.MenuButtonType;
import com.thecoderscorner.menu.remote.commands.MenuChangeCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.commands.MenuDialogCommand;
import com.thecoderscorner.menu.remote.protocol.CorrelationId;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;

public class RemoteMenuController {
    private final System.Logger logger = System.getLogger(this.getClass().getSimpleName());
    private final RemoteConnector connector;
    private final MenuTree managedMenu;
    private final AtomicReference<RemoteInformation> remoteParty = new AtomicReference<RemoteInformation>(RemoteInformation.NOT_CONNECTED);
    private final ConcurrentMap<CorrelationId, MenuItem> itemsInProgress = new ConcurrentHashMap<CorrelationId, MenuItem>();
    private final List<RemoteControllerListener> listeners = new CopyOnWriteArrayList<RemoteControllerListener>();

    public RemoteMenuController(RemoteConnector connector, MenuTree managedMenu) {
        this.connector = connector;
        this.managedMenu = managedMenu;
    }

    public void start() {
        this.connector.registerConnectorListener(this::onCommandReceived);
        this.connector.registerConnectionChangeListener(this::onConnectionChange);
        this.connector.start();
    }

    private void onConnectionChange(RemoteConnector remoteConnector, AuthStatus status) {
        this.logger.log(System.Logger.Level.INFO, "Connection state changed to connected = " + status);
        if (status == AuthStatus.AWAITING_CONNECTION) {
            this.itemsInProgress.forEach((key, item) -> this.listeners.forEach(rcl -> rcl.ackReceived((CorrelationId)key, (MenuItem)item, AckStatus.UNKNOWN_ERROR)));
            this.itemsInProgress.clear();
        }
        this.listeners.forEach(l -> l.connectionState(this.remoteParty.get(), status));
    }

    public void stop() {
        this.connector.stop();
    }

    protected void sendCommand(MenuCommand command) {
        try {
            this.connector.sendMenuCommand(command);
        }
        catch (IOException e) {
            this.logger.log(System.Logger.Level.ERROR, "Error while writing out command", (Throwable)e);
            this.connector.close();
        }
    }

    public CorrelationId sendDialogAction(MenuButtonType buttonType) {
        CorrelationId correlationId = new CorrelationId();
        this.sendCommand(CommandFactory.newDialogCommand(DialogMode.ACTION, "", "", buttonType, buttonType, correlationId));
        return correlationId;
    }

    public CorrelationId sendDeltaUpdate(MenuItem item, int deltaChange) {
        CorrelationId correlationId = new CorrelationId();
        this.itemsInProgress.put(correlationId, item);
        this.sendCommand(CommandFactory.newDeltaChangeCommand(correlationId, item, deltaChange));
        return correlationId;
    }

    public CorrelationId sendAbsoluteUpdate(MenuItem item, Object newValue) {
        CorrelationId correlationId = new CorrelationId();
        this.itemsInProgress.put(correlationId, item);
        this.sendCommand(CommandFactory.newAbsoluteMenuChangeCommand(correlationId, item, newValue));
        return correlationId;
    }

    public RemoteConnector getConnector() {
        return this.connector;
    }

    public boolean isTreeFullyPopulated() {
        return this.connector.getAuthenticationStatus() == AuthStatus.CONNECTION_READY;
    }

    public void addListener(RemoteControllerListener listener) {
        this.listeners.add(listener);
    }

    private void onCommandReceived(RemoteConnector remoteConnector, MenuCommand menuCommand) {
        switch (menuCommand.getCommandType()) {
            case ACKNOWLEDGEMENT: {
                this.onAcknowledgementCommand((MenuAcknowledgementCommand)menuCommand);
                break;
            }
            case ANALOG_BOOT_ITEM: 
            case ENUM_BOOT_ITEM: 
            case BOOLEAN_BOOT_ITEM: 
            case SUBMENU_BOOT_ITEM: 
            case TEXT_BOOT_ITEM: 
            case LARGE_NUM_BOOT_ITEM: 
            case REMOTE_BOOT_ITEM: 
            case FLOAT_BOOT_ITEM: 
            case ACTION_BOOT_ITEM: 
            case RUNTIME_LIST_BOOT: 
            case BOOT_RGB_COLOR: 
            case BOOT_SCROLL_CHOICE: {
                this.onMenuItemBoot((BootItemMenuCommand)menuCommand);
                break;
            }
            case BOOTSTRAP: {
                this.onBootstrap((MenuBootstrapCommand)menuCommand);
                break;
            }
            case CHANGE_INT_FIELD: {
                this.onChangeField((MenuChangeCommand)menuCommand);
                break;
            }
            case DIALOG_UPDATE: {
                this.onDialogChange((MenuDialogCommand)menuCommand);
            }
        }
    }

    private void onBootstrap(MenuBootstrapCommand menuCommand) {
        if (menuCommand.getBootType() == MenuBootstrapCommand.BootType.END) {
            this.listeners.forEach(RemoteControllerListener::treeFullyPopulated);
        }
    }

    private void onDialogChange(MenuDialogCommand menuCommand) {
        this.listeners.forEach(l -> l.dialogUpdate(menuCommand.getDialogMode(), menuCommand.getHeader(), menuCommand.getBuffer(), menuCommand.getButton1(), menuCommand.getButton2()));
    }

    private void onAcknowledgementCommand(MenuAcknowledgementCommand menuCommand) {
        MenuItem item = (MenuItem)this.itemsInProgress.get(menuCommand.getCorrelationId());
        this.listeners.forEach(rcl -> rcl.ackReceived(menuCommand.getCorrelationId(), item, menuCommand.getAckStatus()));
    }

    private void onMenuItemBoot(BootItemMenuCommand menuCommand) {
        this.managedMenu.addOrUpdateItem(menuCommand.getSubMenuId(), (MenuItem)menuCommand.getMenuItem());
        this.managedMenu.changeItem(menuCommand.getMenuItem(), menuCommand.newMenuState(this.managedMenu.getMenuState(menuCommand.getMenuItem())));
        this.listeners.forEach(l -> l.menuItemChanged((MenuItem)menuCommand.getMenuItem(), false));
    }

    private void onChangeField(final MenuChangeCommand menuCommand) {
        if (!this.isTreeFullyPopulated()) {
            return;
        }
        this.managedMenu.getMenuById(menuCommand.getMenuItemId()).ifPresent(item -> item.accept(new MenuItemVisitor(){

            @Override
            public void visit(AnalogMenuItem item) {
                RemoteMenuController.this.managedMenu.changeItem(item, item.newMenuState(Integer.valueOf(menuCommand.getValue()), true, false));
                RemoteMenuController.this.listeners.forEach(l -> l.menuItemChanged(item, true));
            }

            @Override
            public void visit(BooleanMenuItem item) {
                RemoteMenuController.this.managedMenu.changeItem(item, item.newMenuState(Integer.valueOf(menuCommand.getValue()) != 0, true, false));
                RemoteMenuController.this.listeners.forEach(l -> l.menuItemChanged(item, true));
            }

            @Override
            public void visit(EnumMenuItem item) {
                RemoteMenuController.this.managedMenu.changeItem(item, item.newMenuState(Integer.valueOf(menuCommand.getValue()), true, false));
                RemoteMenuController.this.listeners.forEach(l -> l.menuItemChanged(item, true));
            }

            @Override
            public void visit(SubMenuItem item) {
            }

            @Override
            public void visit(EditableTextMenuItem item) {
                RemoteMenuController.this.managedMenu.changeItem(item, item.newMenuState(menuCommand.getValue(), true, false));
                RemoteMenuController.this.listeners.forEach(l -> l.menuItemChanged(item, true));
            }

            @Override
            public void visit(EditableLargeNumberMenuItem item) {
                String val = menuCommand.getValue();
                if (val != null && val.contains("[")) {
                    val = val.replaceAll("[\\[\\]]", "");
                } else if (val == null) {
                    val = "0.0";
                }
                BigDecimal dec = new BigDecimal(val);
                RemoteMenuController.this.managedMenu.changeItem(item, item.newMenuState(dec, true, false));
                RemoteMenuController.this.listeners.forEach(l -> l.menuItemChanged(item, true));
            }

            @Override
            public void visit(FloatMenuItem item) {
                RemoteMenuController.this.managedMenu.changeItem(item, item.newMenuState(Float.valueOf(menuCommand.getValue()), true, false));
                RemoteMenuController.this.listeners.forEach(l -> l.menuItemChanged(item, true));
            }

            @Override
            public void visit(Rgb32MenuItem item) {
                RemoteMenuController.this.managedMenu.changeItem(item, item.newMenuState(new PortableColor(menuCommand.getValue()), true, false));
                RemoteMenuController.this.listeners.forEach(l -> l.menuItemChanged(item, true));
            }

            @Override
            public void visit(ScrollChoiceMenuItem item) {
                RemoteMenuController.this.managedMenu.changeItem(item, item.newMenuState(new CurrentScrollPosition(menuCommand.getValue()), true, false));
                RemoteMenuController.this.listeners.forEach(l -> l.menuItemChanged(item, true));
            }

            @Override
            public void visit(ActionMenuItem item) {
            }

            @Override
            public void visit(RuntimeListMenuItem listItem) {
            }
        }));
    }

    public MenuTree getManagedMenu() {
        return this.managedMenu;
    }
}

