/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.commands;

import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.state.MenuState;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import java.util.Objects;

public abstract class BootItemMenuCommand<T extends MenuItem, V>
implements MenuCommand {
    private final T menuItem;
    private final V currentValue;
    private final int subMenuId;

    protected BootItemMenuCommand(int subMenuId, T menuItem, V currentValue) {
        this.menuItem = menuItem;
        this.subMenuId = subMenuId;
        this.currentValue = currentValue;
    }

    public int getSubMenuId() {
        return this.subMenuId;
    }

    public T getMenuItem() {
        return this.menuItem;
    }

    public V getCurrentValue() {
        return this.currentValue;
    }

    public MenuState<V> newMenuState(MenuState<V> oldState) {
        if (oldState == null) {
            oldState = ((MenuItem)this.menuItem).newMenuState(this.currentValue, false, false);
        }
        return this.internalNewMenuState(oldState);
    }

    protected abstract MenuState<V> internalNewMenuState(MenuState<V> var1);

    public String toString() {
        return "BootItemMenuCommand[" + this.getCommandType() + "] {menuItem=" + this.menuItem + ", currentValue=" + this.currentValue + ", subMenuId=" + this.subMenuId + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BootItemMenuCommand that = (BootItemMenuCommand)o;
        return this.getSubMenuId() == that.getSubMenuId() && Objects.equals(this.getMenuItem(), that.getMenuItem()) && Objects.equals(this.getCurrentValue(), that.getCurrentValue());
    }

    public int hashCode() {
        return Objects.hash(this.getMenuItem(), this.getCurrentValue(), this.getSubMenuId());
    }
}

