/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain.state;

import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.SubMenuItem;
import com.thecoderscorner.menu.domain.state.MenuState;
import com.thecoderscorner.menu.domain.util.MenuItemHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MenuTree {
    public static final SubMenuItem ROOT = new SubMenuItem("Root", null, 0, -1, false, true, false);
    private static final int EXPECTED_MAX_VALUES = 256;
    private final Map<Integer, MenuState<?>> menuStates = new ConcurrentHashMap(256);
    private final Map<MenuItem, ArrayList<MenuItem>> subMenuItems = new HashMap<MenuItem, ArrayList<MenuItem>>(32);

    public MenuTree() {
        this.subMenuItems.put(ROOT, new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMenuItem(SubMenuItem parent, MenuItem item) {
        SubMenuItem subMenu = parent != null ? parent : ROOT;
        Map<MenuItem, ArrayList<MenuItem>> map = this.subMenuItems;
        synchronized (map) {
            ArrayList subMenuChildren = this.subMenuItems.computeIfAbsent(subMenu, sm -> new ArrayList());
            subMenuChildren.add(item);
            if (item.hasChildren()) {
                this.subMenuItems.put(item, new ArrayList());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdateItem(int parentId, MenuItem item) {
        Map<MenuItem, ArrayList<MenuItem>> map = this.subMenuItems;
        synchronized (map) {
            this.getSubMenuById(parentId).ifPresent(subMenu -> {
                if (this.getMenuItems((MenuItem)subMenu).stream().anyMatch(it -> it.getId() == item.getId())) {
                    this.replaceMenuById(MenuItemHelper.asSubMenu(subMenu), item);
                } else {
                    this.addMenuItem(MenuItemHelper.asSubMenu(subMenu), item);
                }
            });
        }
    }

    public Optional<SubMenuItem> getSubMenuById(int parentId) {
        return this.getAllSubMenus().stream().filter(subMenu -> subMenu.getId() == parentId).map(m -> (SubMenuItem)m).findFirst();
    }

    public Optional<MenuItem> getMenuById(int id) {
        MenuState<?> state = this.menuStates.get(id);
        if (state != null) {
            return Optional.of(state.getItem());
        }
        Optional<MenuItem> maybeSubMenuId = this.getAllSubMenus().stream().filter(item -> item.getId() == id).findFirst();
        if (maybeSubMenuId.isPresent()) {
            return maybeSubMenuId;
        }
        return this.getAllMenuItems().stream().filter(item -> item.getId() == id).findFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceMenuById(MenuItem toReplace) {
        Map<MenuItem, ArrayList<MenuItem>> map = this.subMenuItems;
        synchronized (map) {
            this.replaceMenuById(this.findParent(toReplace), toReplace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceMenuById(SubMenuItem subMenu, MenuItem toReplace) {
        Map<MenuItem, ArrayList<MenuItem>> map = this.subMenuItems;
        synchronized (map) {
            ArrayList<MenuItem> list = this.subMenuItems.get(subMenu);
            int idx = -1;
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).getId() != toReplace.getId()) continue;
                idx = i;
            }
            if (idx != -1) {
                MenuItem oldItem = list.set(idx, toReplace);
                if (toReplace.hasChildren()) {
                    ArrayList<MenuItem> items = this.subMenuItems.remove(oldItem);
                    this.subMenuItems.put(toReplace, items);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveItem(SubMenuItem parent, MenuItem newItem, MoveType moveType) {
        Map<MenuItem, ArrayList<MenuItem>> map = this.subMenuItems;
        synchronized (map) {
            ArrayList<MenuItem> items = this.subMenuItems.get(parent);
            int idx = items.indexOf(newItem);
            if (idx < 0) {
                return;
            }
            items.remove(idx);
            int n = idx = moveType == MoveType.MOVE_UP ? --idx : ++idx;
            if (idx < 0) {
                idx = 0;
            }
            if (idx >= items.size()) {
                items.add(newItem);
            } else {
                items.add(idx, newItem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMenuItem(MenuItem toRemove) {
        Map<MenuItem, ArrayList<MenuItem>> map = this.subMenuItems;
        synchronized (map) {
            this.removeMenuItem(this.findParent(toRemove), toRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubMenuItem findParent(MenuItem toFind) {
        Map<MenuItem, ArrayList<MenuItem>> map = this.subMenuItems;
        synchronized (map) {
            SubMenuItem parent = ROOT;
            for (Map.Entry<MenuItem, ArrayList<MenuItem>> entry : this.subMenuItems.entrySet()) {
                for (MenuItem item : entry.getValue()) {
                    if (item.getId() != toFind.getId()) continue;
                    parent = MenuItemHelper.asSubMenu(entry.getKey());
                }
            }
            return parent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMenuItem(SubMenuItem parent, MenuItem item) {
        SubMenuItem subMenu = parent != null ? parent : ROOT;
        Map<MenuItem, ArrayList<MenuItem>> map = this.subMenuItems;
        synchronized (map) {
            ArrayList<MenuItem> subMenuChildren = this.subMenuItems.get(subMenu);
            if (subMenuChildren == null) {
                throw new UnsupportedOperationException("Menu element not found");
            }
            subMenuChildren.remove(item);
            if (item.hasChildren()) {
                this.subMenuItems.remove(item);
            }
        }
        this.menuStates.remove(item.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<MenuItem> getAllSubMenus() {
        Map<MenuItem, ArrayList<MenuItem>> map = this.subMenuItems;
        synchronized (map) {
            return this.subMenuItems.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItems(MenuItem item) {
        Map<MenuItem, ArrayList<MenuItem>> map = this.subMenuItems;
        synchronized (map) {
            ArrayList<MenuItem> menuItems = this.subMenuItems.get(item);
            return menuItems == null ? null : Collections.unmodifiableList(menuItems);
        }
    }

    public Collection<MenuItem> getAllMenuItems() {
        HashSet<MenuItem> toReturn = new HashSet<MenuItem>(128);
        Set<MenuItem> subs = this.getAllSubMenus();
        for (MenuItem sub : subs) {
            toReturn.add(sub);
            toReturn.addAll(this.getMenuItems(sub));
        }
        return toReturn;
    }

    public <T> void changeItem(MenuItem<T> item, MenuState<T> menuState) {
        this.menuStates.put(item.getId(), menuState);
    }

    public <T> MenuState<T> getMenuState(MenuItem<T> item) {
        return this.menuStates.get(item.getId());
    }

    public static enum MoveType {
        MOVE_UP,
        MOVE_DOWN;

    }
}

