/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain;

import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.state.CurrentScrollPosition;
import com.thecoderscorner.menu.domain.state.CurrentScrollPositionMenuState;
import com.thecoderscorner.menu.domain.state.MenuState;
import com.thecoderscorner.menu.domain.util.MenuItemVisitor;
import java.util.Objects;

public class ScrollChoiceMenuItem
extends MenuItem<CurrentScrollPosition> {
    private final int itemWidth;
    private final int eepromOffset;
    private final int numEntries;
    private final ScrollChoiceMode choiceMode;
    private final String variable;

    public ScrollChoiceMenuItem() {
        super("", null, -1, -1, null, false, false, true);
        this.variable = null;
        this.choiceMode = ScrollChoiceMode.ARRAY_IN_EEPROM;
        this.eepromOffset = 0;
        this.numEntries = 0;
        this.itemWidth = 0;
    }

    public ScrollChoiceMenuItem(String name, String varName, int id, int eepromAddress, String functionName, int itemWidth, int eepromOffset, int numEntries, ScrollChoiceMode mode, String variable, boolean readOnly, boolean localOnly, boolean visible) {
        super(name, varName, id, eepromAddress, functionName, readOnly, localOnly, visible);
        this.numEntries = numEntries;
        this.itemWidth = itemWidth;
        this.eepromOffset = eepromOffset;
        this.choiceMode = mode;
        this.variable = variable;
    }

    public int getItemWidth() {
        return this.itemWidth;
    }

    public int getEepromOffset() {
        return this.eepromOffset;
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public ScrollChoiceMode getChoiceMode() {
        return this.choiceMode;
    }

    public String getVariable() {
        return this.variable;
    }

    @Override
    public MenuState<CurrentScrollPosition> newMenuState(CurrentScrollPosition value, boolean changed, boolean active) {
        return new CurrentScrollPositionMenuState(this, changed, active, value);
    }

    @Override
    public void accept(MenuItemVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScrollChoiceMenuItem that = (ScrollChoiceMenuItem)o;
        return this.getId() == that.getId() && this.getEepromAddress() == that.getEepromAddress() && this.isReadOnly() == that.isReadOnly() && this.isVisible() == that.isVisible() && this.isLocalOnly() == that.isLocalOnly() && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getFunctionName(), that.getFunctionName()) && Objects.equals(this.getVariableName(), that.getVariableName()) && this.choiceMode == that.getChoiceMode() && this.itemWidth == that.itemWidth && this.numEntries == that.numEntries && this.eepromOffset == that.eepromOffset && Objects.equals(this.variable, that.variable);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getName(), this.getId(), this.getEepromAddress(), this.getFunctionName(), this.getVariableName(), this.isReadOnly(), this.isLocalOnly(), this.choiceMode, this.itemWidth, this.numEntries, this.eepromOffset, this.variable});
    }

    public static enum ScrollChoiceMode {
        ARRAY_IN_EEPROM,
        ARRAY_IN_RAM,
        CUSTOM_RENDERFN;

    }
}

