/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.protocol;

import com.thecoderscorner.menu.remote.AuthStatus;
import com.thecoderscorner.menu.remote.RemoteConnector;
import com.thecoderscorner.menu.remote.commands.MenuCommandType;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class PairingHelper {
    private final System.Logger logger = System.getLogger("Pairing");
    private final RemoteConnector connector;
    private final ScheduledExecutorService executorService;
    private final Optional<Consumer<AuthStatus>> statusConsumer;
    private volatile boolean authenticatedSuccessfully = false;

    public PairingHelper(RemoteConnector connector, ScheduledExecutorService executorService, Optional<Consumer<AuthStatus>> updateFn) {
        this.connector = connector;
        this.executorService = executorService;
        this.statusConsumer = updateFn;
    }

    public boolean attemptPairing() {
        this.logger.log(System.Logger.Level.INFO, "Pairing process started for " + this.connector.getConnectionName());
        CountDownLatch latch = new CountDownLatch(1);
        this.connector.registerConnectionChangeListener((conn, authStatus) -> {
            this.statusConsumer.ifPresent(consumer -> consumer.accept(authStatus));
            if (authStatus == AuthStatus.AUTHENTICATED || authStatus == AuthStatus.FAILED_AUTH) {
                this.authenticatedSuccessfully = authStatus == AuthStatus.AUTHENTICATED;
                this.logger.log(System.Logger.Level.INFO, "Pairing process completed for " + this.connector.getConnectionName() + " with " + authStatus);
                latch.countDown();
            }
        });
        this.connector.registerConnectorListener((connector1, command) -> {
            if (command.getCommandType() == MenuCommandType.JOIN) {
                this.logger.log(System.Logger.Level.INFO, "Join msg from " + command);
            }
        });
        this.connector.start();
        try {
            if (!latch.await(20L, TimeUnit.SECONDS)) {
                this.logger.log(System.Logger.Level.INFO, "Timeout pairing with " + this.connector.getConnectionName());
            }
        }
        catch (InterruptedException e) {
            this.logger.log(System.Logger.Level.ERROR, "Pairing thread interrupted: " + this.connector.getConnectionName());
            Thread.currentThread().interrupt();
        }
        this.connector.close();
        this.connector.stop();
        this.logger.log(System.Logger.Level.INFO, "Pairing finished for " + this.connector.getConnectionName());
        return this.authenticatedSuccessfully;
    }
}

