/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain;

import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.state.MenuState;
import com.thecoderscorner.menu.domain.state.StringListMenuState;
import com.thecoderscorner.menu.domain.util.MenuItemVisitor;
import java.util.List;
import java.util.Objects;

public class RuntimeListMenuItem
extends MenuItem<List<String>> {
    private final int initialRows;

    public RuntimeListMenuItem() {
        super("", null, 0, 0, "", false, false, true);
        this.initialRows = 0;
    }

    public RuntimeListMenuItem(String name, String varName, int id, int eepromAddress, String functionName, boolean readOnly, boolean localOnly, boolean visible, int initialRows) {
        super(name, varName, id, eepromAddress, functionName, readOnly, localOnly, visible);
        this.initialRows = initialRows;
    }

    public int getInitialRows() {
        return this.initialRows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuntimeListMenuItem that = (RuntimeListMenuItem)o;
        return this.getInitialRows() == that.getInitialRows() && this.getId() == that.getId() && this.getEepromAddress() == that.getEepromAddress() && this.isReadOnly() == that.isReadOnly() && this.isLocalOnly() == that.isLocalOnly() && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getFunctionName(), that.getFunctionName()) && Objects.equals(this.getVariableName(), that.getVariableName());
    }

    public int hashCode() {
        return Objects.hash(this.getInitialRows(), this.getName(), this.getId(), this.getEepromAddress(), this.getFunctionName(), this.isReadOnly(), this.getVariableName());
    }

    @Override
    public MenuState<List<String>> newMenuState(List<String> value, boolean changed, boolean active) {
        return new StringListMenuState((MenuItem<List<String>>)this, changed, active, value);
    }

    @Override
    public void accept(MenuItemVisitor visitor) {
        visitor.visit(this);
    }
}

