/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.socket;

import com.thecoderscorner.menu.remote.AuthStatus;
import com.thecoderscorner.menu.remote.ConnectMode;
import com.thecoderscorner.menu.remote.LocalIdentifier;
import com.thecoderscorner.menu.remote.MenuCommandProtocol;
import com.thecoderscorner.menu.remote.StreamRemoteConnector;
import com.thecoderscorner.menu.remote.states.NoOperationInitialState;
import com.thecoderscorner.menu.remote.states.PairingAuthFailedState;
import com.thecoderscorner.menu.remote.states.SocketAwaitJoinState;
import com.thecoderscorner.menu.remote.states.StreamNotConnectedState;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.time.Clock;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;

public class SocketBasedConnector
extends StreamRemoteConnector {
    private final String remoteHost;
    private final int remotePort;
    private final AtomicReference<SocketChannel> socketChannel = new AtomicReference();

    public SocketBasedConnector(LocalIdentifier localId, ScheduledExecutorService executor, Clock clock, MenuCommandProtocol protocol, String remoteHost, int remotePort, ConnectMode mode) {
        super(localId, protocol, executor, clock);
        this.remoteHost = remoteHost;
        this.remotePort = remotePort;
        this.applyStates(mode);
    }

    private void applyStates(ConnectMode mode) {
        this.stateMachineMappings.put(AuthStatus.NOT_STARTED, NoOperationInitialState.class);
        this.stateMachineMappings.put(AuthStatus.AWAITING_CONNECTION, StreamNotConnectedState.class);
        this.stateMachineMappings.put(AuthStatus.ESTABLISHED_CONNECTION, SocketAwaitJoinState.class);
        this.stateMachineMappings.put(AuthStatus.FAILED_AUTH, PairingAuthFailedState.class);
        this.handleCoreConnectionStates(mode);
    }

    @Override
    public void start() {
        this.connectionLog(System.Logger.Level.INFO, "Starting ethernet connector" + this.remoteHost);
        this.changeState(AuthStatus.AWAITING_CONNECTION);
        this.startThreadProc();
    }

    @Override
    public void stop() {
        this.stopThreadProc();
        this.changeState(AuthStatus.NOT_STARTED);
    }

    @Override
    public void performConnection() throws IOException {
        if (this.socketChannel.get() == null || !this.socketChannel.get().isConnected()) {
            SocketChannel ch = SocketChannel.open();
            ch.socket().connect(new InetSocketAddress(this.remoteHost, this.remotePort), 10000);
            this.socketChannel.set(ch);
        }
    }

    @Override
    protected void getAtLeastBytes(ByteBuffer inputBuffer, int len, StreamRemoteConnector.ReadMode mode) throws IOException {
        if (mode == StreamRemoteConnector.ReadMode.ONLY_WHEN_EMPTY && inputBuffer.remaining() >= len) {
            return;
        }
        SocketChannel sc = this.socketChannel.get();
        if (sc == null || !this.isDeviceConnected()) {
            throw new IOException("Socket closed during read");
        }
        do {
            inputBuffer.compact();
            int actual = sc.read(inputBuffer);
            inputBuffer.flip();
            if (actual > 0) continue;
            throw new IOException("Socket probably closed, read return was 0 or less");
        } while (inputBuffer.remaining() < len);
    }

    @Override
    protected void sendInternal(ByteBuffer outputBuffer) throws IOException {
        SocketChannel sc = this.socketChannel.get();
        while (this.isDeviceConnected() && sc != null && outputBuffer.hasRemaining()) {
            int len = sc.write(outputBuffer);
            if (len > 0) continue;
            throw new IOException("Socket closed - returned 0 or less from write");
        }
    }

    @Override
    public boolean isDeviceConnected() {
        SocketChannel sc = this.socketChannel.get();
        return sc != null && sc.isConnected();
    }

    @Override
    public String getConnectionName() {
        return "TCP " + this.remoteHost + ":" + this.remotePort;
    }

    @Override
    public void close() {
        this.connectionLog(System.Logger.Level.INFO, "Closing socket " + this.getConnectionName());
        SocketChannel sc = this.socketChannel.get();
        if (sc != null) {
            try {
                sc.close();
            }
            catch (IOException e) {
                this.connectionLog(System.Logger.Level.ERROR, "Unexpected error closing socket", e);
            }
        }
        super.close();
        this.socketChannel.set(null);
    }
}

