/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.states;

import com.thecoderscorner.menu.remote.AuthStatus;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.states.RemoteConnectorContext;
import com.thecoderscorner.menu.remote.states.RemoteConnectorState;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class StreamNotConnectedState
implements RemoteConnectorState {
    private final System.Logger logger = System.getLogger(this.getClass().getSimpleName());
    private final RemoteConnectorContext context;
    private final AtomicInteger connectionDelay = new AtomicInteger(2000);
    private final AtomicBoolean exited = new AtomicBoolean(false);

    public StreamNotConnectedState(RemoteConnectorContext context) {
        this.context = context;
    }

    @Override
    public void runLoop() throws InterruptedException {
        if (!this.exited.get() && this.context.isDeviceConnected()) {
            this.context.changeState(AuthStatus.ESTABLISHED_CONNECTION);
            return;
        }
        while (!this.exited.get() && !this.context.isDeviceConnected()) {
            try {
                this.logger.log(System.Logger.Level.INFO, "Attempting connection to " + this.context.getConnectionName());
                if (!this.context.isDeviceConnected()) {
                    this.context.performConnection();
                }
                if (!this.context.isDeviceConnected()) continue;
                this.logger.log(System.Logger.Level.INFO, "Connection established to " + this.context.getConnectionName());
                this.context.changeState(AuthStatus.ESTABLISHED_CONNECTION);
                return;
            }
            catch (Exception e) {
                this.logger.log(System.Logger.Level.ERROR, "Exception while trying to connect to " + this.context.getConnectionName(), (Throwable)e);
            }
            finally {
                if (this.context.isDeviceConnected()) continue;
                Thread.sleep(this.connectionDelay.get());
                if (this.connectionDelay.get() >= 10000) continue;
                this.connectionDelay.addAndGet(this.connectionDelay.get());
            }
        }
    }

    @Override
    public void enterState() {
    }

    @Override
    public void exitState(RemoteConnectorState nextState) {
        this.exited.set(true);
    }

    @Override
    public AuthStatus getAuthenticationStatus() {
        return AuthStatus.AWAITING_CONNECTION;
    }

    @Override
    public boolean canSendCommandToRemote(MenuCommand command) {
        return false;
    }
}

