/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain;

import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.util.MenuItemVisitor;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class EnumMenuItem
extends MenuItem {
    private final List<String> enumEntries;

    public EnumMenuItem() {
        super("", null, -1, -1, null, false, false, true);
        this.enumEntries = Collections.emptyList();
    }

    public EnumMenuItem(String name, String varName, int id, int eepromAddress, String functionName, List<String> enumEntries, boolean readOnly, boolean localOnly, boolean visible) {
        super(name, varName, id, eepromAddress, functionName, readOnly, localOnly, visible);
        this.enumEntries = enumEntries;
    }

    public List<String> getEnumEntries() {
        return this.enumEntries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumMenuItem that = (EnumMenuItem)o;
        return this.getId() == that.getId() && this.getEepromAddress() == that.getEepromAddress() && this.isReadOnly() == that.isReadOnly() && this.isVisible() == that.isVisible() && this.isLocalOnly() == that.isLocalOnly() && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getEnumEntries(), that.getEnumEntries()) && Objects.equals(this.getFunctionName(), that.getFunctionName()) && Objects.equals(this.getVariableName(), that.getVariableName());
    }

    public int hashCode() {
        return Objects.hash(this.getEnumEntries(), this.getId(), this.getEepromAddress(), this.getFunctionName(), this.isReadOnly(), this.getVariableName());
    }

    @Override
    public void accept(MenuItemVisitor visitor) {
        visitor.visit(this);
    }
}

