/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain.util;

import com.thecoderscorner.menu.domain.ActionMenuItem;
import com.thecoderscorner.menu.domain.ActionMenuItemBuilder;
import com.thecoderscorner.menu.domain.AnalogMenuItem;
import com.thecoderscorner.menu.domain.AnalogMenuItemBuilder;
import com.thecoderscorner.menu.domain.BooleanMenuItem;
import com.thecoderscorner.menu.domain.BooleanMenuItemBuilder;
import com.thecoderscorner.menu.domain.CustomBuilderMenuItem;
import com.thecoderscorner.menu.domain.CustomBuilderMenuItemBuilder;
import com.thecoderscorner.menu.domain.EditItemType;
import com.thecoderscorner.menu.domain.EditableLargeNumberMenuItem;
import com.thecoderscorner.menu.domain.EditableLargeNumberMenuItemBuilder;
import com.thecoderscorner.menu.domain.EditableTextMenuItem;
import com.thecoderscorner.menu.domain.EditableTextMenuItemBuilder;
import com.thecoderscorner.menu.domain.EnumMenuItem;
import com.thecoderscorner.menu.domain.EnumMenuItemBuilder;
import com.thecoderscorner.menu.domain.FloatMenuItem;
import com.thecoderscorner.menu.domain.FloatMenuItemBuilder;
import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.Rgb32MenuItem;
import com.thecoderscorner.menu.domain.Rgb32MenuItemBuilder;
import com.thecoderscorner.menu.domain.RuntimeListMenuItem;
import com.thecoderscorner.menu.domain.RuntimeListMenuItemBuilder;
import com.thecoderscorner.menu.domain.ScrollChoiceMenuItem;
import com.thecoderscorner.menu.domain.ScrollChoiceMenuItemBuilder;
import com.thecoderscorner.menu.domain.SubMenuItem;
import com.thecoderscorner.menu.domain.SubMenuItemBuilder;
import com.thecoderscorner.menu.domain.state.AnyMenuState;
import com.thecoderscorner.menu.domain.state.BigDecimalMenuState;
import com.thecoderscorner.menu.domain.state.BooleanMenuState;
import com.thecoderscorner.menu.domain.state.CurrentScrollPosition;
import com.thecoderscorner.menu.domain.state.CurrentScrollPositionMenuState;
import com.thecoderscorner.menu.domain.state.FloatMenuState;
import com.thecoderscorner.menu.domain.state.IntegerMenuState;
import com.thecoderscorner.menu.domain.state.MenuTree;
import com.thecoderscorner.menu.domain.state.PortableColor;
import com.thecoderscorner.menu.domain.state.PortableColorMenuState;
import com.thecoderscorner.menu.domain.state.StringListMenuState;
import com.thecoderscorner.menu.domain.state.StringMenuState;
import com.thecoderscorner.menu.domain.util.AbstractMenuItemVisitor;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;

public class MenuItemHelper {
    public static <T> Optional<T> visitWithResult(MenuItem item, AbstractMenuItemVisitor<T> visitor) {
        item.accept(visitor);
        return visitor.getResult();
    }

    public static SubMenuItem asSubMenu(MenuItem item) {
        return MenuItemHelper.visitWithResult(item, new AbstractMenuItemVisitor<SubMenuItem>(){

            @Override
            public void visit(SubMenuItem item) {
                this.setResult(item);
            }

            @Override
            public void anyItem(MenuItem item) {
            }
        }).orElse(null);
    }

    public static boolean isRuntimeStructureNeeded(MenuItem item) {
        return MenuItemHelper.visitWithResult(item, new AbstractMenuItemVisitor<Boolean>(){

            @Override
            public void visit(RuntimeListMenuItem listItem) {
                this.setResult(true);
            }

            @Override
            public void visit(EditableTextMenuItem item) {
                this.setResult(true);
            }

            @Override
            public void visit(EditableLargeNumberMenuItem item) {
                this.setResult(true);
            }

            @Override
            public void visit(ScrollChoiceMenuItem scrollItem) {
                this.setResult(true);
            }

            @Override
            public void visit(Rgb32MenuItem rgbItem) {
                this.setResult(true);
            }

            @Override
            public void visit(SubMenuItem item) {
                this.setResult(true);
            }

            @Override
            public void anyItem(MenuItem item) {
                this.setResult(false);
            }
        }).orElse(false);
    }

    public static MenuItem createFromExistingWithId(MenuItem selected, final int newId) {
        return MenuItemHelper.visitWithResult(selected, new AbstractMenuItemVisitor<MenuItem>(){

            @Override
            public void visit(AnalogMenuItem item) {
                this.setResult(((AnalogMenuItemBuilder)AnalogMenuItemBuilder.anAnalogMenuItemBuilder().withExisting(item).withId(newId)).menuItem());
            }

            @Override
            public void visit(BooleanMenuItem item) {
                this.setResult(((BooleanMenuItemBuilder)BooleanMenuItemBuilder.aBooleanMenuItemBuilder().withExisting(item).withId(newId)).menuItem());
            }

            @Override
            public void visit(EnumMenuItem item) {
                this.setResult(((EnumMenuItemBuilder)EnumMenuItemBuilder.anEnumMenuItemBuilder().withExisting(item).withId(newId)).menuItem());
            }

            @Override
            public void visit(SubMenuItem item) {
                this.setResult(((SubMenuItemBuilder)SubMenuItemBuilder.aSubMenuItemBuilder().withExisting(item).withId(newId)).menuItem());
            }

            @Override
            public void visit(EditableTextMenuItem item) {
                this.setResult(((EditableTextMenuItemBuilder)EditableTextMenuItemBuilder.aTextMenuItemBuilder().withExisting(item).withId(newId)).menuItem());
            }

            @Override
            public void visit(EditableLargeNumberMenuItem item) {
                this.setResult(((EditableLargeNumberMenuItemBuilder)EditableLargeNumberMenuItemBuilder.aLargeNumberItemBuilder().withExisting(item).withId(newId)).menuItem());
            }

            @Override
            public void visit(FloatMenuItem item) {
                this.setResult(((FloatMenuItemBuilder)FloatMenuItemBuilder.aFloatMenuItemBuilder().withExisting(item).withId(newId)).menuItem());
            }

            @Override
            public void visit(Rgb32MenuItem item) {
                this.setResult(((Rgb32MenuItemBuilder)new Rgb32MenuItemBuilder().withExisting(item).withId(newId)).menuItem());
            }

            @Override
            public void visit(CustomBuilderMenuItem item) {
                this.setResult(((CustomBuilderMenuItemBuilder)new CustomBuilderMenuItemBuilder().withExisting(item).withId(newId)).menuItem());
            }

            @Override
            public void visit(ScrollChoiceMenuItem item) {
                this.setResult(((ScrollChoiceMenuItemBuilder)new ScrollChoiceMenuItemBuilder().withExisting(item).withId(newId)).menuItem());
            }

            @Override
            public void visit(ActionMenuItem item) {
                this.setResult(((ActionMenuItemBuilder)ActionMenuItemBuilder.anActionMenuItemBuilder().withExisting(item).withId(newId)).menuItem());
            }

            @Override
            public void visit(RuntimeListMenuItem item) {
                this.setResult(((RuntimeListMenuItemBuilder)RuntimeListMenuItemBuilder.aRuntimeListMenuItemBuilder().withExisting(item).withId(newId)).menuItem());
            }
        }).orElse(null);
    }

    public static int eepromSizeForItem(MenuItem item) {
        if (item == null) {
            return 0;
        }
        return MenuItemHelper.visitWithResult(item, new AbstractMenuItemVisitor<Integer>(){

            @Override
            public void visit(AnalogMenuItem item) {
                this.setResult(2);
            }

            @Override
            public void visit(BooleanMenuItem item) {
                this.setResult(1);
            }

            @Override
            public void visit(EnumMenuItem item) {
                this.setResult(2);
            }

            @Override
            public void visit(EditableLargeNumberMenuItem numItem) {
                this.setResult(8);
            }

            @Override
            public void visit(Rgb32MenuItem numItem) {
                this.setResult(4);
            }

            @Override
            public void visit(ScrollChoiceMenuItem numItem) {
                this.setResult(2);
            }

            @Override
            public void visit(EditableTextMenuItem item) {
                if (item.getItemType() == EditItemType.IP_ADDRESS) {
                    this.setResult(4);
                } else if (item.getItemType() == EditItemType.PLAIN_TEXT) {
                    this.setResult(item.getTextLength());
                } else {
                    this.setResult(4);
                }
            }

            @Override
            public void anyItem(MenuItem item) {
                this.setResult(0);
            }
        }).orElse(0);
    }

    public static AnyMenuState stateForMenuItem(AnyMenuState existingState, MenuItem item, Object val) {
        boolean changed = false;
        boolean active = false;
        if (existingState != null) {
            changed = existingState.isChanged();
            active = existingState.isActive();
        }
        return MenuItemHelper.stateForMenuItem(item, val, changed, active);
    }

    public static AnyMenuState stateForMenuItem(AnyMenuState existingState, MenuItem item, Object val, boolean changed) {
        boolean active = false;
        if (existingState != null) {
            active = existingState.isActive();
        }
        return MenuItemHelper.stateForMenuItem(item, val, changed, active);
    }

    public static AnyMenuState stateForMenuItem(final MenuItem item, final Object val, final boolean changed, final boolean active) {
        if (val == null || item == null) {
            return new BooleanMenuState(item, false, false, false);
        }
        return MenuItemHelper.visitWithResult(item, new AbstractMenuItemVisitor<AnyMenuState>(){

            @Override
            public void visit(AnalogMenuItem item2) {
                int res = val instanceof String ? Integer.parseInt(val.toString()) : ((Number)val).intValue();
                this.setResult(new IntegerMenuState(item2, changed, active, res));
            }

            @Override
            public void visit(BooleanMenuItem item2) {
                boolean res = val instanceof String ? (((String)val).length() == 1 ? ((String)val).charAt(0) == '1' || ((String)val).charAt(0) == 'Y' : Boolean.parseBoolean((String)val)) : (val instanceof Number ? ((Number)val).intValue() != 0 : (Boolean)val);
                this.setResult(new BooleanMenuState(item2, changed, active, res));
            }

            @Override
            public void visit(EnumMenuItem item2) {
                int res = val instanceof String ? Integer.parseInt(val.toString()) : ((Number)val).intValue();
                this.setResult(new IntegerMenuState(item2, changed, active, res));
            }

            @Override
            public void visit(SubMenuItem item2) {
                this.setResult(new BooleanMenuState(item2, changed, active, false));
                super.visit(item2);
            }

            @Override
            public void visit(EditableTextMenuItem item2) {
                this.setResult(new StringMenuState(item2, changed, active, val.toString()));
            }

            @Override
            public void visit(ActionMenuItem item2) {
                this.setResult(new BooleanMenuState(item2, changed, active, false));
            }

            @Override
            public void visit(FloatMenuItem item2) {
                float res = val instanceof String ? Float.parseFloat(val.toString()) : ((Number)val).floatValue();
                this.setResult(new FloatMenuState(item2, changed, active, Float.valueOf(res)));
            }

            @Override
            public void visit(RuntimeListMenuItem listItem) {
                this.setResult(new StringListMenuState(item, changed, active, (List)val));
            }

            @Override
            public void visit(EditableLargeNumberMenuItem numItem) {
                BigDecimal dec;
                if (val instanceof String) {
                    String value = ((String)val).replaceAll("[\\[\\]]", "");
                    dec = new BigDecimal(value);
                } else {
                    dec = (BigDecimal)val;
                }
                this.setResult(new BigDecimalMenuState(item, changed, active, dec));
            }

            @Override
            public void visit(ScrollChoiceMenuItem scrollItem) {
                CurrentScrollPosition res = val instanceof String ? new CurrentScrollPosition(val.toString()) : (CurrentScrollPosition)val;
                this.setResult(new CurrentScrollPositionMenuState(item, changed, active, res));
            }

            @Override
            public void visit(Rgb32MenuItem rgbItem) {
                PortableColor res = val instanceof String ? new PortableColor(val.toString()) : (PortableColor)val;
                this.setResult(new PortableColorMenuState(item, changed, active, res));
            }

            @Override
            public void anyItem(MenuItem item2) {
                this.setResult(new BooleanMenuState(item2, changed, active, false));
            }
        }).orElseThrow();
    }

    public static <T> T getValueFor(MenuItem item, MenuTree tree, T def) {
        if (tree.getMenuState(item) != null) {
            try {
                return (T)tree.getMenuState(item).getValue();
            }
            catch (Exception ex) {
                System.getLogger(MenuItemHelper.class.getSimpleName()).log(System.Logger.Level.ERROR, "State type incorrect", (Throwable)ex);
            }
        }
        tree.changeItem(item, MenuItemHelper.stateForMenuItem(item, def, false, false));
        return def;
    }
}

