/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.states;

import com.thecoderscorner.menu.remote.AuthStatus;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.states.RemoteConnectorContext;
import com.thecoderscorner.menu.remote.states.RemoteConnectorState;
import java.util.concurrent.atomic.AtomicBoolean;

public class ConnectionHasFailedState
implements RemoteConnectorState {
    private final RemoteConnectorContext context;
    private AtomicBoolean exited = new AtomicBoolean(false);

    public ConnectionHasFailedState(RemoteConnectorContext context) {
        this.context = context;
    }

    @Override
    public void enterState() {
        this.context.close();
    }

    @Override
    public void exitState(RemoteConnectorState nextState) {
        this.exited.set(true);
    }

    @Override
    public AuthStatus getAuthenticationStatus() {
        return AuthStatus.CONNECTION_FAILED;
    }

    @Override
    public boolean canSendCommandToRemote(MenuCommand command) {
        return false;
    }

    @Override
    public void runLoop() throws Exception {
        if (this.exited.get()) {
            return;
        }
        Thread.sleep(5000L);
        this.context.changeState(AuthStatus.AWAITING_CONNECTION);
        this.exited.set(true);
    }
}

