/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.states;

import com.thecoderscorner.menu.remote.AuthStatus;
import com.thecoderscorner.menu.remote.RemoteInformation;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommandType;
import com.thecoderscorner.menu.remote.commands.MenuHeartbeatCommand;
import com.thecoderscorner.menu.remote.commands.MenuJoinCommand;
import com.thecoderscorner.menu.remote.states.BaseMessageProcessingState;
import com.thecoderscorner.menu.remote.states.RemoteConnectorContext;

public class SerialAwaitFirstMsgState
extends BaseMessageProcessingState {
    public SerialAwaitFirstMsgState(RemoteConnectorContext context) {
        super(context);
    }

    @Override
    protected boolean processMessage(MenuCommand cmd) {
        if (cmd.getCommandType() == MenuCommandType.CHANGE_INT_FIELD) {
            return true;
        }
        if (cmd.getCommandType() == MenuCommandType.HEARTBEAT) {
            MenuHeartbeatCommand hb = (MenuHeartbeatCommand)cmd;
            if (hb.getMode() == MenuHeartbeatCommand.HeartbeatMode.START) {
                this.context.sendHeartbeat(5000, MenuHeartbeatCommand.HeartbeatMode.START);
            }
            return true;
        }
        if (cmd.getCommandType() == MenuCommandType.JOIN) {
            MenuJoinCommand join = (MenuJoinCommand)cmd;
            RemoteInformation remote = new RemoteInformation(join.getMyName(), join.getApiVersion() / 100, join.getApiVersion() % 100, join.getPlatform());
            this.context.setRemoteParty(remote);
            this.markDone();
            this.context.changeState(AuthStatus.SEND_AUTH);
            return true;
        }
        return false;
    }

    @Override
    protected void processTimeout() {
        this.context.sendHeartbeat(5000, MenuHeartbeatCommand.HeartbeatMode.END);
    }

    @Override
    public AuthStatus getAuthenticationStatus() {
        return AuthStatus.ESTABLISHED_CONNECTION;
    }

    @Override
    public boolean canSendCommandToRemote(MenuCommand command) {
        return command.getCommandType() == MenuCommandType.HEARTBEAT || command.getCommandType() == MenuCommandType.JOIN;
    }
}

