/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.states;

import com.thecoderscorner.menu.remote.AuthStatus;
import com.thecoderscorner.menu.remote.commands.MenuAcknowledgementCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommandType;
import com.thecoderscorner.menu.remote.commands.MenuHeartbeatCommand;
import com.thecoderscorner.menu.remote.states.BaseMessageProcessingState;
import com.thecoderscorner.menu.remote.states.RemoteConnectorContext;
import java.io.IOException;

public class JoinMessageArrivedState
extends BaseMessageProcessingState {
    public JoinMessageArrivedState(RemoteConnectorContext context) {
        super(context);
    }

    @Override
    public void enterState() {
        super.enterState();
        try {
            this.context.sendJoin();
        }
        catch (IOException e) {
            this.logger.log(System.Logger.Level.ERROR, "Did not send join to " + this.context.getConnectionName(), (Throwable)e);
        }
    }

    @Override
    protected void processTimeout() {
        this.markDone();
        this.context.close();
        this.context.changeState(AuthStatus.CONNECTION_FAILED);
    }

    @Override
    protected boolean processMessage(MenuCommand cmd) {
        if (cmd.getCommandType() == MenuCommandType.CHANGE_INT_FIELD) {
            return true;
        }
        if (cmd.getCommandType() == MenuCommandType.HEARTBEAT) {
            MenuHeartbeatCommand hb = (MenuHeartbeatCommand)cmd;
            if (hb.getMode() == MenuHeartbeatCommand.HeartbeatMode.END) {
                this.markDone();
                this.context.changeState(AuthStatus.CONNECTION_FAILED);
                return true;
            }
            return true;
        }
        if (cmd.getCommandType() == MenuCommandType.JOIN) {
            return true;
        }
        if (cmd.getCommandType() == MenuCommandType.ACKNOWLEDGEMENT) {
            MenuAcknowledgementCommand ack = (MenuAcknowledgementCommand)cmd;
            this.markDone();
            if (ack.getAckStatus().isError()) {
                this.logger.log(System.Logger.Level.WARNING, "Failed to authenticate with remote " + this.context.getConnectionName());
                this.context.changeState(AuthStatus.FAILED_AUTH);
            } else {
                this.logger.log(System.Logger.Level.INFO, "Authenticated successfully with " + this.context.getConnectionName());
                this.context.changeState(AuthStatus.AUTHENTICATED);
            }
            return true;
        }
        return false;
    }

    @Override
    public AuthStatus getAuthenticationStatus() {
        return AuthStatus.SEND_AUTH;
    }

    @Override
    public boolean canSendCommandToRemote(MenuCommand command) {
        return command.getCommandType() == MenuCommandType.HEARTBEAT || command.getCommandType() == MenuCommandType.JOIN;
    }
}

