/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.auth;

import com.thecoderscorner.menu.auth.MenuAuthenticator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;

public class PreDefinedAuthenticator
implements MenuAuthenticator {
    private final List<AuthenticationToken> authenticationItems = new CopyOnWriteArrayList<AuthenticationToken>();
    private final boolean alwaysAllow;

    public PreDefinedAuthenticator(boolean alwaysAllow) {
        this.alwaysAllow = alwaysAllow;
    }

    public PreDefinedAuthenticator(List<AuthenticationToken> upfrontTokens) {
        this.alwaysAllow = false;
        this.authenticationItems.addAll(upfrontTokens);
    }

    @Override
    public boolean addAuthentication(String name, UUID uuid) {
        this.authenticationItems.add(new AuthenticationToken(name, uuid.toString()));
        return true;
    }

    @Override
    public boolean authenticate(String user, UUID uuid) {
        if (this.authenticationItems.isEmpty()) {
            return this.alwaysAllow;
        }
        for (AuthenticationToken auth : this.authenticationItems) {
            if (!auth.doesMatch(user, uuid)) continue;
            return true;
        }
        return false;
    }

    public static class AuthenticationToken {
        private final String name;
        private final String uuid;

        public AuthenticationToken(String name, String uuid) {
            this.name = name;
            this.uuid = uuid;
        }

        public boolean doesMatch(String name, UUID uuid) {
            if (name == null || uuid == null) {
                return false;
            }
            return this.name.equals(name) && this.uuid.equalsIgnoreCase(uuid.toString());
        }
    }
}

