/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.auth;

import com.thecoderscorner.menu.auth.MenuAuthenticator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import java.util.UUID;

public class PropertiesAuthenticator
implements MenuAuthenticator {
    private final System.Logger logger = System.getLogger(this.getClass().getSimpleName());
    private final Properties properties = new Properties();
    private final String location;

    public PropertiesAuthenticator(String location) {
        this.location = location;
        try {
            this.properties.load(Files.newBufferedReader(Path.of(location, new String[0])));
        }
        catch (IOException e) {
            this.logger.log(System.Logger.Level.ERROR, "Unable to read authentication properties");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean authenticate(String user, UUID uuid) {
        String val;
        Properties properties = this.properties;
        synchronized (properties) {
            val = this.properties.getProperty(user);
        }
        if (val == null) {
            return false;
        }
        return UUID.fromString(val).equals(uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAuthentication(String user, UUID uuid) {
        try {
            Properties properties = this.properties;
            synchronized (properties) {
                this.properties.setProperty(user, uuid.toString());
                this.properties.store(Files.newBufferedWriter(Path.of(this.location, new String[0]), new OpenOption[0]), "TcMenu Auth properties");
            }
            this.logger.log(System.Logger.Level.INFO, "Wrote auth properties to ", this.location);
            return true;
        }
        catch (Exception e) {
            this.logger.log(System.Logger.Level.ERROR, "Failed to write auth properties to ", this.location);
            return false;
        }
    }
}

