/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.persist;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thecoderscorner.menu.domain.ActionMenuItem;
import com.thecoderscorner.menu.domain.AnalogMenuItem;
import com.thecoderscorner.menu.domain.BooleanMenuItem;
import com.thecoderscorner.menu.domain.CustomBuilderMenuItem;
import com.thecoderscorner.menu.domain.EditableLargeNumberMenuItem;
import com.thecoderscorner.menu.domain.EditableTextMenuItem;
import com.thecoderscorner.menu.domain.EnumMenuItem;
import com.thecoderscorner.menu.domain.FloatMenuItem;
import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.Rgb32MenuItem;
import com.thecoderscorner.menu.domain.RuntimeListMenuItem;
import com.thecoderscorner.menu.domain.ScrollChoiceMenuItem;
import com.thecoderscorner.menu.domain.SubMenuItem;
import com.thecoderscorner.menu.domain.state.MenuTree;
import com.thecoderscorner.menu.domain.util.MenuItemHelper;
import com.thecoderscorner.menu.persist.PersistedMenu;
import java.io.IOException;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class JsonMenuItemSerializer {
    private static final System.Logger logger = System.getLogger(JsonMenuItemSerializer.class.getSimpleName());
    private static final String PARENT_ID = "parentId";
    private static final String TYPE_ID = "type";
    private static final String ITEM_ID = "item";
    private final Gson gson;

    public JsonMenuItemSerializer() {
        this(null);
    }

    public JsonMenuItemSerializer(Consumer<GsonBuilder> builder) {
        this.gson = this.makeGsonProcessor(builder);
    }

    public Gson getGson() {
        return this.gson;
    }

    public List<PersistedMenu> populateListInOrder(SubMenuItem node, MenuTree menuTree) {
        ArrayList<PersistedMenu> list = new ArrayList<PersistedMenu>();
        List<MenuItem> items = menuTree.getMenuItems(node);
        for (MenuItem item : items) {
            list.add(new PersistedMenu(node, item));
            if (!item.hasChildren()) continue;
            list.addAll(this.populateListInOrder(MenuItemHelper.asSubMenu(item), menuTree));
        }
        return list;
    }

    public String itemsToCopyText(MenuItem startingPoint, MenuTree tree) {
        List<PersistedMenu> items;
        if (startingPoint instanceof SubMenuItem) {
            items = this.populateListInOrder((SubMenuItem)startingPoint, tree);
        } else {
            items = new ArrayList<PersistedMenu>();
            items.add(new PersistedMenu(tree.findParent(startingPoint), startingPoint));
        }
        return "tcMenuCopy:" + this.gson.toJson(items);
    }

    public List<PersistedMenu> copyTextToItems(String items) {
        if (!items.startsWith("tcMenuCopy:")) {
            return Collections.emptyList();
        }
        String jsonStr = items.substring("tcMenuCopy:".length());
        return (List)this.gson.fromJson(jsonStr, ArrayList.class);
    }

    public MenuTree newMenuTreeWithItems(String tcMenuCopy) {
        MenuTree tree = new MenuTree();
        List<PersistedMenu> items = this.copyTextToItems(tcMenuCopy);
        for (PersistedMenu item : items) {
            tree.addMenuItem(tree.getSubMenuById(item.getParentId()).orElse(MenuTree.ROOT), item.getItem());
        }
        return tree;
    }

    private Gson makeGsonProcessor(Consumer<GsonBuilder> builderConsumer) {
        ArrayList example = new ArrayList();
        GsonBuilder builder = new GsonBuilder();
        if (builderConsumer != null) {
            builderConsumer.accept(builder);
        }
        return builder.registerTypeAdapter(example.getClass(), (Object)new MenuItemSerialiser()).registerTypeAdapter(example.getClass(), (Object)new MenuItemDeserialiser()).registerTypeAdapter(Instant.class, (Object)new CompatibleDateTimePersistor()).setPrettyPrinting().create();
    }

    public static JsonObject getJsonObjOrThrow(JsonObject object, String child) throws IOException {
        JsonElement data = object.get(child);
        if (data == null) {
            throw new IOException("Missing mandatory element " + child);
        }
        return data.getAsJsonObject();
    }

    public static String getJsonStrOrThrow(JsonObject object, String child) throws IOException {
        JsonElement data = object.get(child);
        if (data == null) {
            throw new IOException("Missing mandatory element " + child);
        }
        return data.getAsString();
    }

    public static int getJsonIntOrThrow(JsonObject object, String child) throws IOException {
        JsonElement data = object.get(child);
        if (data == null) {
            throw new IOException("Missing mandatory element " + child);
        }
        return data.getAsInt();
    }

    static class CompatibleDateTimePersistor
    implements JsonSerializer<Instant>,
    JsonDeserializer<Instant> {
        CompatibleDateTimePersistor() {
        }

        public JsonElement serialize(Instant dt, Type type, JsonSerializationContext jsonSerializationContext) {
            long seconds = dt.getEpochSecond();
            int nanos = dt.getNano();
            JsonObject obj = new JsonObject();
            obj.add("seconds", (JsonElement)new JsonPrimitive((Number)seconds));
            obj.add("nanos", (JsonElement)new JsonPrimitive((Number)nanos));
            return obj;
        }

        public Instant deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            long seconds = json.getAsJsonObject().get("seconds").getAsLong();
            int nanos = json.getAsJsonObject().get("nanos").getAsInt();
            return Instant.ofEpochSecond(seconds, nanos);
        }
    }

    static class MenuItemDeserialiser
    implements JsonDeserializer<ArrayList<PersistedMenu>> {
        private final Map<String, Class<? extends MenuItem>> mapOfTypes = new HashMap<String, Class<? extends MenuItem>>();

        MenuItemDeserialiser() {
            this.mapOfTypes.put("enumItem", EnumMenuItem.class);
            this.mapOfTypes.put("analogItem", AnalogMenuItem.class);
            this.mapOfTypes.put("boolItem", BooleanMenuItem.class);
            this.mapOfTypes.put("actionMenu", ActionMenuItem.class);
            this.mapOfTypes.put("textItem", EditableTextMenuItem.class);
            this.mapOfTypes.put("subMenu", SubMenuItem.class);
            this.mapOfTypes.put("runtimeList", RuntimeListMenuItem.class);
            this.mapOfTypes.put("largeNumItem", EditableLargeNumberMenuItem.class);
            this.mapOfTypes.put("customBuildItem", CustomBuilderMenuItem.class);
            this.mapOfTypes.put("scrollItem", ScrollChoiceMenuItem.class);
            this.mapOfTypes.put("rgbItem", Rgb32MenuItem.class);
            this.mapOfTypes.put("floatItem", FloatMenuItem.class);
        }

        public ArrayList<PersistedMenu> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext ctx) throws JsonParseException {
            ArrayList<PersistedMenu> list = new ArrayList<PersistedMenu>();
            JsonArray ja = jsonElement.getAsJsonArray();
            ja.forEach(ele -> {
                String ty = ele.getAsJsonObject().get(JsonMenuItemSerializer.TYPE_ID).getAsString();
                int parentId = ele.getAsJsonObject().get(JsonMenuItemSerializer.PARENT_ID).getAsInt();
                Class<? extends MenuItem> c = this.mapOfTypes.get(ty);
                if (c != null) {
                    MenuItem item = (MenuItem)ctx.deserialize((JsonElement)ele.getAsJsonObject().getAsJsonObject(JsonMenuItemSerializer.ITEM_ID), c);
                    PersistedMenu m = new PersistedMenu();
                    m.setItem(item);
                    m.setParentId(parentId);
                    m.setType(ty);
                    list.add(m);
                } else {
                    logger.log(System.Logger.Level.ERROR, "Item of type " + ty + " was not reloaded - skipping");
                }
            });
            return list;
        }
    }

    static class MenuItemSerialiser
    implements JsonSerializer<ArrayList<PersistedMenu>> {
        MenuItemSerialiser() {
        }

        public JsonElement serialize(ArrayList<PersistedMenu> src, Type type, JsonSerializationContext ctx) {
            if (src == null) {
                return null;
            }
            JsonArray arr = new JsonArray();
            src.forEach(itm -> {
                JsonObject ele = new JsonObject();
                ele.addProperty(JsonMenuItemSerializer.PARENT_ID, (Number)itm.getParentId());
                ele.addProperty(JsonMenuItemSerializer.TYPE_ID, itm.getType());
                ele.add(JsonMenuItemSerializer.ITEM_ID, ctx.serialize((Object)itm.getItem()));
                arr.add((JsonElement)ele);
            });
            return arr;
        }
    }
}

