/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.mgr;

import com.thecoderscorner.menu.auth.MenuAuthenticator;
import com.thecoderscorner.menu.domain.AnalogMenuItem;
import com.thecoderscorner.menu.domain.EnumMenuItem;
import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.state.AnyMenuState;
import com.thecoderscorner.menu.domain.state.IntegerMenuState;
import com.thecoderscorner.menu.domain.state.MenuState;
import com.thecoderscorner.menu.domain.state.MenuTree;
import com.thecoderscorner.menu.domain.state.StringListMenuState;
import com.thecoderscorner.menu.domain.util.MenuItemHelper;
import com.thecoderscorner.menu.remote.commands.AckStatus;
import com.thecoderscorner.menu.remote.commands.BootItemMenuCommand;
import com.thecoderscorner.menu.remote.commands.DialogMode;
import com.thecoderscorner.menu.remote.commands.MenuAcknowledgementCommand;
import com.thecoderscorner.menu.remote.commands.MenuBootstrapCommand;
import com.thecoderscorner.menu.remote.commands.MenuButtonType;
import com.thecoderscorner.menu.remote.commands.MenuChangeCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.commands.MenuDialogCommand;
import com.thecoderscorner.menu.remote.commands.MenuHeartbeatCommand;
import com.thecoderscorner.menu.remote.commands.MenuJoinCommand;
import com.thecoderscorner.menu.remote.commands.MenuPairingCommand;
import com.thecoderscorner.menu.remote.mgr.NewServerConnectionListener;
import com.thecoderscorner.menu.remote.mgr.ServerConnection;
import com.thecoderscorner.menu.remote.mgr.ServerConnectionManager;
import com.thecoderscorner.menu.remote.protocol.ApiPlatform;
import com.thecoderscorner.menu.remote.protocol.CorrelationId;
import java.time.Clock;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class MenuManagerServer
implements NewServerConnectionListener {
    private final System.Logger logger = System.getLogger(MenuManagerServer.class.getSimpleName());
    private final ScheduledExecutorService executorService;
    private final MenuTree tree;
    private final ServerConnectionManager serverManager;
    private final String serverName;
    private final UUID serverUuid;
    private final MenuAuthenticator authenticator;
    private final AtomicBoolean successfulLogin = new AtomicBoolean(false);
    private final Clock clock;
    private ScheduledFuture<?> hbSchedule;

    public MenuManagerServer(ScheduledExecutorService executorService, MenuTree tree, ServerConnectionManager serverManager, String serverName, UUID uuid, MenuAuthenticator authenticator, Clock clock) {
        this.executorService = executorService;
        this.tree = tree;
        this.serverManager = serverManager;
        this.serverName = serverName;
        this.serverUuid = uuid;
        this.authenticator = authenticator;
        this.clock = clock;
    }

    public void start() {
        this.serverManager.start(this);
        this.hbSchedule = this.executorService.scheduleAtFixedRate(this::checkHeartbeats, 200L, 200L, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.hbSchedule != null) {
            this.hbSchedule.cancel(false);
        }
        try {
            this.serverManager.stop();
        }
        catch (Exception e) {
            this.logger.log(System.Logger.Level.ERROR, "Server manager threw error during stop", (Throwable)e);
        }
    }

    private void checkHeartbeats() {
        for (ServerConnection socket : this.serverManager.getServerConnections()) {
            if (this.clock.millis() - socket.lastReceivedHeartbeat() > (long)socket.getHeartbeatFrequency() * 3L) {
                this.logger.log(System.Logger.Level.WARNING, "HB timeout, no received message within frequency");
                socket.closeConnection();
                continue;
            }
            if (this.clock.millis() - socket.lastTransmittedHeartbeat() <= (long)socket.getHeartbeatFrequency()) continue;
            this.logger.log(System.Logger.Level.INFO, "Sending HB due to inactivity");
            socket.sendCommand(new MenuHeartbeatCommand(socket.getHeartbeatFrequency(), MenuHeartbeatCommand.HeartbeatMode.NORMAL));
        }
    }

    @Override
    public void connectionCreated(ServerConnection connection) {
        connection.registerMessageHandler(this::messageReceived);
        connection.sendCommand(new MenuHeartbeatCommand(connection.getHeartbeatFrequency(), MenuHeartbeatCommand.HeartbeatMode.START));
    }

    private void messageReceived(ServerConnection conn, MenuCommand cmd) {
        try {
            if (conn.isPairing()) {
                this.logger.log(System.Logger.Level.INFO, "Connection is in pairing mode, ignoring " + cmd);
                return;
            }
            switch (cmd.getCommandType()) {
                case JOIN: {
                    MenuJoinCommand join = (MenuJoinCommand)cmd;
                    if (this.authenticator != null && !this.authenticator.authenticate(join.getMyName(), join.getAppUuid())) {
                        this.logger.log(System.Logger.Level.WARNING, "Invalid credentials from " + join.getMyName());
                        conn.sendCommand(new MenuAcknowledgementCommand(CorrelationId.EMPTY_CORRELATION, AckStatus.INVALID_CREDENTIALS));
                        conn.closeConnection();
                        break;
                    }
                    this.successfulLogin.set(true);
                    this.logger.log(System.Logger.Level.WARNING, "Successful login from " + join.getMyName());
                    conn.sendCommand(new MenuAcknowledgementCommand(CorrelationId.EMPTY_CORRELATION, AckStatus.SUCCESS));
                    conn.sendCommand(new MenuBootstrapCommand(MenuBootstrapCommand.BootType.START));
                    this.tree.recurseTreeIteratingOnItems(MenuTree.ROOT, (item, parent) -> {
                        if (!item.isLocalOnly()) {
                            Optional<BootItemMenuCommand<?, ?>> bootMsg = MenuItemHelper.getBootMsgForItem(item, parent, this.tree);
                            bootMsg.ifPresent(conn::sendCommand);
                        }
                    });
                    conn.sendCommand(new MenuBootstrapCommand(MenuBootstrapCommand.BootType.END));
                    break;
                }
                case PAIRING_REQUEST: {
                    this.startPairingMode(conn, (MenuPairingCommand)cmd);
                    break;
                }
                case HEARTBEAT: {
                    MenuHeartbeatCommand hb = (MenuHeartbeatCommand)cmd;
                    if (hb.getMode() != MenuHeartbeatCommand.HeartbeatMode.START) break;
                    conn.sendCommand(new MenuJoinCommand(this.serverUuid, this.serverName, ApiPlatform.JAVA_API, 1));
                    break;
                }
                case CHANGE_INT_FIELD: {
                    if (!this.successfulLogin.get()) {
                        this.logger.log(System.Logger.Level.WARNING, "Un-authenticated change command ignored");
                        return;
                    }
                    this.handleIncomingChange(conn, (MenuChangeCommand)cmd);
                }
            }
        }
        catch (Exception e) {
            conn.closeConnection();
        }
    }

    private void startPairingMode(ServerConnection conn, MenuPairingCommand cmd) {
        conn.enablePairingMode();
        boolean success = this.authenticator.addAuthentication(cmd.getName(), cmd.getUuid());
        AckStatus determinedStatus = success ? AckStatus.SUCCESS : AckStatus.INVALID_CREDENTIALS;
        conn.sendCommand(new MenuAcknowledgementCommand(CorrelationId.EMPTY_CORRELATION, determinedStatus));
    }

    public MenuTree getManagedMenu() {
        return this.tree;
    }

    public void updateMenuItem(MenuItem item, Object newValue) {
        MenuItemHelper.setMenuState(item, newValue, this.tree);
        this.menuItemDidUpdate(item);
    }

    public void menuItemDidUpdate(MenuItem item) {
        this.logger.log(System.Logger.Level.INFO, "Sending item update for " + item);
        Object state = this.tree.getMenuState(item);
        if (state == null) {
            return;
        }
        MenuChangeCommand cmd = state instanceof StringListMenuState ? new MenuChangeCommand(CorrelationId.EMPTY_CORRELATION, item.getId(), (List)((StringListMenuState)state).getValue()) : new MenuChangeCommand(CorrelationId.EMPTY_CORRELATION, item.getId(), MenuChangeCommand.ChangeType.ABSOLUTE, state.getValue().toString());
        for (ServerConnection socket : this.serverManager.getServerConnections()) {
            socket.sendCommand(cmd);
        }
    }

    private void handleIncomingChange(ServerConnection socket, MenuChangeCommand cmd) {
        Optional<MenuItem> maybeItem = this.tree.getMenuById(cmd.getMenuItemId());
        if (maybeItem.isEmpty()) {
            socket.sendCommand(new MenuAcknowledgementCommand(cmd.getCorrelationId(), AckStatus.ID_NOT_FOUND));
            return;
        }
        MenuItem item = maybeItem.get();
        if (cmd.getChangeType() == MenuChangeCommand.ChangeType.DELTA) {
            int val;
            MenuState state = (MenuState)this.tree.getMenuState(item);
            if (state == null) {
                state = new IntegerMenuState(item, true, false, 0);
            }
            if ((val = (Integer)state.getValue() + Integer.parseInt(cmd.getValue())) <= 0 || item instanceof AnalogMenuItem && val > ((AnalogMenuItem)item).getMaxValue() || item instanceof EnumMenuItem && val >= ((EnumMenuItem)item).getEnumEntries().size()) {
                socket.sendCommand(new MenuAcknowledgementCommand(cmd.getCorrelationId(), AckStatus.VALUE_RANGE_WARNING));
                return;
            }
            state = new IntegerMenuState(item, state.isChanged(), state.isActive(), val);
            this.tree.changeItem(item, state);
            this.sendChangeAndAck(socket, item, val, cmd.getCorrelationId());
        } else if (cmd.getChangeType() == MenuChangeCommand.ChangeType.ABSOLUTE) {
            AnyMenuState newState = MenuItemHelper.stateForMenuItem(this.tree.getMenuState(item), item, cmd.getValue());
            this.tree.changeItem(item, newState);
            this.sendChangeAndAck(socket, item, cmd.getValue(), cmd.getCorrelationId());
        }
    }

    private void sendChangeAndAck(ServerConnection socket, MenuItem item, Object val, CorrelationId correlationId) {
        socket.sendCommand(new MenuAcknowledgementCommand(correlationId, AckStatus.SUCCESS));
        socket.sendCommand(new MenuChangeCommand(CorrelationId.EMPTY_CORRELATION, item.getId(), MenuChangeCommand.ChangeType.ABSOLUTE, val.toString()));
    }

    public void reportDialogUpdate(DialogMode show, String title, String content, MenuButtonType b1, MenuButtonType b2) {
        MenuDialogCommand cmd = new MenuDialogCommand(show, title, content, b1, b2, CorrelationId.EMPTY_CORRELATION);
        for (ServerConnection socket : this.serverManager.getServerConnections()) {
            socket.sendCommand(cmd);
        }
    }
}

