/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.mgr;

import com.thecoderscorner.menu.remote.MenuCommandProtocol;
import com.thecoderscorner.menu.remote.SharedStreamConnection;
import com.thecoderscorner.menu.remote.StreamRemoteConnector;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.commands.MenuHeartbeatCommand;
import com.thecoderscorner.menu.remote.mgr.ServerConnection;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.time.Clock;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;

public class SocketServerConnection
extends SharedStreamConnection
implements ServerConnection {
    private final System.Logger logger = System.getLogger(SocketServerConnection.class.getSimpleName());
    private final AtomicInteger heartbeatFrequency = new AtomicInteger(1500);
    private final AtomicLong lastHeartbeatTx = new AtomicLong();
    private final AtomicLong lastHeartbeatRx = new AtomicLong();
    private final Socket socket;
    private final Clock clock;
    private final AtomicBoolean socketClosed = new AtomicBoolean(false);
    private final AtomicReference<BiConsumer<ServerConnection, MenuCommand>> messageHandler = new AtomicReference();
    private final AtomicReference<BiConsumer<ServerConnection, Boolean>> connectionListener = new AtomicReference();
    private final Thread readThread;
    private final AtomicBoolean pairingMode = new AtomicBoolean(false);

    public SocketServerConnection(Socket socket, MenuCommandProtocol protocol, Clock clock) {
        super(protocol);
        this.socket = socket;
        this.clock = clock;
        this.readThread = new Thread(this::readLoop);
        this.readThread.start();
        this.lastHeartbeatRx.set(clock.millis());
        this.lastHeartbeatTx.set(clock.millis());
    }

    private void readLoop() {
        this.connectionLog(System.Logger.Level.INFO, "read loop start");
        while (this.isConnected() && !Thread.currentThread().isInterrupted()) {
            try {
                MenuCommand cmd = this.readCommandFromStream();
                if (cmd == null || this.messageHandler.get() == null) continue;
                if (cmd instanceof MenuHeartbeatCommand) {
                    this.heartbeatFrequency.set(((MenuHeartbeatCommand)cmd).getHearbeatInterval());
                }
                this.lastHeartbeatRx.set(this.clock.millis());
                this.messageHandler.get().accept(this, cmd);
            }
            catch (Exception e) {
                this.logger.log(System.Logger.Level.ERROR, "Exception while processing connection start on " + this.getConnectionName(), (Throwable)e);
                this.closeConnection();
            }
        }
        this.connectionLog(System.Logger.Level.INFO, "read loop end");
    }

    @Override
    public int getHeartbeatFrequency() {
        return this.heartbeatFrequency.get();
    }

    @Override
    public void closeConnection() {
        try {
            this.socketClosed.set(true);
            this.connectionLog(System.Logger.Level.INFO, "Close connection called");
            this.readThread.interrupt();
            this.socket.close();
            BiConsumer<ServerConnection, Boolean> l = this.connectionListener.get();
            if (l != null) {
                l.accept(this, false);
            }
        }
        catch (IOException e) {
            this.logger.log(System.Logger.Level.ERROR, "Error closing socket " + this.socket.getRemoteSocketAddress(), (Throwable)e);
        }
    }

    @Override
    public long lastReceivedHeartbeat() {
        return this.lastHeartbeatRx.get();
    }

    @Override
    public long lastTransmittedHeartbeat() {
        return this.lastHeartbeatTx.get();
    }

    @Override
    public void sendCommand(MenuCommand command) {
        try {
            this.sendMenuCommand(command);
        }
        catch (Exception e) {
            this.connectionLog(System.Logger.Level.ERROR, "Connection error during send");
        }
    }

    @Override
    public boolean isConnected() {
        return !this.socketClosed.get();
    }

    @Override
    public void registerConnectionListener(BiConsumer<ServerConnection, Boolean> connectionListener) {
        this.connectionListener.set(connectionListener);
    }

    @Override
    public void registerMessageHandler(BiConsumer<ServerConnection, MenuCommand> messageHandler) {
        this.messageHandler.set(messageHandler);
    }

    @Override
    public boolean isPairing() {
        return this.pairingMode.get();
    }

    @Override
    public void enablePairingMode() {
        this.pairingMode.set(true);
    }

    @Override
    protected void getAtLeastBytes(ByteBuffer inputBuffer, int len, StreamRemoteConnector.ReadMode mode) throws IOException {
        if (mode == StreamRemoteConnector.ReadMode.ONLY_WHEN_EMPTY && inputBuffer.remaining() >= len) {
            return;
        }
        if (this.socketClosed.get()) {
            throw new IOException("Socket closed during read");
        }
        do {
            inputBuffer.compact();
            byte[] dataBytes = new byte[256];
            int actual = this.socket.getInputStream().read(dataBytes);
            inputBuffer.put(dataBytes, 0, actual);
            inputBuffer.flip();
            if (actual > 0) continue;
            throw new IOException("Socket probably closed, read return was 0 or less");
        } while (inputBuffer.remaining() < len);
    }

    @Override
    protected void sendInternal(ByteBuffer cmdBuffer) throws IOException {
        int remaining = cmdBuffer.remaining();
        byte[] data = new byte[remaining];
        cmdBuffer.get(data, 0, remaining);
        this.socket.getOutputStream().write(data);
        this.lastHeartbeatTx.set(this.clock.millis());
    }

    @Override
    public boolean isDeviceConnected() {
        return this.socket.isConnected();
    }

    @Override
    public String getConnectionName() {
        return this.socket.getRemoteSocketAddress().toString();
    }

    @Override
    public boolean canSendMessageNow(MenuCommand cmd) {
        return true;
    }
}

