/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.mgr;

import com.thecoderscorner.menu.remote.MenuCommandProtocol;
import com.thecoderscorner.menu.remote.mgr.NewServerConnectionListener;
import com.thecoderscorner.menu.remote.mgr.ServerConnection;
import com.thecoderscorner.menu.remote.mgr.ServerConnectionManager;
import com.thecoderscorner.menu.remote.mgr.SocketServerConnection;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.time.Clock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class SocketServerConnectionManager
implements ServerConnectionManager {
    private final System.Logger logger = System.getLogger(SocketServerConnectionManager.class.getSimpleName());
    private final Thread acceptThread;
    private final ServerSocket serverSocket;
    private final List<ServerConnection> connections = new CopyOnWriteArrayList<ServerConnection>();
    private final MenuCommandProtocol protocol;
    private final ScheduledFuture<?> taskFuture;
    private final int port;
    private final Clock clock;
    private volatile NewServerConnectionListener connectionListener;

    public SocketServerConnectionManager(MenuCommandProtocol protocol, ScheduledExecutorService service, int port, Clock clock) throws IOException {
        this.protocol = protocol;
        this.port = port;
        this.clock = clock;
        this.acceptThread = new Thread(this::acceptConnections);
        this.serverSocket = new ServerSocket();
        this.taskFuture = service.scheduleAtFixedRate(this::checkAllConnections, 1L, 1L, TimeUnit.SECONDS);
    }

    private void checkAllConnections() {
        ArrayList<ServerConnection> connectionsToRemove = new ArrayList<ServerConnection>();
        for (ServerConnection connection : this.connections) {
            if (connection.isConnected()) continue;
            connectionsToRemove.add(connection);
        }
        for (ServerConnection connection : connectionsToRemove) {
            this.connections.remove(connection);
        }
    }

    private void acceptConnections() {
        this.logger.log(System.Logger.Level.INFO, "Start accept thread");
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Socket sock = this.serverSocket.accept();
                this.logger.log(System.Logger.Level.INFO, "Accepted client " + sock.getRemoteSocketAddress());
                SocketServerConnection newConnection = new SocketServerConnection(sock, this.protocol, this.clock);
                this.connections.add(newConnection);
                this.connectionListener.connectionCreated(newConnection);
            }
            catch (IOException e) {
                this.logger.log(System.Logger.Level.ERROR, "Exception during accept", (Throwable)e);
            }
        }
        this.logger.log(System.Logger.Level.INFO, "End accept thread");
    }

    @Override
    public List<ServerConnection> getServerConnections() {
        if (this.connections.isEmpty()) {
            return List.of();
        }
        return List.copyOf(this.connections);
    }

    @Override
    public void start(NewServerConnectionListener listener) {
        this.logger.log(System.Logger.Level.INFO, "Start called on server manager - port " + this.port);
        this.connectionListener = listener;
        try {
            this.serverSocket.bind(new InetSocketAddress(this.port));
            this.acceptThread.start();
        }
        catch (IOException e) {
            this.logger.log(System.Logger.Level.ERROR, "Exception during start", (Throwable)e);
        }
    }

    @Override
    public void stop() {
        this.logger.log(System.Logger.Level.INFO, "Stop called on server manager");
        this.acceptThread.interrupt();
        this.taskFuture.cancel(true);
    }
}

