/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.mgr;

import com.thecoderscorner.menu.mgr.DialogShowMode;
import com.thecoderscorner.menu.remote.commands.DialogMode;
import com.thecoderscorner.menu.remote.commands.MenuButtonType;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommandType;
import com.thecoderscorner.menu.remote.commands.MenuDialogCommand;
import java.util.function.Function;

public abstract class DialogManager {
    protected final Object lock = new Object();
    protected DialogMode mode = DialogMode.HIDE;
    protected String title = "";
    protected String message = "";
    protected MenuButtonType button1 = MenuButtonType.NONE;
    protected MenuButtonType button2 = MenuButtonType.NONE;
    protected Function<MenuButtonType, Boolean> delegate;
    private DialogShowMode dialogShowMode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDialogVisible() {
        Object object = this.lock;
        synchronized (object) {
            return this.mode == DialogMode.SHOW;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStateFromCommand(MenuCommand cmd) {
        if (cmd.getCommandType() != MenuCommandType.DIALOG_UPDATE || this.dialogShowMode == DialogShowMode.LOCAL_DELEGATE_LOCKED) {
            return;
        }
        MenuDialogCommand dlgCmd = (MenuDialogCommand)cmd;
        Object object = this.lock;
        synchronized (object) {
            if (dlgCmd.getDialogMode() == DialogMode.ACTION) {
                this.buttonWasPressed(dlgCmd.getButton1());
            } else {
                this.mode = dlgCmd.getDialogMode();
                this.title = dlgCmd.getHeader();
                this.message = dlgCmd.getBuffer();
                this.button1 = dlgCmd.getButton1();
                this.button2 = dlgCmd.getButton2();
                this.dialogShowMode = DialogShowMode.REGULAR;
                this.delegate = null;
            }
        }
        this.dialogDidChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DialogManager withTitle(String title, boolean silent) {
        Object object = this.lock;
        synchronized (object) {
            this.title = title;
        }
        if (!silent) {
            this.dialogDidChange();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DialogManager withMessage(String message, boolean silent) {
        Object object = this.lock;
        synchronized (object) {
            this.message = message;
        }
        if (!silent) {
            this.dialogDidChange();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DialogManager withDelegate(DialogShowMode mode, Function<MenuButtonType, Boolean> delegate) {
        Object object = this.lock;
        synchronized (object) {
            this.dialogShowMode = mode;
            this.delegate = delegate;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showDialogWithButtons(MenuButtonType b1, MenuButtonType b2) {
        Object object = this.lock;
        synchronized (object) {
            this.button1 = b1;
            this.button2 = b2;
            this.mode = DialogMode.SHOW;
        }
        this.dialogDidChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideDialog() {
        Object object = this.lock;
        synchronized (object) {
            this.mode = DialogMode.HIDE;
            this.dialogShowMode = DialogShowMode.REGULAR;
        }
        this.dialogDidChange();
    }

    protected String toPrintableText(MenuButtonType type) {
        switch (type) {
            case NONE: {
                return "";
            }
            case OK: {
                return "OK";
            }
            case ACCEPT: {
                return "Accept";
            }
            case CANCEL: {
                return "Cancel";
            }
            case CLOSE: {
                return "Close";
            }
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DialogShowMode getDialogShowMode() {
        Object object = this.lock;
        synchronized (object) {
            return this.dialogShowMode;
        }
    }

    public MenuButtonType getButtonType(int btnNum) {
        return btnNum == 1 ? this.button1 : this.button2;
    }

    protected abstract void dialogDidChange();

    protected void buttonWasPressed(MenuButtonType btn) {
        boolean proceed;
        boolean bl = proceed = this.delegate != null ? this.delegate.apply(btn) : true;
        if (proceed) {
            this.hideDialog();
        }
    }
}

