/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.mgr;

import com.thecoderscorner.menu.domain.BooleanMenuItem;
import com.thecoderscorner.menu.domain.BooleanMenuItemBuilder;
import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.SubMenuItem;
import com.thecoderscorner.menu.domain.state.MenuTree;
import com.thecoderscorner.menu.domain.util.MenuItemHelper;
import com.thecoderscorner.menu.mgr.DialogShowMode;
import com.thecoderscorner.menu.mgr.MenuManagerListener;
import com.thecoderscorner.menu.mgr.MenuManagerServer;
import com.thecoderscorner.menu.remote.AuthStatus;
import com.thecoderscorner.menu.remote.RemoteConnector;
import com.thecoderscorner.menu.remote.commands.BootItemMenuCommand;
import com.thecoderscorner.menu.remote.commands.CommandFactory;
import com.thecoderscorner.menu.remote.commands.DialogMode;
import com.thecoderscorner.menu.remote.commands.MenuBootstrapCommand;
import com.thecoderscorner.menu.remote.commands.MenuButtonType;
import com.thecoderscorner.menu.remote.commands.MenuChangeCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.commands.MenuDialogCommand;
import com.thecoderscorner.menu.remote.protocol.CorrelationId;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class MenuInMenu {
    private final System.Logger logger = System.getLogger(this.getClass().getSimpleName());
    private final ReplicationMode replicationMode;
    private final int offsetRange;
    private final int maxRange;
    private final RemoteConnector remoteConnector;
    private final MenuManagerServer manager;
    private final SubMenuItem root;
    private final AtomicReference<AuthStatus> latestAuthStatus = new AtomicReference<AuthStatus>(AuthStatus.NOT_STARTED);
    private final AtomicReference<BooleanMenuItem> statusItem = new AtomicReference<Object>(null);
    private final AtomicBoolean bootInProgress = new AtomicBoolean(false);

    public MenuInMenu(RemoteConnector remoteConnector, MenuManagerServer manager, MenuItem root, ReplicationMode mode, int offsetRange, int maxRange) {
        this.offsetRange = offsetRange;
        this.maxRange = maxRange;
        this.remoteConnector = remoteConnector;
        this.manager = manager;
        this.replicationMode = mode;
        this.root = root instanceof SubMenuItem ? (SubMenuItem)root : MenuTree.ROOT;
    }

    public void start() {
        this.manager.addMenuManagerListener(new MenuInMenuManagerListener());
        this.remoteConnector.registerConnectorListener(this::processIncomingCommand);
        this.remoteConnector.registerConnectionChangeListener((connector, authStatus) -> {
            this.latestAuthStatus.set(authStatus);
            if (this.statusItem.get() != null) {
                this.manager.updateMenuItem(this.statusItem.get(), authStatus == AuthStatus.CONNECTION_READY);
            }
        });
        this.remoteConnector.start();
    }

    private void processIncomingCommand(RemoteConnector remoteConnector, MenuCommand menuCommand) {
        if (menuCommand instanceof BootItemMenuCommand) {
            BootItemMenuCommand boot = (BootItemMenuCommand)menuCommand;
            Object item = boot.getMenuItem();
            if (((MenuItem)item).getId() != MenuTree.ROOT.getId()) {
                MenuItem changedItem = MenuItemHelper.createFromExistingWithId(item, ((MenuItem)item).getId() + this.offsetRange);
                int modifiedParentId = boot.getSubMenuId() != 0 ? boot.getSubMenuId() + this.offsetRange : this.root.getId();
                MenuItem parent = this.manager.getManagedMenu().getMenuById(modifiedParentId).orElseThrow();
                this.manager.getManagedMenu().addMenuItem(MenuItemHelper.asSubMenu(parent), changedItem);
                this.manager.remoteUpdateHasOccurred(changedItem, boot.getCurrentValue());
                if (!this.bootInProgress.get() && this.replicationMode != ReplicationMode.REPLICATE_SILENTLY) {
                    this.manager.treeStructurallyChanged(parent);
                }
            }
        } else if (menuCommand instanceof MenuChangeCommand) {
            MenuChangeCommand change = (MenuChangeCommand)menuCommand;
            MenuItem item = this.manager.getManagedMenu().getMenuById(change.getMenuItemId() + this.offsetRange).orElseThrow();
            boolean isListChange = change.getChangeType() == MenuChangeCommand.ChangeType.ABSOLUTE_LIST;
            this.manager.remoteUpdateHasOccurred(item, isListChange ? change.getValues() : change.getValue());
        } else if (menuCommand instanceof MenuBootstrapCommand) {
            MenuBootstrapCommand bootstrap = (MenuBootstrapCommand)menuCommand;
            this.bootInProgress.set(bootstrap.getBootType() == MenuBootstrapCommand.BootType.START);
            if (bootstrap.getBootType() == MenuBootstrapCommand.BootType.END && this.replicationMode != ReplicationMode.REPLICATE_SILENTLY) {
                if (this.replicationMode == ReplicationMode.REPLICATE_ADD_STATUS_ITEM) {
                    this.statusItem.set(((BooleanMenuItemBuilder)((BooleanMenuItemBuilder)((BooleanMenuItemBuilder)((BooleanMenuItemBuilder)BooleanMenuItemBuilder.aBooleanMenuItemBuilder().withId(this.maxRange - 1)).withName(this.root.getName() + " connected")).withEepromAddr(-1)).withReadOnly(true)).menuItem());
                    this.manager.getManagedMenu().addMenuItem(this.root, this.statusItem.get());
                    MenuItemHelper.setMenuState(this.statusItem.get(), true, this.manager.getManagedMenu());
                }
                this.manager.treeStructurallyChanged(MenuTree.ROOT);
            }
        } else if (menuCommand instanceof MenuDialogCommand) {
            MenuDialogCommand dlg = (MenuDialogCommand)menuCommand;
            this.manager.getDialogManager().updateStateFromCommand(menuCommand);
            if (dlg.getDialogMode() == DialogMode.SHOW) {
                this.manager.getDialogManager().withDelegate(DialogShowMode.LOCAL_TO_DELEGATE, btn -> {
                    try {
                        remoteConnector.sendMenuCommand(new MenuDialogCommand(DialogMode.ACTION, "", "", (MenuButtonType)((Object)btn), MenuButtonType.NONE, CorrelationId.EMPTY_CORRELATION));
                    }
                    catch (IOException e) {
                        this.logger.log(System.Logger.Level.ERROR, "Unable to send dialog action " + btn, (Throwable)e);
                    }
                    return true;
                });
            }
        }
    }

    public AuthStatus getCurrentStatus() {
        return this.latestAuthStatus.get();
    }

    private boolean isWithinRange(MenuItem item) {
        return item.getId() >= this.offsetRange && item.getId() < this.maxRange;
    }

    public static enum ReplicationMode {
        REPLICATE_SILENTLY,
        REPLICATE_NOTIFY,
        REPLICATE_ADD_STATUS_ITEM;

    }

    private class MenuInMenuManagerListener
    implements MenuManagerListener {
        private MenuInMenuManagerListener() {
        }

        @Override
        public void menuItemHasChanged(MenuItem item, boolean remoteChange) {
            if (MenuInMenu.this.isWithinRange(item) && !remoteChange && MenuInMenu.this.remoteConnector.isDeviceConnected()) {
                try {
                    Object state = MenuItemHelper.getValueFor(item, MenuInMenu.this.manager.getManagedMenu(), MenuItemHelper.getDefaultFor(item));
                    MenuInMenu.this.remoteConnector.sendMenuCommand(CommandFactory.newAbsoluteMenuChangeCommand(CorrelationId.EMPTY_CORRELATION, item.getId() - MenuInMenu.this.offsetRange, state));
                }
                catch (IOException e) {
                    MenuInMenu.this.logger.log(System.Logger.Level.ERROR, MenuInMenu.this.remoteConnector.getConnectionName() + " - failed to send for " + item, (Throwable)e);
                }
            }
        }

        @Override
        public void managerWillStart() {
        }

        @Override
        public void managerWillStop() {
            MenuInMenu.this.remoteConnector.stop();
        }
    }
}

