/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.states;

import com.thecoderscorner.menu.remote.AuthStatus;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.states.RemoteConnectorContext;
import com.thecoderscorner.menu.remote.states.RemoteConnectorState;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class NoOperationInitialState
implements RemoteConnectorState {
    private final CountDownLatch latch = new CountDownLatch(1);
    private AtomicBoolean exited = new AtomicBoolean(false);

    public NoOperationInitialState(RemoteConnectorContext context) {
    }

    @Override
    public void enterState() {
    }

    @Override
    public void exitState(RemoteConnectorState nextState) {
        this.latch.countDown();
    }

    @Override
    public AuthStatus getAuthenticationStatus() {
        return AuthStatus.NOT_STARTED;
    }

    @Override
    public boolean canSendCommandToRemote(MenuCommand command) {
        return false;
    }

    @Override
    public void runLoop() throws Exception {
        if (this.exited.get()) {
            return;
        }
        this.exited.set(this.latch.await(500L, TimeUnit.MILLISECONDS));
    }
}

