/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain.util;

import com.thecoderscorner.menu.domain.ActionMenuItem;
import com.thecoderscorner.menu.domain.ActionMenuItemBuilder;
import com.thecoderscorner.menu.domain.AnalogMenuItem;
import com.thecoderscorner.menu.domain.AnalogMenuItemBuilder;
import com.thecoderscorner.menu.domain.BooleanMenuItem;
import com.thecoderscorner.menu.domain.BooleanMenuItemBuilder;
import com.thecoderscorner.menu.domain.CustomBuilderMenuItem;
import com.thecoderscorner.menu.domain.CustomBuilderMenuItemBuilder;
import com.thecoderscorner.menu.domain.EditItemType;
import com.thecoderscorner.menu.domain.EditableLargeNumberMenuItem;
import com.thecoderscorner.menu.domain.EditableLargeNumberMenuItemBuilder;
import com.thecoderscorner.menu.domain.EditableTextMenuItem;
import com.thecoderscorner.menu.domain.EditableTextMenuItemBuilder;
import com.thecoderscorner.menu.domain.EnumMenuItem;
import com.thecoderscorner.menu.domain.EnumMenuItemBuilder;
import com.thecoderscorner.menu.domain.FloatMenuItem;
import com.thecoderscorner.menu.domain.FloatMenuItemBuilder;
import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.MenuItemBuilder;
import com.thecoderscorner.menu.domain.Rgb32MenuItem;
import com.thecoderscorner.menu.domain.Rgb32MenuItemBuilder;
import com.thecoderscorner.menu.domain.RuntimeListMenuItem;
import com.thecoderscorner.menu.domain.RuntimeListMenuItemBuilder;
import com.thecoderscorner.menu.domain.ScrollChoiceMenuItem;
import com.thecoderscorner.menu.domain.ScrollChoiceMenuItemBuilder;
import com.thecoderscorner.menu.domain.SubMenuItem;
import com.thecoderscorner.menu.domain.SubMenuItemBuilder;
import com.thecoderscorner.menu.domain.state.AnyMenuState;
import com.thecoderscorner.menu.domain.state.BigDecimalMenuState;
import com.thecoderscorner.menu.domain.state.BooleanMenuState;
import com.thecoderscorner.menu.domain.state.CurrentScrollPosition;
import com.thecoderscorner.menu.domain.state.CurrentScrollPositionMenuState;
import com.thecoderscorner.menu.domain.state.FloatMenuState;
import com.thecoderscorner.menu.domain.state.IntegerMenuState;
import com.thecoderscorner.menu.domain.state.MenuTree;
import com.thecoderscorner.menu.domain.state.PortableColor;
import com.thecoderscorner.menu.domain.state.PortableColorMenuState;
import com.thecoderscorner.menu.domain.state.StringListMenuState;
import com.thecoderscorner.menu.domain.state.StringMenuState;
import com.thecoderscorner.menu.domain.util.AbstractMenuItemVisitor;
import com.thecoderscorner.menu.remote.commands.BootItemMenuCommand;
import com.thecoderscorner.menu.remote.commands.MenuActionBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuAnalogBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuBooleanBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuEnumBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuFloatBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuLargeNumBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuRgb32BootCommand;
import com.thecoderscorner.menu.remote.commands.MenuRuntimeListBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuScrollChoiceBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuSubBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuTextBootCommand;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;

public class MenuItemHelper {
    public static <T> Optional<T> visitWithResult(MenuItem item, AbstractMenuItemVisitor<T> visitor) {
        item.accept(visitor);
        return visitor.getResult();
    }

    public static SubMenuItem asSubMenu(MenuItem item) {
        return MenuItemHelper.visitWithResult(item, new AbstractMenuItemVisitor<SubMenuItem>(){

            @Override
            public void visit(SubMenuItem item) {
                this.setResult(item);
            }

            @Override
            public void anyItem(MenuItem item) {
            }
        }).orElse(null);
    }

    public static boolean isRuntimeStructureNeeded(MenuItem item) {
        return MenuItemHelper.visitWithResult(item, new AbstractMenuItemVisitor<Boolean>(){

            @Override
            public void visit(RuntimeListMenuItem listItem) {
                this.setResult(true);
            }

            @Override
            public void visit(EditableTextMenuItem item) {
                this.setResult(true);
            }

            @Override
            public void visit(EditableLargeNumberMenuItem item) {
                this.setResult(true);
            }

            @Override
            public void visit(ScrollChoiceMenuItem scrollItem) {
                this.setResult(true);
            }

            @Override
            public void visit(Rgb32MenuItem rgbItem) {
                this.setResult(true);
            }

            @Override
            public void visit(SubMenuItem item) {
                this.setResult(true);
            }

            @Override
            public void anyItem(MenuItem item) {
                this.setResult(false);
            }
        }).orElse(false);
    }

    public static MenuItemBuilder builderWithExisting(MenuItem item) {
        return MenuItemHelper.visitWithResult(item, new AbstractMenuItemVisitor<MenuItemBuilder>(){

            @Override
            public void visit(AnalogMenuItem item) {
                this.setResult(AnalogMenuItemBuilder.anAnalogMenuItemBuilder().withExisting(item));
            }

            @Override
            public void visit(BooleanMenuItem item) {
                this.setResult(BooleanMenuItemBuilder.aBooleanMenuItemBuilder().withExisting(item));
            }

            @Override
            public void visit(EnumMenuItem item) {
                this.setResult(EnumMenuItemBuilder.anEnumMenuItemBuilder().withExisting(item));
            }

            @Override
            public void visit(SubMenuItem item) {
                this.setResult(SubMenuItemBuilder.aSubMenuItemBuilder().withExisting(item));
            }

            @Override
            public void visit(EditableTextMenuItem item) {
                this.setResult(EditableTextMenuItemBuilder.aTextMenuItemBuilder().withExisting(item));
            }

            @Override
            public void visit(EditableLargeNumberMenuItem item) {
                this.setResult(EditableLargeNumberMenuItemBuilder.aLargeNumberItemBuilder().withExisting(item));
            }

            @Override
            public void visit(FloatMenuItem item) {
                this.setResult(FloatMenuItemBuilder.aFloatMenuItemBuilder().withExisting(item));
            }

            @Override
            public void visit(Rgb32MenuItem item) {
                this.setResult(new Rgb32MenuItemBuilder().withExisting(item));
            }

            @Override
            public void visit(CustomBuilderMenuItem item) {
                this.setResult(new CustomBuilderMenuItemBuilder().withExisting(item));
            }

            @Override
            public void visit(ScrollChoiceMenuItem item) {
                this.setResult(new ScrollChoiceMenuItemBuilder().withExisting(item));
            }

            @Override
            public void visit(ActionMenuItem item) {
                this.setResult(ActionMenuItemBuilder.anActionMenuItemBuilder().withExisting(item));
            }

            @Override
            public void visit(RuntimeListMenuItem item) {
                this.setResult(RuntimeListMenuItemBuilder.aRuntimeListMenuItemBuilder().withExisting(item));
            }
        }).orElseThrow(IllegalStateException::new);
    }

    public static MenuItem createFromExistingWithId(MenuItem selected, int newId) {
        MenuItemBuilder builder = MenuItemHelper.builderWithExisting(selected);
        builder.withId(newId);
        return builder.menuItem();
    }

    public static int eepromSizeForItem(MenuItem item) {
        if (item == null) {
            return 0;
        }
        return MenuItemHelper.visitWithResult(item, new AbstractMenuItemVisitor<Integer>(){

            @Override
            public void visit(AnalogMenuItem item) {
                this.setResult(2);
            }

            @Override
            public void visit(BooleanMenuItem item) {
                this.setResult(1);
            }

            @Override
            public void visit(EnumMenuItem item) {
                this.setResult(2);
            }

            @Override
            public void visit(EditableLargeNumberMenuItem numItem) {
                this.setResult(8);
            }

            @Override
            public void visit(Rgb32MenuItem numItem) {
                this.setResult(4);
            }

            @Override
            public void visit(ScrollChoiceMenuItem numItem) {
                this.setResult(2);
            }

            @Override
            public void visit(EditableTextMenuItem item) {
                if (item.getItemType() == EditItemType.IP_ADDRESS) {
                    this.setResult(4);
                } else if (item.getItemType() == EditItemType.PLAIN_TEXT) {
                    this.setResult(item.getTextLength());
                } else {
                    this.setResult(4);
                }
            }

            @Override
            public void anyItem(MenuItem item) {
                this.setResult(0);
            }
        }).orElse(0);
    }

    public static AnyMenuState stateForMenuItem(AnyMenuState existingState, MenuItem item, Object val) {
        boolean changed = false;
        boolean active = false;
        if (existingState != null) {
            changed = existingState.isChanged();
            active = existingState.isActive();
        }
        return MenuItemHelper.stateForMenuItem(item, val, changed, active);
    }

    public static AnyMenuState stateForMenuItem(AnyMenuState existingState, MenuItem item, Object val, boolean changed) {
        boolean active = false;
        if (existingState != null) {
            active = existingState.isActive();
        }
        return MenuItemHelper.stateForMenuItem(item, val, changed, active);
    }

    public static Optional<AnyMenuState> applyIncrementalValueChange(MenuItem item, int delta, MenuTree tree) {
        Object state = tree.getMenuState(item);
        if (state == null) {
            state = MenuItemHelper.stateForMenuItem(item, 0, false, false);
        }
        if (state.getStorageType() == AnyMenuState.StateStorageType.INTEGER) {
            IntegerMenuState intState = (IntegerMenuState)state;
            int val = (Integer)intState.getValue() + delta;
            if (val < 0 || item instanceof AnalogMenuItem && val > ((AnalogMenuItem)item).getMaxValue() || item instanceof EnumMenuItem && val > ((EnumMenuItem)item).getEnumEntries().size()) {
                return Optional.empty();
            }
            AnyMenuState menuState = MenuItemHelper.stateForMenuItem(intState, item, (Integer)intState.getValue() + delta);
            tree.changeItem(item, menuState);
            return Optional.ofNullable(menuState);
        }
        if (state.getStorageType() == AnyMenuState.StateStorageType.SCROLL_POSITION) {
            CurrentScrollPositionMenuState scrState = (CurrentScrollPositionMenuState)state;
            int val = ((CurrentScrollPosition)scrState.getValue()).getPosition() + delta;
            if (val <= 0 || item instanceof ScrollChoiceMenuItem && val >= ((ScrollChoiceMenuItem)item).getNumEntries()) {
                return Optional.empty();
            }
            CurrentScrollPosition currentScrollPosition = new CurrentScrollPosition(((CurrentScrollPosition)scrState.getValue()).getPosition() + delta, "");
            AnyMenuState menuState = MenuItemHelper.stateForMenuItem(scrState, item, currentScrollPosition);
            tree.changeItem(item, menuState);
            return Optional.ofNullable(menuState);
        }
        return Optional.empty();
    }

    public static AnyMenuState stateForMenuItem(final MenuItem item, Object v, final boolean changed, final boolean active) {
        if (item == null) {
            return new BooleanMenuState(item, false, false, false);
        }
        final Object val = v != null ? v : MenuItemHelper.defaultValueForItem(item);
        return MenuItemHelper.visitWithResult(item, new AbstractMenuItemVisitor<AnyMenuState>(){

            @Override
            public void visit(AnalogMenuItem item2) {
                int res;
                int n = res = val instanceof String ? Integer.parseInt(val.toString()) : ((Number)val).intValue();
                if (res < 0) {
                    res = 0;
                }
                if (res > item2.getMaxValue()) {
                    res = item2.getMaxValue();
                }
                this.setResult(new IntegerMenuState(item2, changed, active, res));
            }

            @Override
            public void visit(BooleanMenuItem item2) {
                boolean res = val instanceof String ? (((String)val).length() == 1 ? ((String)val).charAt(0) == '1' || ((String)val).charAt(0) == 'Y' : Boolean.parseBoolean((String)val)) : (val instanceof Number ? ((Number)val).intValue() != 0 : (Boolean)val);
                this.setResult(new BooleanMenuState(item2, changed, active, res));
            }

            @Override
            public void visit(EnumMenuItem item2) {
                int res;
                int n = res = val instanceof String ? Integer.parseInt(val.toString()) : ((Number)val).intValue();
                if (res < 0) {
                    res = 0;
                }
                if (res >= item2.getEnumEntries().size()) {
                    res = item2.getEnumEntries().size() - 1;
                }
                this.setResult(new IntegerMenuState(item2, changed, active, res));
            }

            @Override
            public void visit(SubMenuItem item2) {
                this.setResult(new BooleanMenuState(item2, changed, active, false));
                super.visit(item2);
            }

            @Override
            public void visit(EditableTextMenuItem item2) {
                this.setResult(new StringMenuState(item2, changed, active, val.toString()));
            }

            @Override
            public void visit(ActionMenuItem item2) {
                this.setResult(new BooleanMenuState(item2, changed, active, false));
            }

            @Override
            public void visit(FloatMenuItem item2) {
                float res = val instanceof String ? Float.parseFloat(val.toString()) : ((Number)val).floatValue();
                this.setResult(new FloatMenuState(item2, changed, active, Float.valueOf(res)));
            }

            @Override
            public void visit(RuntimeListMenuItem listItem) {
                this.setResult(new StringListMenuState(item, changed, active, (List)val));
            }

            @Override
            public void visit(EditableLargeNumberMenuItem numItem) {
                BigDecimal dec;
                if (val instanceof String) {
                    String value = ((String)val).replaceAll("[\\[\\]]", "");
                    dec = new BigDecimal(value);
                } else {
                    dec = (BigDecimal)val;
                }
                this.setResult(new BigDecimalMenuState(item, changed, active, dec));
            }

            @Override
            public void visit(ScrollChoiceMenuItem scrollItem) {
                CurrentScrollPosition pos = val instanceof Integer ? new CurrentScrollPosition((Integer)val, "") : (val instanceof CurrentScrollPosition ? (CurrentScrollPosition)val : new CurrentScrollPosition(val.toString()));
                if (pos.getPosition() >= 0 && pos.getPosition() < scrollItem.getNumEntries()) {
                    this.setResult(new CurrentScrollPositionMenuState(item, changed, active, pos));
                } else {
                    this.setResult(new CurrentScrollPositionMenuState(scrollItem, changed, active, new CurrentScrollPosition(0, "No entries")));
                }
            }

            @Override
            public void visit(Rgb32MenuItem rgbItem) {
                PortableColor res = val instanceof String ? new PortableColor(val.toString()) : (PortableColor)val;
                this.setResult(new PortableColorMenuState(item, changed, active, res));
            }

            @Override
            public void anyItem(MenuItem item2) {
                this.setResult(new BooleanMenuState(item2, changed, active, false));
            }
        }).orElseThrow();
    }

    private static Object defaultValueForItem(MenuItem item) {
        return MenuItemHelper.visitWithResult(item, new AbstractMenuItemVisitor<Object>(){

            @Override
            public void visit(AnalogMenuItem item) {
                this.setResult(0);
            }

            @Override
            public void visit(EnumMenuItem item) {
                this.setResult(0);
            }

            @Override
            public void visit(EditableTextMenuItem item) {
                this.setResult("");
            }

            @Override
            public void visit(FloatMenuItem item) {
                this.setResult(Float.valueOf(0.0f));
            }

            @Override
            public void visit(ScrollChoiceMenuItem scrollItem) {
                this.setResult(new CurrentScrollPosition(0, ""));
            }

            @Override
            public void visit(RuntimeListMenuItem listItem) {
                this.setResult(List.of());
            }

            @Override
            public void visit(EditableLargeNumberMenuItem numItem) {
                this.setResult(BigDecimal.ZERO);
            }

            @Override
            public void visit(Rgb32MenuItem rgbItem) {
                this.setResult(new PortableColor("#000000"));
            }

            @Override
            public void anyItem(MenuItem item) {
                this.setResult(false);
            }
        }).orElse(false);
    }

    public static void setMenuState(MenuItem item, Object value, MenuTree tree) {
        Object oldState = tree.getMenuState(item);
        if (oldState != null) {
            tree.changeItem(item, MenuItemHelper.stateForMenuItem(item, value, !value.equals(oldState.getValue()), oldState.isActive()));
        } else {
            tree.changeItem(item, MenuItemHelper.stateForMenuItem(item, value, false, false));
        }
    }

    public static <T> T getValueFor(MenuItem item, MenuTree tree, T def) {
        if (tree.getMenuState(item) != null) {
            try {
                return (T)tree.getMenuState(item).getValue();
            }
            catch (Exception ex) {
                System.getLogger(MenuItemHelper.class.getSimpleName()).log(System.Logger.Level.ERROR, "State type incorrect", (Throwable)ex);
            }
        }
        tree.changeItem(item, MenuItemHelper.stateForMenuItem(item, def, false, false));
        return def;
    }

    public static Optional<BootItemMenuCommand<?, ?>> getBootMsgForItem(MenuItem item, SubMenuItem parent, MenuTree tree) {
        if (item instanceof AnalogMenuItem) {
            return Optional.of(new MenuAnalogBootCommand(parent.getId(), (AnalogMenuItem)item, MenuItemHelper.getValueFor(item, tree, 0)));
        }
        if (item instanceof EnumMenuItem) {
            return Optional.of(new MenuEnumBootCommand(parent.getId(), (EnumMenuItem)item, MenuItemHelper.getValueFor(item, tree, 0)));
        }
        if (item instanceof FloatMenuItem) {
            return Optional.of(new MenuFloatBootCommand(parent.getId(), (FloatMenuItem)item, MenuItemHelper.getValueFor(item, tree, Float.valueOf(0.0f))));
        }
        if (item instanceof BooleanMenuItem) {
            return Optional.of(new MenuBooleanBootCommand(parent.getId(), (BooleanMenuItem)item, MenuItemHelper.getValueFor(item, tree, false)));
        }
        if (item instanceof SubMenuItem) {
            return Optional.of(new MenuSubBootCommand(parent.getId(), (SubMenuItem)item, false));
        }
        if (item instanceof ActionMenuItem) {
            return Optional.of(new MenuActionBootCommand(parent.getId(), (ActionMenuItem)item, false));
        }
        if (item instanceof EditableLargeNumberMenuItem) {
            return Optional.of(new MenuLargeNumBootCommand(parent.getId(), (EditableLargeNumberMenuItem)item, MenuItemHelper.getValueFor(item, tree, BigDecimal.ZERO)));
        }
        if (item instanceof EditableTextMenuItem) {
            return Optional.of(new MenuTextBootCommand(parent.getId(), (EditableTextMenuItem)item, MenuItemHelper.getValueFor(item, tree, "")));
        }
        if (item instanceof Rgb32MenuItem) {
            return Optional.of(new MenuRgb32BootCommand(parent.getId(), (Rgb32MenuItem)item, MenuItemHelper.getValueFor(item, tree, new PortableColor(0, 0, 0))));
        }
        if (item instanceof RuntimeListMenuItem) {
            return Optional.of(new MenuRuntimeListBootCommand(parent.getId(), (RuntimeListMenuItem)item, MenuItemHelper.getValueFor(item, tree, List.of())));
        }
        if (item instanceof ScrollChoiceMenuItem) {
            return Optional.of(new MenuScrollChoiceBootCommand(parent.getId(), (ScrollChoiceMenuItem)item, MenuItemHelper.getValueFor(item, tree, new CurrentScrollPosition(0, ""))));
        }
        return Optional.empty();
    }

    public static Object getDefaultFor(MenuItem item) {
        if (item instanceof AnalogMenuItem || item instanceof EnumMenuItem) {
            return 0;
        }
        if (item instanceof FloatMenuItem) {
            return Float.valueOf(0.0f);
        }
        if (item instanceof BooleanMenuItem || item instanceof SubMenuItem || item instanceof ActionMenuItem) {
            return false;
        }
        if (item instanceof EditableLargeNumberMenuItem) {
            return BigDecimal.ZERO;
        }
        if (item instanceof EditableTextMenuItem) {
            return "";
        }
        if (item instanceof Rgb32MenuItem) {
            return new PortableColor(0, 0, 0);
        }
        if (item instanceof RuntimeListMenuItem) {
            return List.of();
        }
        if (item instanceof ScrollChoiceMenuItem) {
            return new CurrentScrollPosition(0, "");
        }
        return false;
    }
}

