/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.mgr;

import com.thecoderscorner.menu.auth.MenuAuthenticator;
import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.ScrollChoiceMenuItem;
import com.thecoderscorner.menu.domain.state.AnyMenuState;
import com.thecoderscorner.menu.domain.state.CurrentScrollPosition;
import com.thecoderscorner.menu.domain.state.CurrentScrollPositionMenuState;
import com.thecoderscorner.menu.domain.state.ListResponse;
import com.thecoderscorner.menu.domain.state.MenuTree;
import com.thecoderscorner.menu.domain.state.StringListMenuState;
import com.thecoderscorner.menu.domain.util.MenuItemFormatter;
import com.thecoderscorner.menu.domain.util.MenuItemHelper;
import com.thecoderscorner.menu.mgr.DialogManager;
import com.thecoderscorner.menu.mgr.EmptyDialogManager;
import com.thecoderscorner.menu.mgr.MenuCallback;
import com.thecoderscorner.menu.mgr.MenuManagerListener;
import com.thecoderscorner.menu.mgr.MenuTreeStructureChangeListener;
import com.thecoderscorner.menu.mgr.NewServerConnectionListener;
import com.thecoderscorner.menu.mgr.ScrollChoiceValueRetriever;
import com.thecoderscorner.menu.mgr.ServerConnection;
import com.thecoderscorner.menu.mgr.ServerConnectionManager;
import com.thecoderscorner.menu.mgr.ServerConnectionMode;
import com.thecoderscorner.menu.remote.commands.AckStatus;
import com.thecoderscorner.menu.remote.commands.BootItemMenuCommand;
import com.thecoderscorner.menu.remote.commands.MenuAcknowledgementCommand;
import com.thecoderscorner.menu.remote.commands.MenuBootstrapCommand;
import com.thecoderscorner.menu.remote.commands.MenuChangeCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommandType;
import com.thecoderscorner.menu.remote.commands.MenuHeartbeatCommand;
import com.thecoderscorner.menu.remote.commands.MenuJoinCommand;
import com.thecoderscorner.menu.remote.commands.MenuPairingCommand;
import com.thecoderscorner.menu.remote.protocol.ApiPlatform;
import com.thecoderscorner.menu.remote.protocol.CorrelationId;
import com.thecoderscorner.menu.remote.protocol.MessageField;
import java.lang.reflect.Method;
import java.time.Clock;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class MenuManagerServer
implements NewServerConnectionListener {
    public static final Set<MessageField> MSGTYPES_CANNOT_OVERRIDE = Set.of(MenuCommandType.CHANGE_INT_FIELD, MenuCommandType.DIALOG_UPDATE, MenuCommandType.JOIN, MenuCommandType.HEARTBEAT, MenuCommandType.PAIRING_REQUEST, MenuCommandType.BOOTSTRAP);
    private final System.Logger logger = System.getLogger(MenuManagerServer.class.getSimpleName());
    private final ScheduledExecutorService executorService;
    private final MenuTree tree;
    private final List<ServerConnectionManager> connectionManagers = new CopyOnWriteArrayList<ServerConnectionManager>();
    private final Map<MessageField, BiConsumer<MenuManagerServer, MenuCommand>> customMessageHandlers = new ConcurrentHashMap<MessageField, BiConsumer<MenuManagerServer, MenuCommand>>();
    private final String serverName;
    private final UUID serverUuid;
    private final MenuAuthenticator authenticator;
    private final AtomicReference<DialogManager> dialogManager = new AtomicReference<EmptyDialogManager>(new EmptyDialogManager());
    private final Clock clock;
    private final AtomicBoolean alreadyStarted = new AtomicBoolean(false);
    private final List<MenuManagerListener> eventListeners = new CopyOnWriteArrayList<MenuManagerListener>();
    private ScheduledFuture<?> hbScheduleThread;
    private final Map<Integer, MethodWithObject> mapOfCallbacksById = new ConcurrentHashMap<Integer, MethodWithObject>();
    private final Map<Integer, MethodWithObject> mapOfChoicePopulatorsById = new ConcurrentHashMap<Integer, MethodWithObject>();
    private final List<MenuTreeStructureChangeListener> structureChangeListeners = new CopyOnWriteArrayList<MenuTreeStructureChangeListener>();

    public MenuManagerServer(ScheduledExecutorService executorService, MenuTree tree, String serverName, UUID uuid, MenuAuthenticator authenticator, Clock clock) {
        this.executorService = executorService;
        this.tree = tree;
        this.serverName = serverName;
        this.serverUuid = uuid;
        this.authenticator = authenticator;
        this.clock = clock;
    }

    public void addCustomMessageProcessor(MessageField msgType, BiConsumer<MenuManagerServer, MenuCommand> processor) {
        if (MSGTYPES_CANNOT_OVERRIDE.contains(msgType)) {
            throw new IllegalArgumentException("You cannot override core type" + msgType);
        }
        this.customMessageHandlers.put(msgType, processor);
    }

    public void setDialogManager(DialogManager manager) {
        this.dialogManager.set(manager);
    }

    public DialogManager getDialogManager() {
        return this.dialogManager.get();
    }

    public void addConnectionManager(ServerConnectionManager manager) {
        if (this.alreadyStarted.get()) {
            throw new IllegalStateException("You must add connection managers before starting");
        }
        this.connectionManagers.add(manager);
    }

    public void addMenuManagerListener(MenuManagerListener listener) {
        this.eventListeners.add(listener);
        for (Method method : listener.getClass().getMethods()) {
            ScrollChoiceValueRetriever scrollAnnotation;
            MenuCallback callbackAnnotation = method.getAnnotation(MenuCallback.class);
            if (callbackAnnotation != null) {
                this.mapOfCallbacksById.put(callbackAnnotation.id(), new MethodWithObject(method, listener, callbackAnnotation.listResult()));
            }
            if ((scrollAnnotation = method.getAnnotation(ScrollChoiceValueRetriever.class)) == null) continue;
            this.mapOfChoicePopulatorsById.put(scrollAnnotation.id(), new MethodWithObject(method, listener, false));
        }
        if (this.alreadyStarted.get()) {
            listener.managerWillStart();
        }
    }

    public void addTreeStructureChangeListener(MenuTreeStructureChangeListener structureListener) {
        this.structureChangeListeners.add(structureListener);
    }

    public void start() {
        if (this.alreadyStarted.get()) {
            return;
        }
        this.alreadyStarted.set(true);
        try {
            for (MenuManagerListener listener : this.eventListeners) {
                listener.managerWillStart();
            }
        }
        catch (Exception ex) {
            this.logger.log(System.Logger.Level.ERROR, "Unexpected exception while processing start listeners in manager", (Throwable)ex);
        }
        for (ServerConnectionManager mgr : this.connectionManagers) {
            try {
                mgr.start(this);
            }
            catch (Exception ex) {
                this.logger.log(System.Logger.Level.ERROR, "Unexpected exception while starting connection manager " + mgr);
            }
        }
        this.hbScheduleThread = this.executorService.scheduleAtFixedRate(this::checkHeartbeats, 200L, 200L, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        try {
            for (MenuManagerListener listener : this.eventListeners) {
                listener.managerWillStop();
            }
        }
        catch (Exception ex) {
            this.logger.log(System.Logger.Level.ERROR, "Unexpected exception while processing start listeners in manager", (Throwable)ex);
        }
        this.alreadyStarted.set(false);
        if (this.hbScheduleThread != null) {
            this.hbScheduleThread.cancel(false);
            this.hbScheduleThread = null;
        }
        try {
            for (ServerConnectionManager mgr : this.connectionManagers) {
                mgr.stop();
            }
        }
        catch (Exception e) {
            this.logger.log(System.Logger.Level.ERROR, "Server manager threw error during stop", (Throwable)e);
        }
    }

    void checkHeartbeats() {
        for (ServerConnection socket : this.getAllServerConnections()) {
            if (this.clock.millis() - socket.lastReceivedHeartbeat() > (long)socket.getHeartbeatFrequency() * 3L) {
                this.logger.log(System.Logger.Level.WARNING, "HB timeout, no received message within frequency");
                socket.closeConnection();
                continue;
            }
            if (this.clock.millis() - socket.lastTransmittedHeartbeat() <= (long)socket.getHeartbeatFrequency()) continue;
            this.logger.log(System.Logger.Level.INFO, "Sending HB due to inactivity");
            this.executorService.execute(() -> socket.sendCommand(new MenuHeartbeatCommand(socket.getHeartbeatFrequency(), MenuHeartbeatCommand.HeartbeatMode.NORMAL)));
        }
    }

    public boolean isAnyRemoteConnection() {
        for (ServerConnectionManager sm : this.connectionManagers) {
            if (sm.getServerConnections().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public List<ServerConnection> getAllServerConnections() {
        return this.connectionManagers.stream().flatMap(cm -> cm.getServerConnections().stream()).collect(Collectors.toList());
    }

    @Override
    public void connectionCreated(ServerConnection connection) {
        connection.registerMessageHandler(this::messageReceived);
        connection.sendCommand(new MenuHeartbeatCommand(connection.getHeartbeatFrequency(), MenuHeartbeatCommand.HeartbeatMode.START));
    }

    private void messageReceived(ServerConnection conn, MenuCommand cmd) {
        try {
            if (conn.getConnectionMode() == ServerConnectionMode.PAIRING) {
                this.logger.log(System.Logger.Level.INFO, "Connection is in pairing mode, ignoring " + cmd);
                return;
            }
            if (this.customMessageHandlers.containsKey(cmd.getCommandType()) && conn.getConnectionMode() == ServerConnectionMode.AUTHENTICATED) {
                this.logger.log(System.Logger.Level.DEBUG, "Received custom message that we handle " + cmd.getCommandType());
                this.customMessageHandlers.get(cmd.getCommandType()).accept(this, cmd);
            } else if (cmd.getCommandType().equals(MenuCommandType.JOIN)) {
                MenuJoinCommand join = (MenuJoinCommand)cmd;
                if (this.authenticator != null && !this.authenticator.authenticate(join.getMyName(), join.getAppUuid())) {
                    this.logger.log(System.Logger.Level.WARNING, "Invalid credentials from " + join.getMyName());
                    conn.sendCommand(new MenuAcknowledgementCommand(CorrelationId.EMPTY_CORRELATION, AckStatus.INVALID_CREDENTIALS));
                    conn.closeConnection();
                } else {
                    conn.setConnectionMode(ServerConnectionMode.AUTHENTICATED);
                    this.logger.log(System.Logger.Level.WARNING, "Successful login from " + join.getMyName());
                    conn.sendCommand(new MenuAcknowledgementCommand(CorrelationId.EMPTY_CORRELATION, AckStatus.SUCCESS));
                    conn.sendCommand(new MenuBootstrapCommand(MenuBootstrapCommand.BootType.START));
                    this.tree.recurseTreeIteratingOnItems(MenuTree.ROOT, (item, parent) -> {
                        if (!item.isLocalOnly()) {
                            Optional<BootItemMenuCommand<?, ?>> bootMsg = MenuItemHelper.getBootMsgForItem(item, parent, this.tree);
                            bootMsg.ifPresent(conn::sendCommand);
                        }
                    });
                    conn.sendCommand(new MenuBootstrapCommand(MenuBootstrapCommand.BootType.END));
                }
            } else if (cmd.getCommandType().equals(MenuCommandType.PAIRING_REQUEST)) {
                this.startPairingMode(conn, (MenuPairingCommand)cmd);
            } else if (cmd.getCommandType().equals(MenuCommandType.HEARTBEAT)) {
                MenuHeartbeatCommand hb = (MenuHeartbeatCommand)cmd;
                if (hb.getMode() == MenuHeartbeatCommand.HeartbeatMode.START) {
                    conn.sendCommand(new MenuJoinCommand(this.serverUuid, this.serverName, ApiPlatform.JAVA_API, 1));
                }
            } else if (cmd.getCommandType().equals(MenuCommandType.CHANGE_INT_FIELD)) {
                if (conn.getConnectionMode() != ServerConnectionMode.AUTHENTICATED) {
                    this.logger.log(System.Logger.Level.WARNING, "Un-authenticated change command ignored");
                    return;
                }
                this.handleIncomingChange(conn, (MenuChangeCommand)cmd);
            }
        }
        catch (Exception e) {
            conn.closeConnection();
        }
    }

    private void startPairingMode(ServerConnection conn, MenuPairingCommand cmd) {
        conn.setConnectionMode(ServerConnectionMode.PAIRING);
        this.authenticator.addAuthentication(cmd.getName(), cmd.getUuid(), true).thenApply(success -> {
            AckStatus determinedStatus = success != false ? AckStatus.SUCCESS : AckStatus.INVALID_CREDENTIALS;
            conn.sendCommand(new MenuAcknowledgementCommand(CorrelationId.EMPTY_CORRELATION, determinedStatus));
            return true;
        });
    }

    public MenuTree getManagedMenu() {
        return this.tree;
    }

    public void updateMenuItem(Object sender, MenuItem item, Object newValue) {
        if (newValue instanceof ListResponse) {
            this.fireEventToListeners(this, item, newValue);
        } else {
            MenuItemHelper.setMenuState(item, newValue, this.tree);
            this.menuItemDidUpdate(sender, item);
        }
    }

    public void menuItemDidUpdate(Object sender, MenuItem item) {
        this.logger.log(System.Logger.Level.INFO, "Sending item update for " + item);
        Object state = this.tree.getMenuState(item);
        if (state == null) {
            return;
        }
        this.applyScrollChoiceValueIfNeeded(item, (AnyMenuState)state);
        this.fireEventToListeners(sender, item, state.getValue());
        MenuChangeCommand cmd = state instanceof StringListMenuState ? new MenuChangeCommand(CorrelationId.EMPTY_CORRELATION, item.getId(), (List)((StringListMenuState)state).getValue()) : new MenuChangeCommand(CorrelationId.EMPTY_CORRELATION, item.getId(), MenuChangeCommand.ChangeType.ABSOLUTE, MenuItemFormatter.formatToWire(item, state.getValue().toString()));
        this.updateRemotesWithLatestState(cmd);
    }

    public void treeStructurallyChanged(MenuItem hint) {
        this.logger.log(System.Logger.Level.INFO, "Tree structure has changed around " + hint);
        for (MenuTreeStructureChangeListener listener : this.structureChangeListeners) {
            listener.treeStructureChanged(hint);
        }
    }

    private void updateRemotesWithLatestState(MenuCommand cmd) {
        this.executorService.execute(() -> {
            for (ServerConnection socket : this.getAllServerConnections()) {
                socket.sendCommand(cmd);
            }
        });
    }

    private void fireEventToListeners(Object sender, MenuItem item, Object data) {
        for (MenuManagerListener l : this.eventListeners) {
            l.menuItemHasChanged(sender, item);
        }
        MethodWithObject m = this.mapOfCallbacksById.get(item.getId());
        if (m != null) {
            try {
                if (m.isListResult() && data instanceof ListResponse) {
                    m.getMethod().invoke((Object)m.getListener(), sender, item, data);
                } else {
                    m.getMethod().invoke((Object)m.getListener(), sender, item);
                }
            }
            catch (Exception e) {
                this.logger.log(System.Logger.Level.ERROR, "Callback method threw an exception ", (Throwable)e);
            }
        }
    }

    private void handleIncomingChange(ServerConnection socket, MenuChangeCommand cmd) {
        Optional<MenuItem> maybeItem = this.tree.getMenuById(cmd.getMenuItemId());
        if (maybeItem.isEmpty()) {
            socket.sendCommand(new MenuAcknowledgementCommand(cmd.getCorrelationId(), AckStatus.ID_NOT_FOUND));
            return;
        }
        MenuItem item = maybeItem.get();
        if (cmd.getChangeType() == MenuChangeCommand.ChangeType.DELTA) {
            Optional<AnyMenuState> newVal = MenuItemHelper.applyIncrementalValueChange(item, Integer.parseInt(cmd.getValue()), this.tree);
            if (newVal.isPresent()) {
                this.applyScrollChoiceValueIfNeeded(item, newVal.get());
                this.fireEventToListeners(socket, item, newVal.get().getValue());
                this.sendChangeAndAck(socket, item, newVal.get().getValue(), cmd.getCorrelationId());
            } else {
                socket.sendCommand(new MenuAcknowledgementCommand(cmd.getCorrelationId(), AckStatus.VALUE_RANGE_WARNING));
            }
        } else if (cmd.getChangeType() == MenuChangeCommand.ChangeType.ABSOLUTE) {
            AnyMenuState newState = MenuItemHelper.stateForMenuItem(this.tree.getMenuState(item), item, cmd.getValue());
            this.tree.changeItem(item, newState);
            this.applyScrollChoiceValueIfNeeded(item, newState);
            this.fireEventToListeners(socket, item, newState.getValue());
            this.sendChangeAndAck(socket, item, cmd.getValue(), cmd.getCorrelationId());
        } else if (cmd.getChangeType() == MenuChangeCommand.ChangeType.LIST_STATE_CHANGE) {
            ListResponse.fromString(cmd.getValue()).ifPresent(resp -> this.fireEventToListeners(socket, item, resp));
        }
    }

    private void applyScrollChoiceValueIfNeeded(MenuItem item, AnyMenuState state) {
        if (item instanceof ScrollChoiceMenuItem && this.mapOfChoicePopulatorsById.containsKey(item.getId())) {
            CurrentScrollPositionMenuState scrState = (CurrentScrollPositionMenuState)state;
            MethodWithObject cp = this.mapOfChoicePopulatorsById.get(item.getId());
            try {
                ((CurrentScrollPosition)scrState.getValue()).setTextValue(cp.getMethod().invoke((Object)cp.getListener(), item, ((CurrentScrollPosition)scrState.getValue()).getPosition()));
            }
            catch (Exception e) {
                this.logger.log(System.Logger.Level.ERROR, "Scroll position value look up failed on " + item, (Throwable)e);
            }
        }
    }

    private void sendChangeAndAck(ServerConnection socket, MenuItem item, Object val, CorrelationId correlationId) {
        socket.sendCommand(new MenuAcknowledgementCommand(correlationId, AckStatus.SUCCESS));
        socket.sendCommand(new MenuChangeCommand(CorrelationId.EMPTY_CORRELATION, item.getId(), MenuChangeCommand.ChangeType.ABSOLUTE, val.toString()));
    }

    public String getServerName() {
        return this.serverName;
    }

    public UUID getServerUuid() {
        return this.serverUuid;
    }

    public void sendCommand(MenuCommand command) {
        this.updateRemotesWithLatestState(command);
    }

    public MenuAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    private static class MethodWithObject {
        private final Method method;
        private final MenuManagerListener listener;
        private final boolean listResult;

        private MethodWithObject(Method method, MenuManagerListener listener, boolean listResult) {
            this.method = method;
            this.listener = listener;
            this.listResult = listResult;
        }

        public Method getMethod() {
            return this.method;
        }

        public MenuManagerListener getListener() {
            return this.listener;
        }

        public boolean isListResult() {
            return this.listResult;
        }
    }
}

