/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.persist;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLDOMHelper {
    public static Document loadDocumentFromPath(Path filePath) throws IOException, ParserConfigurationException, SAXException {
        byte[] dataToLoad = Files.readAllBytes(filePath);
        ByteArrayInputStream in = new ByteArrayInputStream(dataToLoad);
        return XMLDOMHelper.loadDocumentStream(in);
    }

    public static Document loadDocumentFromData(String data) throws IOException, ParserConfigurationException, SAXException {
        ByteArrayInputStream in = new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
        return XMLDOMHelper.loadDocumentStream(in);
    }

    public static Document loadDocumentStream(InputStream stream) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = factory.newDocumentBuilder();
        return dBuilder.parse(stream);
    }

    public static List<Element> getChildElementsWithName(Element ele, String name) {
        if (ele == null) {
            return List.of();
        }
        NodeList childNodes = ele.getChildNodes();
        ArrayList<Element> list = new ArrayList<Element>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node ch = childNodes.item(i);
            if (!(ch instanceof Element) || !ch.getNodeName().equals(name)) continue;
            list.add((Element)ch);
        }
        return list;
    }

    public static String textOfElementByName(Element elem, String child) {
        List<Element> ch = XMLDOMHelper.getChildElementsWithName(elem, child);
        if (ch == null || ch.size() == 0) {
            return "";
        }
        return ch.get(0).getTextContent();
    }

    public static int integerOfElementByName(Element element, String child, int def) {
        String txt = XMLDOMHelper.textOfElementByName(element, child);
        if (txt.isEmpty()) {
            return def;
        }
        try {
            return Integer.parseInt(txt);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static Element elementWithName(Element elem, String child) {
        List<Element> ch = XMLDOMHelper.getChildElementsWithName(elem, child);
        if (ch == null || ch.size() == 0) {
            return null;
        }
        return ch.get(0);
    }

    public static String getAttrOrNull(Element ele, String attr) {
        Node node = ele.getAttributes().getNamedItem(attr);
        if (node == null) {
            return null;
        }
        return node.getTextContent();
    }

    public static String getAttributeOrDefault(Element elem, String val, Object def) {
        String att = elem.getAttribute(val);
        if (att == null || att.length() == 0) {
            return def.toString();
        }
        return att;
    }

    public static <T> List<T> transformElements(Element root, String eleName, String childName, Function<Element, T> transform) {
        ArrayList<T> ret = new ArrayList<T>();
        Element ele = root;
        if (eleName != null && (ele = XMLDOMHelper.elementWithName(root, eleName)) == null) {
            return Collections.emptyList();
        }
        List<Element> childList = XMLDOMHelper.getChildElementsWithName(ele, childName);
        for (Element ch : childList) {
            T created = transform.apply(ch);
            if (created == null) continue;
            ret.add(created);
        }
        return ret;
    }

    public static <T> List<T> transformElements(Element root, String childName, Function<Element, T> transform) {
        return XMLDOMHelper.transformElements(root, null, childName, transform);
    }

    public static void writeXml(Document doc, OutputStream output) throws TransformerException {
        XMLDOMHelper.writeXml(doc, output, false);
    }

    public static void writeXml(Document doc, OutputStream output, boolean prettyPrint) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        if (prettyPrint) {
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        }
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(output);
        transformer.transform(source, result);
    }

    public static Document newDocumentRoot(String name) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        doc.appendChild(doc.createElement(name));
        return doc;
    }

    public static Element appendElementWithNameValue(Element parent, String name, Object value) {
        Element childEle = parent.getOwnerDocument().createElement(name);
        if (value != null) {
            childEle.setTextContent(value.toString());
        }
        parent.appendChild(childEle);
        return childEle;
    }
}

