/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote;

import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.state.AnyMenuState;
import com.thecoderscorner.menu.domain.state.ListResponse;
import com.thecoderscorner.menu.domain.state.MenuTree;
import com.thecoderscorner.menu.domain.util.MenuItemHelper;
import com.thecoderscorner.menu.mgr.MenuManagerServer;
import com.thecoderscorner.menu.remote.AuthStatus;
import com.thecoderscorner.menu.remote.RemoteConnector;
import com.thecoderscorner.menu.remote.RemoteControllerListener;
import com.thecoderscorner.menu.remote.commands.AckStatus;
import com.thecoderscorner.menu.remote.commands.BootItemMenuCommand;
import com.thecoderscorner.menu.remote.commands.CommandFactory;
import com.thecoderscorner.menu.remote.commands.DialogMode;
import com.thecoderscorner.menu.remote.commands.MenuAcknowledgementCommand;
import com.thecoderscorner.menu.remote.commands.MenuBootstrapCommand;
import com.thecoderscorner.menu.remote.commands.MenuButtonType;
import com.thecoderscorner.menu.remote.commands.MenuChangeCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommandType;
import com.thecoderscorner.menu.remote.commands.MenuDialogCommand;
import com.thecoderscorner.menu.remote.protocol.CorrelationId;
import com.thecoderscorner.menu.remote.protocol.MessageField;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;

public class RemoteMenuController {
    private final System.Logger logger = System.getLogger(this.getClass().getSimpleName());
    private final RemoteConnector connector;
    private final MenuTree managedMenu;
    private final ConcurrentMap<CorrelationId, MenuItem> itemsInProgress = new ConcurrentHashMap<CorrelationId, MenuItem>();
    private final List<RemoteControllerListener> listeners = new CopyOnWriteArrayList<RemoteControllerListener>();
    private final Map<MessageField, BiConsumer<RemoteMenuController, MenuCommand>> customMessageHandlers = new ConcurrentHashMap<MessageField, BiConsumer<RemoteMenuController, MenuCommand>>();

    public RemoteMenuController(RemoteConnector connector, MenuTree managedMenu) {
        this.connector = connector;
        this.managedMenu = managedMenu;
    }

    public void addCustomMessageProcessor(MessageField msgType, BiConsumer<RemoteMenuController, MenuCommand> processor) {
        if (MenuManagerServer.MSGTYPES_CANNOT_OVERRIDE.contains(msgType)) {
            throw new IllegalArgumentException("You cannot override core type" + msgType);
        }
        this.customMessageHandlers.put(msgType, processor);
    }

    public void start() {
        this.connector.registerConnectorListener(this::onCommandReceived);
        this.connector.registerConnectionChangeListener(this::onConnectionChange);
        this.connector.start();
    }

    private void onConnectionChange(RemoteConnector remoteConnector, AuthStatus status) {
        this.logger.log(System.Logger.Level.INFO, "Connection state changed to connected = " + status);
        if (status == AuthStatus.AWAITING_CONNECTION || status == AuthStatus.CONNECTION_FAILED) {
            this.itemsInProgress.forEach((key, item) -> this.listeners.forEach(rcl -> rcl.ackReceived((CorrelationId)key, (MenuItem)item, AckStatus.UNKNOWN_ERROR)));
            this.itemsInProgress.clear();
        }
        this.listeners.forEach(l -> l.connectionState(this.connector.getRemoteParty(), status));
    }

    public void stop() {
        if (this.connector.getAuthenticationStatus() != AuthStatus.NOT_STARTED) {
            try {
                this.connector.stop();
            }
            catch (Exception ex) {
                this.logger.log(System.Logger.Level.WARNING, "Problem while stopping, probably two stop attempts", (Throwable)ex);
            }
        }
    }

    protected void sendCommand(MenuCommand command) {
        try {
            this.connector.sendMenuCommand(command);
        }
        catch (IOException e) {
            this.logger.log(System.Logger.Level.ERROR, "Error while writing out command", (Throwable)e);
            this.connector.close();
        }
    }

    public CorrelationId sendDialogAction(MenuButtonType buttonType) {
        CorrelationId correlationId = new CorrelationId();
        this.sendCommand(CommandFactory.newDialogCommand(DialogMode.ACTION, "", "", buttonType, buttonType, correlationId));
        return correlationId;
    }

    public CorrelationId sendDeltaUpdate(MenuItem item, int deltaChange) {
        CorrelationId correlationId = new CorrelationId();
        this.itemsInProgress.put(correlationId, item);
        this.sendCommand(CommandFactory.newDeltaChangeCommand(correlationId, item, deltaChange));
        return correlationId;
    }

    public CorrelationId sendAbsoluteUpdate(MenuItem item, Object newValue) {
        CorrelationId correlationId = new CorrelationId();
        this.itemsInProgress.put(correlationId, item);
        if (newValue instanceof ListResponse) {
            this.sendCommand(CommandFactory.newListResponseChangeCommand(correlationId, item, (ListResponse)newValue));
        } else {
            this.sendCommand(CommandFactory.newAbsoluteMenuChangeCommand(correlationId, item, newValue));
        }
        return correlationId;
    }

    public RemoteConnector getConnector() {
        return this.connector;
    }

    public boolean isTreeFullyPopulated() {
        return this.connector.getAuthenticationStatus() == AuthStatus.CONNECTION_READY;
    }

    public void addListener(RemoteControllerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(RemoteControllerListener listener) {
        this.listeners.remove(listener);
    }

    private void onCommandReceived(RemoteConnector remoteConnector, MenuCommand menuCommand) {
        if (menuCommand.getCommandType().equals(MenuCommandType.ACKNOWLEDGEMENT)) {
            this.onAcknowledgementCommand((MenuAcknowledgementCommand)menuCommand);
        } else if (menuCommand instanceof BootItemMenuCommand) {
            this.onMenuItemBoot((BootItemMenuCommand)menuCommand);
        } else if (menuCommand.getCommandType() == MenuCommandType.BOOTSTRAP) {
            this.onBootstrap((MenuBootstrapCommand)menuCommand);
        } else if (menuCommand.getCommandType() == MenuCommandType.CHANGE_INT_FIELD) {
            this.onChangeField((MenuChangeCommand)menuCommand);
        } else if (menuCommand.getCommandType() == MenuCommandType.DIALOG_UPDATE) {
            this.onDialogChange((MenuDialogCommand)menuCommand);
        } else if (this.customMessageHandlers.containsKey(menuCommand.getCommandType()) && this.getConnector().getAuthenticationStatus() == AuthStatus.CONNECTION_READY) {
            this.customMessageHandlers.get(menuCommand.getCommandType()).accept(this, menuCommand);
        }
    }

    private void onBootstrap(MenuBootstrapCommand menuCommand) {
        if (menuCommand.getBootType() == MenuBootstrapCommand.BootType.END) {
            this.listeners.forEach(RemoteControllerListener::treeFullyPopulated);
        }
    }

    private void onDialogChange(MenuDialogCommand menuCommand) {
        this.listeners.forEach(l -> l.dialogUpdate(menuCommand));
    }

    private void onAcknowledgementCommand(MenuAcknowledgementCommand menuCommand) {
        MenuItem item = (MenuItem)this.itemsInProgress.get(menuCommand.getCorrelationId());
        this.listeners.forEach(rcl -> rcl.ackReceived(menuCommand.getCorrelationId(), item, menuCommand.getAckStatus()));
    }

    private void onMenuItemBoot(BootItemMenuCommand<?, ?> menuCommand) {
        this.managedMenu.addOrUpdateItem(menuCommand.getSubMenuId(), (MenuItem)menuCommand.getMenuItem());
        this.managedMenu.changeItem((MenuItem)menuCommand.getMenuItem(), menuCommand.newMenuState((AnyMenuState)this.managedMenu.getMenuState((MenuItem)menuCommand.getMenuItem())));
        this.listeners.forEach(l -> l.menuItemChanged((MenuItem)menuCommand.getMenuItem(), false));
    }

    private void onChangeField(MenuChangeCommand menuCommand) {
        if (!this.isTreeFullyPopulated()) {
            return;
        }
        if (menuCommand.getChangeType() == MenuChangeCommand.ChangeType.ABSOLUTE_LIST) {
            this.managedMenu.getMenuById(menuCommand.getMenuItemId()).ifPresent(item -> {
                this.managedMenu.changeItem((MenuItem)item, MenuItemHelper.stateForMenuItem(item, menuCommand.getValues(), true, false));
                this.listeners.forEach(l -> l.menuItemChanged((MenuItem)item, true));
            });
        } else {
            this.managedMenu.getMenuById(menuCommand.getMenuItemId()).ifPresent(item -> {
                this.managedMenu.changeItem((MenuItem)item, MenuItemHelper.stateForMenuItem(item, menuCommand.getValue(), true, false));
                this.listeners.forEach(l -> l.menuItemChanged((MenuItem)item, true));
            });
        }
    }

    public MenuTree getManagedMenu() {
        return this.managedMenu;
    }
}

