/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.persist;

import java.util.Objects;

public class VersionInfo {
    public static final VersionInfo ERROR_VERSION = new VersionInfo("0.0.0");
    private final int major;
    private final int minor;
    private final int patch;

    public VersionInfo(String ver) {
        String[] verSplit = ver.split("[-.]");
        if (verSplit.length < 2) {
            this.patch = 0;
            this.minor = 0;
            this.major = 0;
        } else {
            this.major = Integer.parseInt(verSplit[0]);
            this.minor = Integer.parseInt(verSplit[1]);
            this.patch = verSplit.length == 3 ? Integer.parseInt(verSplit[2]) : 0;
        }
    }

    public static VersionInfo fromString(String sel) {
        try {
            return new VersionInfo(sel);
        }
        catch (Exception e) {
            return ERROR_VERSION;
        }
    }

    public boolean isSameOrNewerThan(VersionInfo other) {
        if (this.major > other.major) {
            return true;
        }
        if (this.major < other.major) {
            return false;
        }
        if (this.minor > other.minor) {
            return true;
        }
        if (this.minor < other.minor) {
            return false;
        }
        return this.patch >= other.patch;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionInfo that = (VersionInfo)o;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch);
    }

    public int asInteger() {
        return this.major * 1000000 + this.minor * 1000 + this.patch;
    }
}

