/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain;

import com.thecoderscorner.menu.domain.MenuItemBuilder;
import com.thecoderscorner.menu.domain.ScrollChoiceMenuItem;

public class ScrollChoiceMenuItemBuilder
extends MenuItemBuilder<ScrollChoiceMenuItemBuilder, ScrollChoiceMenuItem> {
    private int itemWidth;
    private int eepromOffset;
    private int numEntries;
    private ScrollChoiceMenuItem.ScrollChoiceMode choiceMode = ScrollChoiceMenuItem.ScrollChoiceMode.ARRAY_IN_EEPROM;
    private String variable;

    @Override
    ScrollChoiceMenuItemBuilder getThis() {
        return this;
    }

    public ScrollChoiceMenuItemBuilder withItemWidth(int itemWidth) {
        this.itemWidth = itemWidth;
        return this.getThis();
    }

    public ScrollChoiceMenuItemBuilder withEepromOffset(int eepromOffset) {
        this.eepromOffset = eepromOffset;
        return this.getThis();
    }

    public ScrollChoiceMenuItemBuilder withNumEntries(int numEntries) {
        this.numEntries = numEntries;
        return this.getThis();
    }

    public ScrollChoiceMenuItemBuilder withChoiceMode(ScrollChoiceMenuItem.ScrollChoiceMode choiceMode) {
        this.choiceMode = choiceMode;
        return this.getThis();
    }

    public ScrollChoiceMenuItemBuilder withVariable(String variable) {
        this.variable = variable;
        return this.getThis();
    }

    public ScrollChoiceMenuItemBuilder withExisting(ScrollChoiceMenuItem item) {
        this.baseFromExisting(item);
        this.itemWidth = item.getItemWidth();
        this.numEntries = item.getNumEntries();
        this.eepromOffset = item.getEepromOffset();
        this.choiceMode = item.getChoiceMode();
        this.variable = item.getVariable();
        return this.getThis();
    }

    @Override
    public ScrollChoiceMenuItem menuItem() {
        return new ScrollChoiceMenuItem(this.name, this.variableName, this.id, this.eepromAddr, this.functionName, this.itemWidth, this.eepromOffset, this.numEntries, this.choiceMode, this.variable, this.readOnly, this.localOnly, this.visible);
    }
}

