/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain.state;

import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.state.AnyMenuState;
import java.util.Objects;

public abstract class MenuState<T>
implements AnyMenuState {
    private final boolean changed;
    private final boolean active;
    private final MenuItem item;
    private final T value;
    private final AnyMenuState.StateStorageType storageType;

    public MenuState(AnyMenuState.StateStorageType storageType, MenuItem item, boolean changed, boolean active, T value) {
        this.storageType = storageType;
        this.changed = changed;
        this.active = active;
        this.value = value;
        this.item = item;
    }

    @Override
    public MenuItem getItem() {
        return this.item;
    }

    @Override
    public AnyMenuState.StateStorageType getStorageType() {
        return this.storageType;
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public T getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenuState menuState = (MenuState)o;
        return this.isChanged() == menuState.isChanged() && this.isActive() == menuState.isActive() && Objects.equals(this.getValue(), menuState.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.isChanged(), this.isActive(), this.getValue());
    }
}

