/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.persist;

import com.thecoderscorner.menu.persist.LocaleMappingHandler;
import com.thecoderscorner.menu.persist.SafeBundleLoader;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public class PropertiesLocaleEnabledHandler
implements LocaleMappingHandler {
    public static final Locale DEFAULT_LOCALE = new Locale("");
    private final SafeBundleLoader bundleLoader;
    private final Object localeLock = new Object();
    private Locale currentLocale;
    private Map<String, String> cachedEntries;
    private Map<String, String> parentCachedEntries;
    private Map<String, String> defaultCachedEntries;
    private boolean needsSave = false;
    private boolean defaultNeedsSave = false;

    public PropertiesLocaleEnabledHandler(SafeBundleLoader bundleLoader) {
        this.bundleLoader = bundleLoader;
        try {
            this.changeLocale(DEFAULT_LOCALE);
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException("Default Locale not available", ex);
        }
    }

    @Override
    public boolean isLocalSupportEnabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLocalSpecificEntry(String source) throws IllegalArgumentException {
        Object object = this.localeLock;
        synchronized (object) {
            String ret = this.cachedEntries.get(source);
            if (ret == null && this.parentCachedEntries != null) {
                ret = this.parentCachedEntries.get(source);
            }
            if (ret == null) {
                ret = this.defaultCachedEntries.get(source);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLocalSpecificEntry(String source, String newValue) throws IllegalArgumentException {
        Object object = this.localeLock;
        synchronized (object) {
            if (!this.defaultCachedEntries.containsKey(source)) {
                this.defaultCachedEntries.put(source, newValue);
                this.defaultNeedsSave = true;
            }
            this.cachedEntries.put(source, newValue);
            this.needsSave = true;
        }
    }

    @Override
    public List<Locale> getEnabledLocales() {
        try {
            return Files.walk(this.bundleLoader.getLocation(), 2, FileVisitOption.FOLLOW_LINKS).filter(p -> p.toString().endsWith(".properties")).map(p -> p.getFileName().toString().replace(this.bundleLoader.getBaseName(), "")).map(s -> s.replace(".properties", "")).map(s -> s.startsWith("_") ? s.substring(1) : s).map(this::makeLocale).collect(Collectors.toList());
        }
        catch (IOException e) {
            return List.of();
        }
    }

    private Locale makeLocale(String s) {
        String localeStr;
        String string = localeStr = s.startsWith("_") ? s.substring(1) : s;
        if (localeStr.isEmpty() || localeStr.equals("==")) {
            return new Locale(localeStr);
        }
        if (localeStr.length() == 2) {
            return new Locale(localeStr);
        }
        if (localeStr.matches("\\w\\w_\\w\\w")) {
            return new Locale(localeStr.substring(0, 2), localeStr.substring(3));
        }
        throw new UnsupportedOperationException("Unsupported type of locale only language or languageCountry" + localeStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeLocale(Locale locale) throws IOException {
        Object object = this.localeLock;
        synchronized (object) {
            if (this.defaultCachedEntries == null) {
                this.defaultCachedEntries = this.bundleLoader.loadResourceBundleAsMap(DEFAULT_LOCALE);
            }
            this.saveChanges();
            this.currentLocale = locale;
            this.parentCachedEntries = null;
            if (locale.getLanguage().equals("--")) {
                this.cachedEntries = new HashMap<String, String>();
            } else if (locale.getLanguage().isEmpty()) {
                this.cachedEntries = this.defaultCachedEntries;
            } else if (locale.getCountry() == null || locale.getCountry().isEmpty()) {
                this.cachedEntries = this.bundleLoader.loadResourceBundleAsMap(this.currentLocale);
            } else {
                this.cachedEntries = this.bundleLoader.loadResourceBundleAsMap(this.currentLocale);
                this.parentCachedEntries = this.bundleLoader.loadResourceBundleAsMap(new Locale(this.currentLocale.getLanguage()));
            }
            this.needsSave = false;
            this.defaultNeedsSave = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveChanges() {
        Object object = this.localeLock;
        synchronized (object) {
            if (this.defaultNeedsSave) {
                this.defaultNeedsSave = false;
                this.bundleLoader.saveChangesKeepingFormatting(DEFAULT_LOCALE, this.defaultCachedEntries);
            }
            if (this.needsSave) {
                this.needsSave = false;
                this.bundleLoader.saveChangesKeepingFormatting(this.currentLocale, this.cachedEntries);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getUnderlyingMap() {
        Object object = this.localeLock;
        synchronized (object) {
            HashMap<String, String> underlyingAll = new HashMap<String, String>(this.defaultCachedEntries);
            if (this.parentCachedEntries != null) {
                underlyingAll.putAll(this.parentCachedEntries);
            }
            underlyingAll.putAll(this.cachedEntries);
            return underlyingAll;
        }
    }

    public SafeBundleLoader getSafeLoader() {
        return this.bundleLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Locale getCurrentLocale() {
        Object object = this.localeLock;
        synchronized (object) {
            return this.currentLocale;
        }
    }

    public void putIntoDefaultIfNeeded(String localeName, String existing) {
        if (this.defaultCachedEntries.containsKey(localeName)) {
            return;
        }
        this.defaultCachedEntries.put(localeName, existing);
        this.defaultNeedsSave = true;
    }
}

