/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.commands;

import com.thecoderscorner.menu.remote.commands.DialogMode;
import com.thecoderscorner.menu.remote.commands.MenuButtonType;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommandType;
import com.thecoderscorner.menu.remote.protocol.CorrelationId;
import com.thecoderscorner.menu.remote.protocol.MessageField;
import java.util.Objects;

public class MenuDialogCommand
implements MenuCommand {
    private final DialogMode dialogMode;
    private final String header;
    private final String buffer;
    private final MenuButtonType b1;
    private final MenuButtonType b2;
    private final CorrelationId correlationId;

    public MenuDialogCommand(DialogMode dialogMode, String header, String buffer, MenuButtonType b1, MenuButtonType b2, CorrelationId correlationId) {
        this.dialogMode = dialogMode;
        this.header = header;
        this.buffer = buffer;
        this.b1 = b1;
        this.b2 = b2;
        this.correlationId = correlationId;
    }

    public DialogMode getDialogMode() {
        return this.dialogMode;
    }

    public String getHeader() {
        return this.header;
    }

    public String getBuffer() {
        return this.buffer;
    }

    public MenuButtonType getButton1() {
        return this.b1;
    }

    public MenuButtonType getButton2() {
        return this.b2;
    }

    @Override
    public MessageField getCommandType() {
        return MenuCommandType.DIALOG_UPDATE;
    }

    public CorrelationId getCorrelationId() {
        return this.correlationId;
    }

    public String toString() {
        return "MenuDialogCommand{dialogMode=" + this.dialogMode + ", header='" + this.header + "', buffer='" + this.buffer + "', b1=" + this.b1 + ", b2=" + this.b2 + ", correlation=" + this.correlationId + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenuDialogCommand that = (MenuDialogCommand)o;
        return this.getDialogMode() == that.getDialogMode() && Objects.equals(this.getHeader(), that.getHeader()) && Objects.equals(this.getBuffer(), that.getBuffer()) && Objects.equals(this.getCorrelationId(), that.getCorrelationId()) && this.getButton1() == that.getButton1() && this.getButton2() == that.getButton2();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getDialogMode(), this.getHeader(), this.getBuffer(), this.getButton1(), this.getButton2(), this.getCorrelationId()});
    }
}

