/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.protocol;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class MessageField {
    private static final Map<String, MessageField> ALL_FIELDS_MAP = new ConcurrentHashMap<String, MessageField>();
    private final char high;
    private final char low;

    public MessageField(char firstByte, char secondByte) {
        this.high = firstByte;
        this.low = secondByte;
        if (ALL_FIELDS_MAP.containsKey(this.toId())) {
            throw new IllegalArgumentException("Duplicate key " + this.high + this.low);
        }
        ALL_FIELDS_MAP.put(this.toId(), this);
    }

    public char getHigh() {
        return this.high;
    }

    public char getLow() {
        return this.low;
    }

    public String toId() {
        return "" + this.high + this.low;
    }

    public static MessageField fromId(String id) {
        if (ALL_FIELDS_MAP.containsKey(id)) {
            return ALL_FIELDS_MAP.get(id);
        }
        throw new IllegalStateException("An unknown message type was generated");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageField that = (MessageField)o;
        return this.high == that.high && this.low == that.low;
    }

    public int hashCode() {
        return Objects.hash(Character.valueOf(this.high), Character.valueOf(this.low));
    }

    public String toString() {
        return "Field[" + this.high + this.low + "]";
    }
}

