/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.socket;

import com.thecoderscorner.menu.domain.state.MenuTree;
import com.thecoderscorner.menu.remote.AuthStatus;
import com.thecoderscorner.menu.remote.ConnectMode;
import com.thecoderscorner.menu.remote.ConnectorFactory;
import com.thecoderscorner.menu.remote.LocalIdentifier;
import com.thecoderscorner.menu.remote.MenuCommandProtocol;
import com.thecoderscorner.menu.remote.NamedDaemonThreadFactory;
import com.thecoderscorner.menu.remote.RemoteMenuController;
import com.thecoderscorner.menu.remote.protocol.ConfigurableProtocolConverter;
import com.thecoderscorner.menu.remote.protocol.PairingHelper;
import com.thecoderscorner.menu.remote.socket.SocketBasedConnector;
import java.time.Clock;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;

public class SocketControllerBuilder
implements ConnectorFactory {
    private ScheduledExecutorService executorService;
    private MenuTree menuTree;
    private MenuCommandProtocol protocol;
    private Clock clock = Clock.systemDefaultZone();
    private String name = "NoName";
    private String address;
    private int port;
    private UUID uuid;

    public SocketControllerBuilder withClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public SocketControllerBuilder withExecutor(ScheduledExecutorService executor) {
        this.executorService = executor;
        return this;
    }

    public SocketControllerBuilder withMenuTree(MenuTree tree) {
        this.menuTree = tree;
        return this;
    }

    public SocketControllerBuilder withProtocol(MenuCommandProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public SocketControllerBuilder withLocalName(String name) {
        this.name = name;
        return this;
    }

    public SocketControllerBuilder withUUID(UUID uuid) {
        this.uuid = uuid;
        return this;
    }

    public SocketControllerBuilder withAddress(String address) {
        this.address = address;
        return this;
    }

    public SocketControllerBuilder withPort(int port) {
        this.port = port;
        return this;
    }

    @Override
    public RemoteMenuController build() {
        this.initialiseBasics();
        SocketBasedConnector connector = new SocketBasedConnector(new LocalIdentifier(this.uuid, this.name), this.executorService, this.clock, this.protocol, this.address, this.port, ConnectMode.FULLY_AUTHENTICATED);
        return new RemoteMenuController(connector, this.menuTree);
    }

    private void initialiseBasics() {
        if (this.uuid == null || this.name == null) {
            throw new IllegalArgumentException("Name / UUID cannot be null (Call UUID.randomUUID() to get one)");
        }
        if (this.protocol == null) {
            this.protocol = new ConfigurableProtocolConverter(true);
        }
        if (this.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(2, new NamedDaemonThreadFactory("remote-socket"));
        }
    }

    @Override
    public boolean attemptPairing(Optional<Consumer<AuthStatus>> maybePairingListener) {
        this.initialiseBasics();
        SocketBasedConnector connector = new SocketBasedConnector(new LocalIdentifier(this.uuid, this.name), this.executorService, this.clock, this.protocol, this.address, this.port, ConnectMode.PAIRING_CONNECTION);
        PairingHelper helper = new PairingHelper(connector, this.executorService, maybePairingListener);
        return helper.attemptPairing();
    }
}

