/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.auth;

import com.thecoderscorner.menu.auth.MenuAuthenticator;
import com.thecoderscorner.menu.mgr.DialogManager;
import com.thecoderscorner.menu.mgr.DialogShowMode;
import com.thecoderscorner.menu.remote.commands.MenuButtonType;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class PropertiesAuthenticator
implements MenuAuthenticator {
    private final System.Logger logger = System.getLogger(this.getClass().getSimpleName());
    private final Properties properties = new Properties();
    private final String location;
    private DialogManager dialogManager;

    public PropertiesAuthenticator(String location) {
        this(location, null);
    }

    public PropertiesAuthenticator(String location, DialogManager dialogManager) {
        this.location = location;
        this.dialogManager = dialogManager;
        try {
            this.properties.load(Files.newBufferedReader(Path.of(location, new String[0])));
        }
        catch (NoSuchFileException e) {
            this.logger.log(System.Logger.Level.WARNING, "The properties file doesn't exist, creating it.");
            this.savePropertiesFile();
        }
        catch (IOException e) {
            this.logger.log(System.Logger.Level.ERROR, "Unable to read authentication properties", (Throwable)e);
        }
    }

    public void setDialogManager(DialogManager dialogManager) {
        this.dialogManager = dialogManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean authenticate(String user, UUID uuid) {
        String val;
        Properties properties = this.properties;
        synchronized (properties) {
            val = this.properties.getProperty(user);
        }
        if (val == null) {
            return false;
        }
        return UUID.fromString(val).equals(uuid);
    }

    @Override
    public CompletableFuture<Boolean> addAuthentication(String user, UUID uuid, boolean needsApproval) {
        if (this.dialogManager == null) {
            return CompletableFuture.completedFuture(false);
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.logger.log(System.Logger.Level.INFO, "Request for authentication with " + user);
                AtomicBoolean shouldProceed = new AtomicBoolean(!needsApproval);
                if (needsApproval) {
                    CountDownLatch dialogLatch = new CountDownLatch(1);
                    this.dialogManager.withTitle("Pair with " + user, true).withMessage("Be sure you know where this connection originated", true).withDelegate(DialogShowMode.LOCAL_DELEGATE_LOCKED, menuButtonType -> {
                        shouldProceed.set(menuButtonType == MenuButtonType.ACCEPT);
                        dialogLatch.countDown();
                        return true;
                    }).showDialogWithButtons(MenuButtonType.ACCEPT, MenuButtonType.CANCEL);
                    if (!dialogLatch.await(30L, TimeUnit.SECONDS)) {
                        this.logger.log(System.Logger.Level.INFO, "Dialog Latch timed out without user operation");
                    }
                }
                if (shouldProceed.get()) {
                    Properties properties = this.properties;
                    synchronized (properties) {
                        this.properties.setProperty(user, uuid.toString());
                        this.savePropertiesFile();
                    }
                    this.logger.log(System.Logger.Level.INFO, "Wrote auth properties to ", this.location);
                    return true;
                }
                this.logger.log(System.Logger.Level.INFO, "Pairing dialog was not accepted");
                return false;
            }
            catch (Exception e) {
                this.logger.log(System.Logger.Level.ERROR, "Failed to write auth properties to ", this.location);
                return false;
            }
        });
    }

    private void savePropertiesFile() {
        Path pathLocation = Path.of(this.location, new String[0]);
        try {
            this.properties.store(Files.newBufferedWriter(pathLocation, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), "TcMenu Auth properties");
        }
        catch (IOException ex) {
            this.logger.log(System.Logger.Level.ERROR, "Could not save properties file to " + pathLocation);
        }
    }

    @Override
    public void removeAuthentication(String user) {
        this.properties.remove(user);
        this.savePropertiesFile();
    }

    @Override
    public boolean doesPasscodeMatch(String passcode) {
        return this.properties.getProperty("securityPasscode", "1234").equals(passcode);
    }

    @Override
    public MenuAuthenticator.ManagementCapabilities managementCapabilities() {
        return MenuAuthenticator.ManagementCapabilities.CAN_REMOVE_ADD;
    }

    @Override
    public List<String> getAllNames() {
        return List.copyOf(this.properties.stringPropertyNames());
    }
}

