/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain;

import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.util.MenuItemVisitor;
import java.util.Objects;

public class RuntimeListMenuItem
extends MenuItem {
    private final int initialRows;
    private final ListCreationMode listCreationMode;

    public RuntimeListMenuItem() {
        super("", null, 0, 0, "", false, false, true, false);
        this.initialRows = 0;
        this.listCreationMode = ListCreationMode.CUSTOM_RTCALL;
    }

    public RuntimeListMenuItem(String name, String varName, int id, int eepromAddress, String functionName, boolean readOnly, boolean localOnly, boolean visible, int initialRows, boolean staticInRam, ListCreationMode creationMode) {
        super(name, varName, id, eepromAddress, functionName, readOnly, localOnly, visible, staticInRam);
        this.initialRows = initialRows;
        this.listCreationMode = creationMode;
    }

    public ListCreationMode getListCreationMode() {
        return this.listCreationMode != null ? this.listCreationMode : ListCreationMode.CUSTOM_RTCALL;
    }

    public int getInitialRows() {
        return this.initialRows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuntimeListMenuItem that = (RuntimeListMenuItem)o;
        return this.getInitialRows() == that.getInitialRows() && this.getId() == that.getId() && this.getEepromAddress() == that.getEepromAddress() && this.isReadOnly() == that.isReadOnly() && this.isLocalOnly() == that.isLocalOnly() && this.isVisible() == that.isVisible() && Objects.equals(this.getName(), that.getName()) && Objects.equals((Object)this.getListCreationMode(), (Object)that.getListCreationMode()) && Objects.equals(this.getFunctionName(), that.getFunctionName()) && Objects.equals(this.getVariableName(), that.getVariableName());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getInitialRows(), this.getName(), this.getId(), this.getEepromAddress(), this.getFunctionName(), this.isReadOnly(), this.getVariableName(), this.getListCreationMode()});
    }

    @Override
    public void accept(MenuItemVisitor visitor) {
        visitor.visit(this);
    }

    public static enum ListCreationMode {
        CUSTOM_RTCALL,
        RAM_ARRAY,
        FLASH_ARRAY;

    }
}

