/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.domain.util;

import com.thecoderscorner.menu.domain.AnalogMenuItem;
import com.thecoderscorner.menu.domain.BooleanMenuItem;
import com.thecoderscorner.menu.domain.EditItemType;
import com.thecoderscorner.menu.domain.EditableLargeNumberMenuItem;
import com.thecoderscorner.menu.domain.EditableTextMenuItem;
import com.thecoderscorner.menu.domain.EnumMenuItem;
import com.thecoderscorner.menu.domain.FloatMenuItem;
import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.Rgb32MenuItem;
import com.thecoderscorner.menu.domain.ScrollChoiceMenuItem;
import com.thecoderscorner.menu.domain.state.CurrentScrollPosition;
import com.thecoderscorner.menu.domain.state.PortableColor;
import com.thecoderscorner.menu.domain.util.AbstractMenuItemVisitor;
import com.thecoderscorner.menu.domain.util.MenuItemHelper;
import com.thecoderscorner.menu.persist.LocaleMappingHandler;
import java.math.BigDecimal;

public class MenuItemFormatter {
    private static final MenuItemFormatter INSTANCE = new MenuItemFormatter(LocaleMappingHandler.NOOP_IMPLEMENTATION);
    private LocaleMappingHandler localHandler;

    public MenuItemFormatter(LocaleMappingHandler handler) {
        this.localHandler = handler != null ? handler : LocaleMappingHandler.NOOP_IMPLEMENTATION;
    }

    public static MenuItemFormatter defaultInstance() {
        return INSTANCE;
    }

    public static void setDefaultLocalHandler(LocaleMappingHandler localHandler) {
        MenuItemFormatter.INSTANCE.localHandler = localHandler;
    }

    public String bundleIfPossible(String s) {
        return this.localHandler.getFromLocaleWithDefault(s, s);
    }

    public String formatToWire(MenuItem item, final String text) {
        return MenuItemHelper.visitWithResult(item, new AbstractMenuItemVisitor<String>(){

            @Override
            public void anyItem(MenuItem item) {
                throw new IllegalArgumentException(item + "not editable");
            }

            @Override
            public void visit(AnalogMenuItem item) {
                this.setResult(MenuItemFormatter.this.formatAnalogWire(item, text));
            }

            @Override
            public void visit(EnumMenuItem item) {
                this.setResult(MenuItemFormatter.this.formatEnumWire(item, text));
            }

            @Override
            public void visit(BooleanMenuItem item) {
                this.setResult(MenuItemFormatter.this.formatBoolWire(item, text));
            }

            @Override
            public void visit(EditableLargeNumberMenuItem item) {
                this.setResult(MenuItemFormatter.formatLargeNumWire(item, text));
            }

            @Override
            public void visit(Rgb32MenuItem item) {
                this.setResult(MenuItemFormatter.this.formatRgbItemWire(item, text));
            }

            @Override
            public void visit(ScrollChoiceMenuItem item) {
                this.setResult(MenuItemFormatter.this.formatScrollItemWire(item, text));
            }

            @Override
            public void visit(EditableTextMenuItem item) {
                this.setResult(MenuItemFormatter.this.formatEditableTextWire(item, text));
            }
        }).orElseThrow();
    }

    private String formatEditableTextWire(EditableTextMenuItem et, String text) {
        if (et.getItemType() == EditItemType.PLAIN_TEXT && text.length() < et.getTextLength()) {
            return text;
        }
        if (et.getItemType() == EditItemType.IP_ADDRESS) {
            if (!text.matches("\\d+\\.\\d+\\.\\d+\\.\\d+")) {
                return "0.0.0.0";
            }
            return text;
        }
        if (et.getItemType() == EditItemType.TIME_24H || et.getItemType() == EditItemType.TIME_24_HUNDREDS || et.getItemType() == EditItemType.TIME_12H) {
            if (!text.matches("\\d+:\\d+:\\d+(.\\d*)*")) {
                return "12:00:00";
            }
            return text;
        }
        if (et.getItemType() == EditItemType.GREGORIAN_DATE) {
            if (!text.matches("\\d+/\\d+/\\d+")) {
                return "01/01/2000";
            }
            return text;
        }
        return "";
    }

    private static String formatLargeNumWire(EditableLargeNumberMenuItem ln, String text) {
        BigDecimal val;
        try {
            val = new BigDecimal(text);
        }
        catch (Exception ex) {
            return "0";
        }
        return val.toString();
    }

    private String formatRgbItemWire(Rgb32MenuItem rgb, String text) {
        return new PortableColor(text).toString();
    }

    private String formatScrollItemWire(ScrollChoiceMenuItem scroll, String text) {
        int val = 0;
        try {
            val = Integer.parseInt(text);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new CurrentScrollPosition(val, text).toString();
    }

    private String formatBoolWire(BooleanMenuItem bi, String text) {
        if ((text = text.toUpperCase()).equals("ON") || text.equals("YES") || text.equals("TRUE")) {
            return "1";
        }
        if (text.equals("OFF") || text.equals("NO") || text.equals("FALSE")) {
            return "0";
        }
        return "0";
    }

    private String formatEnumWire(EnumMenuItem en, String text) {
        return text;
    }

    private int GetActualDecimalDivisor(int divisor) {
        if (divisor < 2) {
            return 1;
        }
        return divisor > 1000 ? 10000 : (divisor > 100 ? 1000 : (divisor > 10 ? 100 : 10));
    }

    private String formatAnalogWire(AnalogMenuItem an, String text) {
        return text;
    }

    public String formatForDisplay(MenuItem item, Object data) {
        if (item == null || data == null) {
            return "";
        }
        if (item instanceof FloatMenuItem) {
            return this.formatFloatForDisplay((FloatMenuItem)item, ((Float)data).floatValue());
        }
        if (item instanceof AnalogMenuItem) {
            return this.formatAnalogForDisplay((AnalogMenuItem)item, (Integer)data);
        }
        if (item instanceof BooleanMenuItem) {
            return this.formatBoolForDisplay((BooleanMenuItem)item, (Boolean)data);
        }
        if (item instanceof EnumMenuItem) {
            return this.formatEnumForDisplay((EnumMenuItem)item, (Integer)data);
        }
        if (item instanceof EditableLargeNumberMenuItem) {
            return this.formatLargeNumForDisplay((EditableLargeNumberMenuItem)item, (BigDecimal)data);
        }
        if (item instanceof EditableTextMenuItem) {
            return this.formatTextForDisplay((EditableTextMenuItem)item, (String)data);
        }
        if (item instanceof Rgb32MenuItem) {
            return this.formatRgbItemForDisplay((Rgb32MenuItem)item, (PortableColor)data);
        }
        if (item instanceof ScrollChoiceMenuItem) {
            return this.formatScrollItemForDisplay((ScrollChoiceMenuItem)item, (CurrentScrollPosition)data);
        }
        return "";
    }

    private String formatScrollItemForDisplay(ScrollChoiceMenuItem sc, CurrentScrollPosition data) {
        return data.getValue();
    }

    private String formatRgbItemForDisplay(Rgb32MenuItem rgb, PortableColor col) {
        return col.toString();
    }

    private String formatTextForDisplay(EditableTextMenuItem tm, String data) {
        return data;
    }

    private String formatLargeNumForDisplay(EditableLargeNumberMenuItem ln, BigDecimal data) {
        return data.toString();
    }

    private String formatEnumForDisplay(EnumMenuItem en, int data) {
        if (en.getEnumEntries().size() > data) {
            return this.localHandler.getFromLocaleOrUseSource(en.getEnumEntries().get(data));
        }
        return "";
    }

    private String formatBoolForDisplay(BooleanMenuItem bl, boolean val) {
        switch (bl.getNaming()) {
            case ON_OFF: {
                return val ? this.localHandler.getFromLocaleWithDefault("%bool.on", "On") : this.localHandler.getFromLocaleWithDefault("%bool.off", "Off");
            }
            case YES_NO: {
                return val ? this.localHandler.getFromLocaleWithDefault("%bool.yes", "Yes") : this.localHandler.getFromLocaleWithDefault("%bool.no", "No");
            }
        }
        return val ? this.localHandler.getFromLocaleWithDefault("%bool.true", "True") : this.localHandler.getFromLocaleWithDefault("%bool.false", "False");
    }

    private String formatAnalogForDisplay(AnalogMenuItem an, int val) {
        int calcVal = val + an.getOffset();
        int divisor = an.getDivisor();
        if (divisor < 2) {
            return Integer.toString(calcVal) + this.bundleIfPossible(an.getUnitName());
        }
        int whole = calcVal / divisor;
        int fractMax = this.GetActualDecimalDivisor(an.getDivisor());
        int fraction = Math.abs(calcVal % divisor) * (fractMax / divisor);
        return String.format("%d.%0" + this.calculateRequiredDigits(divisor) + "d%s", whole, fraction, this.localHandler.getFromLocaleOrUseSource(an.getUnitName()));
    }

    private int calculateRequiredDigits(int divisor) {
        return divisor <= 10 ? 1 : (divisor <= 100 ? 2 : (divisor <= 1000 ? 3 : 4));
    }

    private String formatFloatForDisplay(FloatMenuItem fl, float val) {
        return String.format("%." + fl.getNumDecimalPlaces() + "f", Float.valueOf(val));
    }

    public String getItemName(MenuItem item) {
        return this.localHandler.getFromLocaleWithDefault(item.getName(), item.getName());
    }
}

