/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.persist;

import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.state.AnyMenuState;
import com.thecoderscorner.menu.domain.state.MenuTree;
import com.thecoderscorner.menu.domain.util.MenuItemHelper;
import com.thecoderscorner.menu.persist.MenuStateSerialiser;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;

public class PropertiesMenuStateSerialiser
implements MenuStateSerialiser {
    System.Logger logger = System.getLogger(PropertiesMenuStateSerialiser.class.getSimpleName());
    private final MenuTree tree;
    private final Path propertiesFile;

    public PropertiesMenuStateSerialiser(MenuTree tree, Path propertiesFile) {
        this.tree = tree;
        this.propertiesFile = propertiesFile;
    }

    @Override
    public void loadMenuStatesAndApply() {
        List<AnyMenuState> allStates = this.loadMenuStates();
        for (AnyMenuState state : allStates) {
            this.tree.changeItem(state.getItem(), state);
        }
    }

    @Override
    public List<AnyMenuState> loadMenuStates() {
        ArrayList<AnyMenuState> arrayList;
        this.logger.log(System.Logger.Level.INFO, "Load menu state");
        Properties properties = new Properties();
        ArrayList<AnyMenuState> states = new ArrayList<AnyMenuState>();
        FileInputStream propFile = new FileInputStream(this.propertiesFile.toFile());
        try {
            properties.load(propFile);
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                Optional<Integer> possibleId = this.tryParseIntKey(key);
                if (possibleId.isPresent() && this.tree.getMenuById(possibleId.get()).isPresent()) {
                    MenuItem item = this.tree.getMenuById(possibleId.get()).get();
                    states.add(MenuItemHelper.stateForMenuItem(item, value.toString().trim(), false, false));
                }
            }));
            arrayList = states;
        }
        catch (Throwable throwable) {
            try {
                try {
                    propFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                this.logger.log(System.Logger.Level.ERROR, "Error loading menu state", (Throwable)ex);
                return Collections.emptyList();
            }
        }
        propFile.close();
        return arrayList;
    }

    private Optional<Integer> tryParseIntKey(Object key) {
        try {
            return Optional.of(Integer.parseInt(key.toString()));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    @Override
    public void saveMenuStates() {
        this.logger.log(System.Logger.Level.INFO, "Save menu state");
        Properties properties = new Properties();
        try (FileWriter propFile = new FileWriter(this.propertiesFile.toFile());){
            this.tree.getAllMenuItems().stream().filter(item -> item.getEepromAddress() != -1 && MenuItemHelper.eepromSizeForItem(item) != 0).filter(item -> this.tree.getMenuState((MenuItem)item) != null).forEach(item -> {
                Object state = this.tree.getMenuState((MenuItem)item);
                if (state.getValue() != null) {
                    properties.setProperty(Integer.toString(item.getId()), state.getValue().toString());
                }
            });
            properties.store(propFile, "TcMenu Menu States saved on " + LocalDateTime.now());
        }
        catch (Exception ex) {
            this.logger.log(System.Logger.Level.ERROR, "Error saving property state", (Throwable)ex);
        }
    }
}

