/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.persist;

import com.thecoderscorner.menu.persist.LocaleMappingHandler;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class ResourceBundleMappingHandler
implements LocaleMappingHandler {
    private final ResourceBundle bundle;

    public ResourceBundleMappingHandler(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    @Override
    public boolean isLocalSupportEnabled() {
        return true;
    }

    @Override
    public String getLocalSpecificEntry(String source) throws IllegalArgumentException {
        return this.bundle.getString(source);
    }

    @Override
    public void setLocalSpecificEntry(String source, String newValue) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Resource bundles are read only");
    }

    @Override
    public List<Locale> getEnabledLocales() {
        return Collections.singletonList(this.bundle.getLocale());
    }

    @Override
    public void changeLocale(Locale locale) throws IOException {
        throw new UnsupportedOperationException("Resource bundles are read only");
    }

    @Override
    public void saveChanges() {
        throw new UnsupportedOperationException("Resource bundles are read only");
    }

    @Override
    public Map<String, String> getUnderlyingMap() {
        Set<String> keys = this.bundle.keySet();
        HashMap<String, String> map = new HashMap<String, String>(keys.size() + 10);
        for (String key : keys) {
            map.put(key, this.bundle.getString(key));
        }
        return map;
    }

    @Override
    public Locale getCurrentLocale() {
        return this.bundle.getLocale();
    }
}

