/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.protocol;

import com.thecoderscorner.menu.mgr.ServerConnection;
import com.thecoderscorner.menu.remote.MenuCommandProtocol;
import com.thecoderscorner.menu.remote.SharedStreamConnection;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.protocol.TcProtocolException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;

public class ProtocolHelper {
    private static final int MAX_WS_MSG_SIZE = 8192;
    private final MenuCommandProtocol protocol;
    private final ByteBuffer outBuffer = ByteBuffer.allocate(8192);
    private final ByteBuffer currentData = ByteBuffer.allocate(8192);
    private final AtomicReference<BiConsumer<ServerConnection, MenuCommand>> messageHandler = new AtomicReference();

    public ProtocolHelper(MenuCommandProtocol protocol) {
        this.protocol = protocol;
    }

    public void setMessageHandler(BiConsumer<ServerConnection, MenuCommand> handler) {
        this.messageHandler.set(handler);
    }

    public String protoBufferToText(MenuCommand command) throws TcProtocolException {
        this.outBuffer.clear();
        this.protocol.toChannel(this.outBuffer, command);
        this.outBuffer.flip();
        StringBuilder sb = new StringBuilder(100);
        while (this.outBuffer.hasRemaining()) {
            sb.append((char)this.outBuffer.get());
        }
        return sb.toString();
    }

    public Optional<MenuCommand> dataReceived(ServerConnection con, String data) throws Exception {
        if (this.currentData.position() >= 8192) {
            return Optional.empty();
        }
        this.currentData.put(data.getBytes(StandardCharsets.UTF_8));
        this.currentData.flip();
        BiConsumer<ServerConnection, MenuCommand> msgHandler = this.messageHandler.get();
        if (msgHandler == null) {
            return Optional.empty();
        }
        while (this.currentData.remaining() > 0 && this.currentData.get() != 1) {
        }
        if (!SharedStreamConnection.doesBufferHaveEOM(this.currentData)) {
            return Optional.empty();
        }
        MenuCommand cmd = this.protocol.fromChannel(this.currentData);
        this.currentData.compact();
        this.messageHandler.get().accept(con, cmd);
        return Optional.ofNullable(cmd);
    }
}

