/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote.protocol;

import com.thecoderscorner.menu.domain.ActionMenuItem;
import com.thecoderscorner.menu.domain.ActionMenuItemBuilder;
import com.thecoderscorner.menu.domain.AnalogMenuItem;
import com.thecoderscorner.menu.domain.AnalogMenuItemBuilder;
import com.thecoderscorner.menu.domain.BooleanMenuItem;
import com.thecoderscorner.menu.domain.BooleanMenuItemBuilder;
import com.thecoderscorner.menu.domain.EditItemType;
import com.thecoderscorner.menu.domain.EditableLargeNumberMenuItem;
import com.thecoderscorner.menu.domain.EditableLargeNumberMenuItemBuilder;
import com.thecoderscorner.menu.domain.EditableTextMenuItem;
import com.thecoderscorner.menu.domain.EditableTextMenuItemBuilder;
import com.thecoderscorner.menu.domain.EnumMenuItem;
import com.thecoderscorner.menu.domain.EnumMenuItemBuilder;
import com.thecoderscorner.menu.domain.FloatMenuItem;
import com.thecoderscorner.menu.domain.FloatMenuItemBuilder;
import com.thecoderscorner.menu.domain.MenuItem;
import com.thecoderscorner.menu.domain.Rgb32MenuItem;
import com.thecoderscorner.menu.domain.Rgb32MenuItemBuilder;
import com.thecoderscorner.menu.domain.RuntimeListMenuItem;
import com.thecoderscorner.menu.domain.RuntimeListMenuItemBuilder;
import com.thecoderscorner.menu.domain.ScrollChoiceMenuItem;
import com.thecoderscorner.menu.domain.ScrollChoiceMenuItemBuilder;
import com.thecoderscorner.menu.domain.SubMenuItem;
import com.thecoderscorner.menu.domain.SubMenuItemBuilder;
import com.thecoderscorner.menu.domain.state.CurrentScrollPosition;
import com.thecoderscorner.menu.domain.state.ListResponse;
import com.thecoderscorner.menu.domain.state.PortableColor;
import com.thecoderscorner.menu.remote.commands.AckStatus;
import com.thecoderscorner.menu.remote.commands.BootItemMenuCommand;
import com.thecoderscorner.menu.remote.commands.CommandFactory;
import com.thecoderscorner.menu.remote.commands.DialogMode;
import com.thecoderscorner.menu.remote.commands.MenuAcknowledgementCommand;
import com.thecoderscorner.menu.remote.commands.MenuActionBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuAnalogBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuBooleanBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuBootstrapCommand;
import com.thecoderscorner.menu.remote.commands.MenuButtonType;
import com.thecoderscorner.menu.remote.commands.MenuChangeCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.commands.MenuCommandType;
import com.thecoderscorner.menu.remote.commands.MenuDialogCommand;
import com.thecoderscorner.menu.remote.commands.MenuEnumBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuFloatBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuHeartbeatCommand;
import com.thecoderscorner.menu.remote.commands.MenuJoinCommand;
import com.thecoderscorner.menu.remote.commands.MenuLargeNumBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuPairingCommand;
import com.thecoderscorner.menu.remote.commands.MenuRgb32BootCommand;
import com.thecoderscorner.menu.remote.commands.MenuRuntimeListBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuScrollChoiceBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuSubBootCommand;
import com.thecoderscorner.menu.remote.commands.MenuTextBootCommand;
import com.thecoderscorner.menu.remote.protocol.ConfigurableProtocolConverter;
import com.thecoderscorner.menu.remote.protocol.CorrelationId;
import com.thecoderscorner.menu.remote.protocol.ProtocolUtil;
import com.thecoderscorner.menu.remote.protocol.TagValTextParser;
import com.thecoderscorner.menu.remote.protocol.TcProtocolException;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public class TagValMenuCommandProcessors {
    public void addHandlersToProtocol(ConfigurableProtocolConverter proto) {
        proto.addTagValInProcessor(MenuCommandType.JOIN, this::processJoin);
        proto.addTagValInProcessor(MenuCommandType.HEARTBEAT, this::processHeartbeat);
        proto.addTagValInProcessor(MenuCommandType.BOOTSTRAP, this::processBootstrap);
        proto.addTagValInProcessor(MenuCommandType.ANALOG_BOOT_ITEM, this::processAnalogBootItem);
        proto.addTagValInProcessor(MenuCommandType.SUBMENU_BOOT_ITEM, this::processSubMenuBootItem);
        proto.addTagValInProcessor(MenuCommandType.ENUM_BOOT_ITEM, this::processEnumBootItem);
        proto.addTagValInProcessor(MenuCommandType.BOOLEAN_BOOT_ITEM, this::processBoolBootItem);
        proto.addTagValInProcessor(MenuCommandType.LARGE_NUM_BOOT_ITEM, this::processLargeNumBootItem);
        proto.addTagValInProcessor(MenuCommandType.CHANGE_INT_FIELD, this::processItemChange);
        proto.addTagValInProcessor(MenuCommandType.TEXT_BOOT_ITEM, this::processTextItem);
        proto.addTagValInProcessor(MenuCommandType.FLOAT_BOOT_ITEM, this::processFloatItem);
        proto.addTagValInProcessor(MenuCommandType.ACTION_BOOT_ITEM, this::processActionItem);
        proto.addTagValInProcessor(MenuCommandType.RUNTIME_LIST_BOOT, this::processRuntimeListBoot);
        proto.addTagValInProcessor(MenuCommandType.BOOT_RGB_COLOR, this::processRuntimeRgbColor);
        proto.addTagValInProcessor(MenuCommandType.BOOT_SCROLL_CHOICE, this::processRuntimeScrollChoice);
        proto.addTagValInProcessor(MenuCommandType.ACKNOWLEDGEMENT, this::processAcknowledgement);
        proto.addTagValInProcessor(MenuCommandType.PAIRING_REQUEST, this::processPairingRequest);
        proto.addTagValInProcessor(MenuCommandType.DIALOG_UPDATE, this::processDialogUpdate);
        proto.addTagValOutProcessor(MenuCommandType.HEARTBEAT, this::writeHeartbeat, MenuHeartbeatCommand.class);
        proto.addTagValOutProcessor(MenuCommandType.JOIN, this::writeJoin, MenuJoinCommand.class);
        proto.addTagValOutProcessor(MenuCommandType.ACKNOWLEDGEMENT, this::writeAcknowledgement, MenuAcknowledgementCommand.class);
        proto.addTagValOutProcessor(MenuCommandType.BOOTSTRAP, this::writeBootstrap, MenuBootstrapCommand.class);
        proto.addTagValOutProcessor(MenuCommandType.ANALOG_BOOT_ITEM, this::writeAnalogItem, MenuAnalogBootCommand.class);
        proto.addTagValOutProcessor(MenuCommandType.SUBMENU_BOOT_ITEM, this::writeSubMenuItem, MenuSubBootCommand.class);
        proto.addTagValOutProcessor(MenuCommandType.ENUM_BOOT_ITEM, this::writeEnumMenuItem, MenuEnumBootCommand.class);
        proto.addTagValOutProcessor(MenuCommandType.ACTION_BOOT_ITEM, this::writeActionBootItem, MenuActionBootCommand.class);
        proto.addTagValOutProcessor(MenuCommandType.FLOAT_BOOT_ITEM, this::writeFloatBootItem, MenuFloatBootCommand.class);
        proto.addTagValOutProcessor(MenuCommandType.BOOLEAN_BOOT_ITEM, this::writeBoolMenuItem, MenuBooleanBootCommand.class);
        proto.addTagValOutProcessor(MenuCommandType.RUNTIME_LIST_BOOT, this::writeRuntimeListBootItem, MenuRuntimeListBootCommand.class);
        proto.addTagValOutProcessor(MenuCommandType.LARGE_NUM_BOOT_ITEM, this::writeLargeNumberBootItem, MenuLargeNumBootCommand.class);
        proto.addTagValOutProcessor(MenuCommandType.CHANGE_INT_FIELD, this::writeChangeInt, MenuChangeCommand.class);
        proto.addTagValOutProcessor(MenuCommandType.TEXT_BOOT_ITEM, this::writeTextMenuItem, MenuTextBootCommand.class);
        proto.addTagValOutProcessor(MenuCommandType.PAIRING_REQUEST, this::writePairingRequest, MenuPairingCommand.class);
        proto.addTagValOutProcessor(MenuCommandType.DIALOG_UPDATE, this::writeDialogUpdate, MenuDialogCommand.class);
        proto.addTagValOutProcessor(MenuCommandType.BOOT_RGB_COLOR, this::writeRgbBoot, MenuRgb32BootCommand.class);
        proto.addTagValOutProcessor(MenuCommandType.BOOT_SCROLL_CHOICE, this::writeScrollBoot, MenuScrollChoiceBootCommand.class);
    }

    private MenuCommand processDialogUpdate(TagValTextParser parser) throws TcProtocolException {
        String cor = parser.getValueWithDefault("IC", "");
        CorrelationId correlationId = cor.isEmpty() ? CorrelationId.EMPTY_CORRELATION : new CorrelationId(cor);
        return CommandFactory.newDialogCommand(this.asDialogMode(parser.getValue("MO")), parser.getValueWithDefault("HF", ""), parser.getValueWithDefault("BU", ""), this.asButton(parser.getValueAsIntWithDefault("B1", 0)), this.asButton(parser.getValueAsIntWithDefault("B2", 0)), correlationId);
    }

    private DialogMode asDialogMode(String mode) {
        if (mode.equals("S")) {
            return DialogMode.SHOW;
        }
        if (mode.equals("H")) {
            return DialogMode.HIDE;
        }
        return DialogMode.ACTION;
    }

    private MenuButtonType asButton(int req) {
        return Arrays.stream(MenuButtonType.values()).filter(b -> b.getTypeVal() == req).findFirst().orElse(MenuButtonType.NONE);
    }

    private MenuCommand processPairingRequest(TagValTextParser parser) throws TcProtocolException {
        return CommandFactory.newPairingCommand(parser.getValue("NM"), UUID.fromString(parser.getValue("UU")));
    }

    private MenuCommand processAcknowledgement(TagValTextParser parser) throws TcProtocolException {
        CorrelationId id = new CorrelationId(parser.getValueWithDefault("IC", "0"));
        return CommandFactory.newAcknowledgementCommand(id, this.fromCode(parser.getValueAsInt("ST")));
    }

    private AckStatus fromCode(int codeIn) {
        return Arrays.stream(AckStatus.values()).filter(s -> s.getStatusCode() == codeIn).findFirst().orElse(AckStatus.UNKNOWN_ERROR);
    }

    private MenuCommand processItemChange(TagValTextParser parser) throws TcProtocolException {
        CorrelationId correlation;
        MenuChangeCommand.ChangeType type = MenuChangeCommand.changeTypeFromInt(parser.getValueAsInt("TC"));
        String corStr = parser.getValueWithDefault("IC", "");
        CorrelationId correlationId = correlation = corStr.isEmpty() ? CorrelationId.EMPTY_CORRELATION : new CorrelationId(corStr);
        if (type == MenuChangeCommand.ChangeType.DELTA) {
            return CommandFactory.newDeltaChangeCommand(correlation, parser.getValueAsInt("ID"), parser.getValueAsInt("VC"));
        }
        if (type == MenuChangeCommand.ChangeType.ABSOLUTE) {
            return CommandFactory.newAbsoluteMenuChangeCommand(correlation, parser.getValueAsInt("ID"), (Object)parser.getValue("VC"));
        }
        if (type == MenuChangeCommand.ChangeType.LIST_STATE_CHANGE) {
            return CommandFactory.newListResponseChangeCommand(correlation, parser.getValueAsInt("ID"), ListResponse.fromString(parser.getValue("VC")).orElse(ListResponse.EMPTY));
        }
        List<String> choices = this.choicesFromMsg(parser);
        return CommandFactory.newAbsoluteListChangeCommand(correlation, parser.getValueAsInt("ID"), choices);
    }

    private MenuCommand processRuntimeListBoot(TagValTextParser parser) throws TcProtocolException {
        RuntimeListMenuItem item = ((RuntimeListMenuItemBuilder)((RuntimeListMenuItemBuilder)((RuntimeListMenuItemBuilder)((RuntimeListMenuItemBuilder)((RuntimeListMenuItemBuilder)RuntimeListMenuItemBuilder.aRuntimeListMenuItemBuilder().withId(parser.getValueAsInt("ID"))).withEepromAddr(parser.getValueAsIntWithDefault("IE", 0))).withName(parser.getValue("NM"))).withReadOnly(parser.getValueAsInt("RO") != 0)).withVisible(parser.getValueAsIntWithDefault("VI", 1) != 0)).withInitialRows(parser.getValueAsInt("NC")).menuItem();
        int parentId = parser.getValueAsInt("PI");
        List<String> choices = this.choicesFromMsg(parser);
        return CommandFactory.newRuntimeListBootCommand(parentId, item, choices);
    }

    private MenuCommand processBoolBootItem(TagValTextParser parser) throws TcProtocolException {
        BooleanMenuItem item = ((BooleanMenuItemBuilder)((BooleanMenuItemBuilder)((BooleanMenuItemBuilder)((BooleanMenuItemBuilder)((BooleanMenuItemBuilder)BooleanMenuItemBuilder.aBooleanMenuItemBuilder().withId(parser.getValueAsInt("ID"))).withEepromAddr(parser.getValueAsIntWithDefault("IE", 0))).withName(parser.getValue("NM"))).withReadOnly(parser.getValueAsInt("RO") != 0)).withVisible(parser.getValueAsIntWithDefault("VI", 1) != 0)).withNaming(this.toNaming(parser.getValueAsInt("BN"))).menuItem();
        int parentId = parser.getValueAsInt("PI");
        int currentVal = parser.getValueAsInt("VC");
        return CommandFactory.newMenuBooleanBootCommand(parentId, item, currentVal != 0);
    }

    private MenuCommand processRuntimeRgbColor(TagValTextParser parser) throws TcProtocolException {
        Rgb32MenuItem item = ((Rgb32MenuItemBuilder)((Rgb32MenuItemBuilder)((Rgb32MenuItemBuilder)((Rgb32MenuItemBuilder)((Rgb32MenuItemBuilder)new Rgb32MenuItemBuilder().withId(parser.getValueAsInt("ID"))).withEepromAddr(parser.getValueAsIntWithDefault("IE", 0))).withName(parser.getValue("NM"))).withReadOnly(parser.getValueAsInt("RO") != 0)).withVisible(parser.getValueAsIntWithDefault("VI", 1) != 0)).withAlpha(parser.getValueAsIntWithDefault("RA", 0) != 0).menuItem();
        int parentId = parser.getValueAsInt("PI");
        String currentVal = parser.getValue("VC");
        return new MenuRgb32BootCommand(parentId, item, new PortableColor(currentVal));
    }

    private MenuCommand processRuntimeScrollChoice(TagValTextParser parser) throws TcProtocolException {
        ScrollChoiceMenuItem item = ((ScrollChoiceMenuItemBuilder)((ScrollChoiceMenuItemBuilder)((ScrollChoiceMenuItemBuilder)((ScrollChoiceMenuItemBuilder)((ScrollChoiceMenuItemBuilder)new ScrollChoiceMenuItemBuilder().withId(parser.getValueAsInt("ID"))).withEepromAddr(parser.getValueAsIntWithDefault("IE", 0))).withName(parser.getValue("NM"))).withReadOnly(parser.getValueAsInt("RO") != 0)).withVisible(parser.getValueAsIntWithDefault("VI", 1) != 0)).withItemWidth(parser.getValueAsInt("WI")).withNumEntries(parser.getValueAsInt("NC")).menuItem();
        int parentId = parser.getValueAsInt("PI");
        String currentVal = parser.getValue("VC");
        return new MenuScrollChoiceBootCommand(parentId, item, new CurrentScrollPosition(currentVal));
    }

    private MenuCommand processLargeNumBootItem(TagValTextParser parser) throws TcProtocolException {
        EditableLargeNumberMenuItem item = ((EditableLargeNumberMenuItemBuilder)((EditableLargeNumberMenuItemBuilder)((EditableLargeNumberMenuItemBuilder)((EditableLargeNumberMenuItemBuilder)((EditableLargeNumberMenuItemBuilder)EditableLargeNumberMenuItemBuilder.aLargeNumberItemBuilder().withId(parser.getValueAsInt("ID"))).withEepromAddr(parser.getValueAsIntWithDefault("IE", 0))).withName(parser.getValue("NM"))).withReadOnly(parser.getValueAsInt("RO") != 0)).withVisible(parser.getValueAsIntWithDefault("VI", 1) != 0)).withDecimalPlaces(parser.getValueAsInt("FD")).withNegativeAllowed(parser.getValueAsIntWithDefault("NA", 1) != 0).withTotalDigits(parser.getValueAsInt("ML")).menuItem();
        int parentId = parser.getValueAsInt("PI");
        String text = parser.getValue("VC").replaceAll("[\\[\\]]", "");
        return CommandFactory.newLargeNumberBootItem(parentId, item, this.safeBigDecimal(text));
    }

    private BigDecimal safeBigDecimal(String text) {
        try {
            return new BigDecimal(text);
        }
        catch (Exception ex) {
            return BigDecimal.ZERO;
        }
    }

    private MenuCommand processTextItem(TagValTextParser parser) throws TcProtocolException {
        EditableTextMenuItem item = ((EditableTextMenuItemBuilder)((EditableTextMenuItemBuilder)((EditableTextMenuItemBuilder)((EditableTextMenuItemBuilder)((EditableTextMenuItemBuilder)EditableTextMenuItemBuilder.aTextMenuItemBuilder().withId(parser.getValueAsInt("ID"))).withEepromAddr(parser.getValueAsIntWithDefault("IE", 0))).withName(parser.getValue("NM"))).withReadOnly(parser.getValueAsInt("RO") != 0)).withVisible(parser.getValueAsIntWithDefault("VI", 1) != 0)).withEditItemType(EditItemType.fromId(parser.getValueAsInt("EM"))).withLength(parser.getValueAsInt("ML")).menuItem();
        int parentId = parser.getValueAsInt("PI");
        String currentVal = parser.getValue("VC");
        return CommandFactory.newMenuTextBootCommand(parentId, item, currentVal);
    }

    private MenuCommand processFloatItem(TagValTextParser parser) throws TcProtocolException {
        FloatMenuItem item = ((FloatMenuItemBuilder)((FloatMenuItemBuilder)((FloatMenuItemBuilder)((FloatMenuItemBuilder)((FloatMenuItemBuilder)FloatMenuItemBuilder.aFloatMenuItemBuilder().withId(parser.getValueAsInt("ID"))).withEepromAddr(parser.getValueAsIntWithDefault("IE", 0))).withName(parser.getValue("NM"))).withReadOnly(parser.getValueAsInt("RO") != 0)).withVisible(parser.getValueAsIntWithDefault("VI", 1) != 0)).withDecimalPlaces(parser.getValueAsInt("FD")).menuItem();
        int parentId = parser.getValueAsInt("PI");
        String currentVal = parser.getValue("VC");
        return CommandFactory.newMenuFloatBootCommand(parentId, item, Float.valueOf(currentVal));
    }

    private BooleanMenuItem.BooleanNaming toNaming(int i) {
        if (i == 0) {
            return BooleanMenuItem.BooleanNaming.TRUE_FALSE;
        }
        if (i == 1) {
            return BooleanMenuItem.BooleanNaming.ON_OFF;
        }
        return BooleanMenuItem.BooleanNaming.YES_NO;
    }

    private MenuCommand processEnumBootItem(TagValTextParser parser) throws TcProtocolException {
        List<String> choices = this.choicesFromMsg(parser);
        EnumMenuItem item = ((EnumMenuItemBuilder)((EnumMenuItemBuilder)((EnumMenuItemBuilder)((EnumMenuItemBuilder)((EnumMenuItemBuilder)EnumMenuItemBuilder.anEnumMenuItemBuilder().withId(parser.getValueAsInt("ID"))).withEepromAddr(parser.getValueAsIntWithDefault("IE", 0))).withName(parser.getValue("NM"))).withReadOnly(parser.getValueAsInt("RO") != 0)).withVisible(parser.getValueAsIntWithDefault("VI", 1) != 0)).withEnumList(choices).menuItem();
        int parentId = parser.getValueAsInt("PI");
        int currentVal = parser.getValueAsInt("VC");
        return CommandFactory.newMenuEnumBootCommand(parentId, item, currentVal);
    }

    private List<String> choicesFromMsg(TagValTextParser parser) throws TcProtocolException {
        ArrayList<String> choices = new ArrayList<String>();
        int noOfItems = parser.getValueAsInt("NC");
        for (int i = 0; i < noOfItems; ++i) {
            String keyVal = "C" + (char)(i + 65);
            String keyName = "c" + (char)(i + 65);
            String keyText = parser.getValueWithDefault(keyName, "");
            String valText = parser.getValueWithDefault(keyVal, "");
            if (keyText.isEmpty()) {
                choices.add(valText);
                continue;
            }
            choices.add(keyText + "\t" + valText);
        }
        return choices;
    }

    private MenuCommand processSubMenuBootItem(TagValTextParser parser) throws TcProtocolException {
        SubMenuItem item = ((SubMenuItemBuilder)((SubMenuItemBuilder)((SubMenuItemBuilder)SubMenuItemBuilder.aSubMenuItemBuilder().withId(parser.getValueAsInt("ID"))).withEepromAddr(parser.getValueAsIntWithDefault("IE", 0))).withName(parser.getValue("NM"))).menuItem();
        int parentId = parser.getValueAsInt("PI");
        return CommandFactory.newMenuSubBootCommand(parentId, item);
    }

    private MenuCommand processActionItem(TagValTextParser parser) throws TcProtocolException {
        ActionMenuItem item = ((ActionMenuItemBuilder)((ActionMenuItemBuilder)((ActionMenuItemBuilder)ActionMenuItemBuilder.anActionMenuItemBuilder().withId(parser.getValueAsInt("ID"))).withEepromAddr(parser.getValueAsIntWithDefault("IE", 0))).withName(parser.getValue("NM"))).menuItem();
        int parentId = parser.getValueAsInt("PI");
        return new MenuActionBootCommand(parentId, item, Boolean.FALSE);
    }

    private MenuCommand processAnalogBootItem(TagValTextParser parser) throws TcProtocolException {
        AnalogMenuItem item = ((AnalogMenuItemBuilder)((AnalogMenuItemBuilder)((AnalogMenuItemBuilder)((AnalogMenuItemBuilder)((AnalogMenuItemBuilder)AnalogMenuItemBuilder.anAnalogMenuItemBuilder().withId(parser.getValueAsInt("ID"))).withDivisor(parser.getValueAsInt("AD")).withMaxValue(parser.getValueAsInt("AM")).withEepromAddr(parser.getValueAsIntWithDefault("IE", 0))).withOffset(parser.getValueAsInt("AO")).withStep(parser.getValueAsIntWithDefault("AS", 1)).withUnit(parser.getValue("AU")).withName(parser.getValue("NM"))).withReadOnly(parser.getValueAsInt("RO") != 0)).withVisible(parser.getValueAsIntWithDefault("VI", 1) != 0)).menuItem();
        int parentId = parser.getValueAsInt("PI");
        int currentVal = parser.getValueAsInt("VC");
        return CommandFactory.newAnalogBootCommand(parentId, item, currentVal);
    }

    private MenuCommand processBootstrap(TagValTextParser parser) throws TcProtocolException {
        MenuBootstrapCommand.BootType bt = MenuBootstrapCommand.BootType.valueOf(parser.getValue("BT"));
        return new MenuBootstrapCommand(bt);
    }

    private MenuCommand processJoin(TagValTextParser parser) throws TcProtocolException {
        String uuidStr = parser.getValueWithDefault("UU", "");
        UUID uuid = uuidStr.isEmpty() ? UUID.randomUUID() : UUID.fromString(uuidStr);
        return new MenuJoinCommand(uuid, parser.getValue("NM"), ProtocolUtil.fromKeyToApiPlatform(parser.getValueAsInt("PF")), parser.getValueAsInt("VE"), parser.getValueAsIntWithDefault("US", 0));
    }

    private MenuCommand processHeartbeat(TagValTextParser parser) throws TcProtocolException {
        return CommandFactory.newHeartbeatCommand(parser.getValueAsIntWithDefault("HI", 10000), this.toHbMode(parser.getValueAsIntWithDefault("HR", 0)));
    }

    private MenuHeartbeatCommand.HeartbeatMode toHbMode(int hbModeInt) {
        switch (hbModeInt) {
            case 1: {
                return MenuHeartbeatCommand.HeartbeatMode.START;
            }
            case 2: {
                return MenuHeartbeatCommand.HeartbeatMode.END;
            }
        }
        return MenuHeartbeatCommand.HeartbeatMode.NORMAL;
    }

    private void writeDialogUpdate(StringBuilder sb, MenuDialogCommand cmd) {
        TagValMenuCommandProcessors.appendField(sb, "MO", this.asWireMode(cmd.getDialogMode()));
        if (cmd.getHeader() != null) {
            TagValMenuCommandProcessors.appendField(sb, "HF", cmd.getHeader());
        }
        if (cmd.getBuffer() != null) {
            TagValMenuCommandProcessors.appendField(sb, "BU", cmd.getBuffer());
        }
        TagValMenuCommandProcessors.appendField(sb, "B1", cmd.getButton1().getTypeVal());
        TagValMenuCommandProcessors.appendField(sb, "B2", cmd.getButton2().getTypeVal());
        TagValMenuCommandProcessors.appendField(sb, "IC", cmd.getCorrelationId());
    }

    private String asWireMode(DialogMode dialogMode) {
        if (dialogMode == DialogMode.SHOW) {
            return "S";
        }
        if (dialogMode == DialogMode.HIDE) {
            return "H";
        }
        return "A";
    }

    private void writePairingRequest(StringBuilder sb, MenuPairingCommand cmd) {
        TagValMenuCommandProcessors.appendField(sb, "NM", cmd.getName());
        TagValMenuCommandProcessors.appendField(sb, "UU", cmd.getUuid());
    }

    private void writeAcknowledgement(StringBuilder sb, MenuAcknowledgementCommand cmd) {
        TagValMenuCommandProcessors.appendField(sb, "IC", cmd.getCorrelationId().toString());
        TagValMenuCommandProcessors.appendField(sb, "ST", cmd.getAckStatus().getStatusCode());
    }

    private void writeHeartbeat(StringBuilder sb, MenuHeartbeatCommand cmd) {
        int hbMode;
        switch (cmd.getMode()) {
            case START: {
                hbMode = 1;
                break;
            }
            case END: {
                hbMode = 2;
                break;
            }
            default: {
                hbMode = 0;
            }
        }
        TagValMenuCommandProcessors.appendField(sb, "HI", cmd.getHearbeatInterval());
        TagValMenuCommandProcessors.appendField(sb, "HR", hbMode);
    }

    private void writeChangeInt(StringBuilder sb, MenuChangeCommand cmd) {
        TagValMenuCommandProcessors.appendField(sb, "IC", cmd.getCorrelationId());
        TagValMenuCommandProcessors.appendField(sb, "ID", cmd.getMenuItemId());
        TagValMenuCommandProcessors.appendField(sb, "TC", MenuChangeCommand.changeTypeToInt(cmd.getChangeType()));
        if (cmd.getChangeType() == MenuChangeCommand.ChangeType.ABSOLUTE_LIST) {
            this.appendChoices(sb, cmd.getValues());
        } else {
            TagValMenuCommandProcessors.appendField(sb, "VC", cmd.getValue());
        }
    }

    private void writeLargeNumberBootItem(StringBuilder sb, MenuLargeNumBootCommand cmd) {
        this.writeCommonBootFields(sb, cmd);
        int decimalPlaces = ((EditableLargeNumberMenuItem)cmd.getMenuItem()).getDecimalPlaces();
        boolean isNegativeAllowed = ((EditableLargeNumberMenuItem)cmd.getMenuItem()).isNegativeAllowed();
        TagValMenuCommandProcessors.appendField(sb, "FD", decimalPlaces);
        TagValMenuCommandProcessors.appendField(sb, "NA", isNegativeAllowed ? 1 : 0);
        TagValMenuCommandProcessors.appendField(sb, "ML", ((EditableLargeNumberMenuItem)cmd.getMenuItem()).getDigitsAllowed());
        NumberFormat fmt = NumberFormat.getInstance();
        fmt.setGroupingUsed(false);
        fmt.setMinimumFractionDigits(decimalPlaces);
        fmt.setMaximumFractionDigits(decimalPlaces);
        TagValMenuCommandProcessors.appendField(sb, "VC", fmt.format(cmd.getCurrentValue()));
    }

    private void writeScrollBoot(StringBuilder sb, MenuScrollChoiceBootCommand cmd) {
        this.writeCommonBootFields(sb, cmd);
        TagValMenuCommandProcessors.appendField(sb, "WI", ((ScrollChoiceMenuItem)cmd.getMenuItem()).getItemWidth());
        TagValMenuCommandProcessors.appendField(sb, "NC", ((ScrollChoiceMenuItem)cmd.getMenuItem()).getNumEntries());
        TagValMenuCommandProcessors.appendField(sb, "VC", ((CurrentScrollPosition)cmd.getCurrentValue()).toString());
    }

    private void writeRgbBoot(StringBuilder sb, MenuRgb32BootCommand cmd) {
        this.writeCommonBootFields(sb, cmd);
        TagValMenuCommandProcessors.appendField(sb, "RA", ((Rgb32MenuItem)cmd.getMenuItem()).isIncludeAlphaChannel() ? 1 : 0);
        TagValMenuCommandProcessors.appendField(sb, "VC", ((PortableColor)cmd.getCurrentValue()).toString());
    }

    private void writeAnalogItem(StringBuilder sb, MenuAnalogBootCommand cmd) {
        this.writeCommonBootFields(sb, cmd);
        TagValMenuCommandProcessors.appendField(sb, "AO", ((AnalogMenuItem)cmd.getMenuItem()).getOffset());
        TagValMenuCommandProcessors.appendField(sb, "AD", ((AnalogMenuItem)cmd.getMenuItem()).getDivisor());
        TagValMenuCommandProcessors.appendField(sb, "AM", ((AnalogMenuItem)cmd.getMenuItem()).getMaxValue());
        TagValMenuCommandProcessors.appendField(sb, "AS", ((AnalogMenuItem)cmd.getMenuItem()).getStep());
        TagValMenuCommandProcessors.appendField(sb, "AU", ((AnalogMenuItem)cmd.getMenuItem()).getUnitName());
        TagValMenuCommandProcessors.appendField(sb, "VC", cmd.getCurrentValue());
    }

    private void writeSubMenuItem(StringBuilder sb, MenuSubBootCommand cmd) {
        this.writeCommonBootFields(sb, cmd);
        TagValMenuCommandProcessors.appendField(sb, "VC", "0");
    }

    private void writeActionBootItem(StringBuilder sb, MenuActionBootCommand cmd) {
        this.writeCommonBootFields(sb, cmd);
        TagValMenuCommandProcessors.appendField(sb, "VC", "");
    }

    private void writeBoolMenuItem(StringBuilder sb, MenuBooleanBootCommand cmd) {
        this.writeCommonBootFields(sb, cmd);
        TagValMenuCommandProcessors.appendField(sb, "BN", this.fromNaming(((BooleanMenuItem)cmd.getMenuItem()).getNaming()));
        TagValMenuCommandProcessors.appendField(sb, "VC", (Boolean)cmd.getCurrentValue() != false ? 1 : 0);
    }

    private void writeCommonBootFields(StringBuilder sb, BootItemMenuCommand<?, ?> cmd) {
        TagValMenuCommandProcessors.appendField(sb, "PI", cmd.getSubMenuId());
        TagValMenuCommandProcessors.appendField(sb, "ID", ((MenuItem)cmd.getMenuItem()).getId());
        TagValMenuCommandProcessors.appendField(sb, "IE", ((MenuItem)cmd.getMenuItem()).getEepromAddress());
        TagValMenuCommandProcessors.appendField(sb, "NM", ((MenuItem)cmd.getMenuItem()).getName());
        TagValMenuCommandProcessors.appendField(sb, "RO", ((MenuItem)cmd.getMenuItem()).isReadOnly() ? 1 : 0);
        TagValMenuCommandProcessors.appendField(sb, "VI", ((MenuItem)cmd.getMenuItem()).isVisible() ? 1 : 0);
    }

    private void writeRuntimeListBootItem(StringBuilder sb, MenuRuntimeListBootCommand cmd) {
        this.writeCommonBootFields(sb, cmd);
        this.appendChoices(sb, (List)cmd.getCurrentValue());
    }

    private void writeFloatBootItem(StringBuilder sb, MenuFloatBootCommand cmd) {
        this.writeCommonBootFields(sb, cmd);
        TagValMenuCommandProcessors.appendField(sb, "FD", ((FloatMenuItem)cmd.getMenuItem()).getNumDecimalPlaces());
        TagValMenuCommandProcessors.appendField(sb, "VC", cmd.getCurrentValue());
    }

    private void writeTextMenuItem(StringBuilder sb, MenuTextBootCommand cmd) {
        this.writeCommonBootFields(sb, cmd);
        TagValMenuCommandProcessors.appendField(sb, "ML", ((EditableTextMenuItem)cmd.getMenuItem()).getTextLength());
        TagValMenuCommandProcessors.appendField(sb, "EM", ((EditableTextMenuItem)cmd.getMenuItem()).getItemType().getMsgId());
        TagValMenuCommandProcessors.appendField(sb, "VC", cmd.getCurrentValue());
    }

    private int fromNaming(BooleanMenuItem.BooleanNaming naming) {
        switch (naming) {
            case ON_OFF: {
                return 1;
            }
            case YES_NO: {
                return 2;
            }
        }
        return 0;
    }

    private void writeEnumMenuItem(StringBuilder sb, MenuEnumBootCommand cmd) {
        this.writeCommonBootFields(sb, cmd);
        TagValMenuCommandProcessors.appendField(sb, "VC", cmd.getCurrentValue());
        List<String> entries = ((EnumMenuItem)cmd.getMenuItem()).getEnumEntries();
        this.appendChoices(sb, entries);
    }

    private void appendChoices(StringBuilder sb, List<String> entries) {
        if (entries == null) {
            TagValMenuCommandProcessors.appendField(sb, "NC", 0);
        } else {
            TagValMenuCommandProcessors.appendField(sb, "NC", entries.size());
            for (int i = 0; i < entries.size(); ++i) {
                TagValMenuCommandProcessors.appendField(sb, "C" + (char)(65 + i), entries.get(i));
            }
        }
    }

    private void writeBootstrap(StringBuilder sb, MenuBootstrapCommand cmd) {
        TagValMenuCommandProcessors.appendField(sb, "BT", (Object)cmd.getBootType());
    }

    private void writeJoin(StringBuilder sb, MenuJoinCommand cmd) {
        TagValMenuCommandProcessors.appendField(sb, "NM", cmd.getMyName());
        TagValMenuCommandProcessors.appendField(sb, "UU", cmd.getAppUuid());
        TagValMenuCommandProcessors.appendField(sb, "VE", cmd.getApiVersion());
        TagValMenuCommandProcessors.appendField(sb, "PF", cmd.getPlatform().getKey());
    }

    public static void appendField(StringBuilder sb, String key, Object value) {
        if (value instanceof String) {
            String val = (String)value;
            if (val.indexOf(124) != -1) {
                val = val.replace("|", "\\|");
            }
            if (val.indexOf(61) != -1) {
                val = val.replace("=", "\\=");
            }
            value = val;
        }
        sb.append(key);
        sb.append('=');
        sb.append(value);
        sb.append('|');
    }
}

