/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.menu.remote;

import com.thecoderscorner.menu.remote.AuthStatus;
import com.thecoderscorner.menu.remote.ConnectMode;
import com.thecoderscorner.menu.remote.ConnectionChangeListener;
import com.thecoderscorner.menu.remote.LocalIdentifier;
import com.thecoderscorner.menu.remote.MenuCommandProtocol;
import com.thecoderscorner.menu.remote.RemoteConnector;
import com.thecoderscorner.menu.remote.RemoteConnectorListener;
import com.thecoderscorner.menu.remote.RemoteInformation;
import com.thecoderscorner.menu.remote.SharedStreamConnection;
import com.thecoderscorner.menu.remote.commands.AckStatus;
import com.thecoderscorner.menu.remote.commands.CommandFactory;
import com.thecoderscorner.menu.remote.commands.MenuCommand;
import com.thecoderscorner.menu.remote.commands.MenuHeartbeatCommand;
import com.thecoderscorner.menu.remote.protocol.CorrelationId;
import com.thecoderscorner.menu.remote.states.AwaitingBootstrapState;
import com.thecoderscorner.menu.remote.states.BootstrapInProgressState;
import com.thecoderscorner.menu.remote.states.ConnectionHasFailedState;
import com.thecoderscorner.menu.remote.states.ConnectionReadyState;
import com.thecoderscorner.menu.remote.states.JoinMessageArrivedState;
import com.thecoderscorner.menu.remote.states.NoOperationInitialState;
import com.thecoderscorner.menu.remote.states.PairingAuthFailedState;
import com.thecoderscorner.menu.remote.states.PairingAuthSuccessState;
import com.thecoderscorner.menu.remote.states.RemoteConnectorContext;
import com.thecoderscorner.menu.remote.states.RemoteConnectorState;
import com.thecoderscorner.menu.remote.states.SendPairingMessageState;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Clock;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public abstract class StreamRemoteConnector
extends SharedStreamConnection
implements RemoteConnector,
RemoteConnectorContext {
    private static final int UI_SERIAL_NO = 0;
    protected final ScheduledExecutorService executor;
    protected final Clock clock;
    protected final Map<AuthStatus, Class<? extends RemoteConnectorState>> stateMachineMappings = new HashMap<AuthStatus, Class<? extends RemoteConnectorState>>();
    private final List<RemoteConnectorListener> connectorListeners = new CopyOnWriteArrayList<RemoteConnectorListener>();
    private final List<ConnectionChangeListener> connectionListeners = new CopyOnWriteArrayList<ConnectionChangeListener>();
    private final LocalIdentifier ourLocalId;
    private final AtomicReference<RemoteConnectorState> connectorState = new AtomicReference();
    private final AtomicReference<RemoteInformation> remoteParty = new AtomicReference<RemoteInformation>(RemoteInformation.NOT_CONNECTED);
    private final AtomicBoolean connectionRunning = new AtomicBoolean(false);

    protected StreamRemoteConnector(LocalIdentifier ourLocalId, MenuCommandProtocol protocol, ScheduledExecutorService executor, Clock clock) {
        super(protocol);
        this.ourLocalId = ourLocalId;
        this.executor = executor;
        this.clock = clock;
        this.changeState(new NoOperationInitialState(this));
    }

    @Override
    public boolean canSendMessageNow(MenuCommand cmd) {
        return this.connectorState.get().canSendCommandToRemote(cmd);
    }

    protected void stopThreadProc() {
        this.connectionRunning.set(false);
    }

    protected void startThreadProc() {
        this.connectionRunning.set(true);
        this.executor.execute(this::tickerThreadProc);
    }

    private void tickerThreadProc() {
        this.connectionLog(System.Logger.Level.INFO, "Started ticker thread for " + this.getConnectionName());
        while (this.connectionRunning.get() && !Thread.currentThread().isInterrupted()) {
            RemoteConnectorState rcs = this.connectorState.get();
            try {
                if (rcs == null) {
                    Thread.sleep(100L);
                    continue;
                }
                rcs.runLoop();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                this.connectionRunning.set(false);
                this.logger.log(System.Logger.Level.ERROR, "Thread is interrupted and will stop", (Throwable)ex);
            }
            catch (Exception ex) {
                this.logger.log(System.Logger.Level.ERROR, "Exception in thread proc during state " + String.valueOf(rcs));
            }
        }
        this.logger.log(System.Logger.Level.INFO, "Stopped ticker thread for " + this.getConnectionName());
    }

    @Override
    public void close() {
        this.inputBuffer.clear();
        this.inputBuffer.flip();
        this.cmdBuffer.clear();
        this.notifyConnection();
    }

    protected void handleCoreConnectionStates(ConnectMode connectMode) {
        if (connectMode == ConnectMode.PAIRING_CONNECTION) {
            this.stateMachineMappings.put(AuthStatus.SEND_AUTH, SendPairingMessageState.class);
            this.stateMachineMappings.put(AuthStatus.AUTHENTICATED, PairingAuthSuccessState.class);
            this.stateMachineMappings.put(AuthStatus.FAILED_AUTH, PairingAuthFailedState.class);
        } else {
            this.stateMachineMappings.put(AuthStatus.SEND_AUTH, JoinMessageArrivedState.class);
            this.stateMachineMappings.put(AuthStatus.AUTHENTICATED, AwaitingBootstrapState.class);
            this.stateMachineMappings.put(AuthStatus.BOOTSTRAPPING, BootstrapInProgressState.class);
            this.stateMachineMappings.put(AuthStatus.CONNECTION_READY, ConnectionReadyState.class);
        }
        this.stateMachineMappings.put(AuthStatus.CONNECTION_FAILED, ConnectionHasFailedState.class);
    }

    @Override
    protected abstract void sendInternal(ByteBuffer var1) throws IOException;

    @Override
    public void registerConnectorListener(RemoteConnectorListener listener) {
        this.connectorListeners.add(listener);
    }

    @Override
    public void registerConnectionChangeListener(ConnectionChangeListener listener) {
        this.connectionListeners.add(listener);
        this.executor.execute(() -> listener.connectionChange(this, this.getAuthenticationStatus()));
    }

    @Override
    public void notifyListeners(MenuCommand mc) {
        this.connectorListeners.forEach(listener -> listener.onCommand(this, mc));
    }

    protected void notifyConnection() {
        this.connectionListeners.forEach(listener -> listener.connectionChange(this, this.getAuthenticationStatus()));
    }

    @Override
    public void changeState(AuthStatus desiredState) {
        Class<? extends RemoteConnectorState> state = this.stateMachineMappings.get((Object)desiredState);
        if (state == null) {
            throw new IllegalArgumentException(String.valueOf((Object)desiredState) + " not available in mappings");
        }
        try {
            this.changeState(state.getConstructor(RemoteConnectorContext.class).newInstance(this));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.valueOf((Object)desiredState) + " caused an exception", e);
        }
    }

    @Override
    public void changeState(RemoteConnectorState newState) {
        RemoteConnectorState oldState = this.connectorState.get();
        this.connectionLog(System.Logger.Level.INFO, "Transition " + this.stateName(oldState) + "->" + this.stateName(newState) + " for " + this.getConnectionName());
        if (oldState != null) {
            oldState.exitState(newState);
        }
        this.connectorState.set(newState);
        newState.enterState();
        this.notifyConnection();
    }

    private String stateName(RemoteConnectorState state) {
        if (state == null) {
            return "NoState";
        }
        return state.getClass().getSimpleName();
    }

    @Override
    public RemoteInformation getRemoteParty() {
        return this.remoteParty.get();
    }

    @Override
    public void setRemoteParty(RemoteInformation remote) {
        this.remoteParty.set(remote);
    }

    @Override
    public AuthStatus getAuthenticationStatus() {
        return this.connectorState.get().getAuthenticationStatus();
    }

    @Override
    public void sendHeartbeat(int frequency, MenuHeartbeatCommand.HeartbeatMode mode) {
        try {
            this.sendMenuCommand(CommandFactory.newHeartbeatCommand(frequency, mode));
        }
        catch (IOException e) {
            this.connectionLog(System.Logger.Level.ERROR, "Exception sending heartbeat on channel", e);
        }
    }

    @Override
    public void sendJoin() throws IOException {
        this.sendMenuCommand(CommandFactory.newJoinCommand(this.ourLocalId.getName(), this.ourLocalId.getUuid(), 0));
    }

    @Override
    public void sendAcknowledgement(AckStatus ackStatus) throws IOException {
        this.sendMenuCommand(CommandFactory.newAcknowledgementCommand(CorrelationId.EMPTY_CORRELATION, ackStatus));
    }

    @Override
    public void sendPairing() throws IOException {
        this.sendMenuCommand(CommandFactory.newPairingCommand(this.ourLocalId.getName(), this.ourLocalId.getUuid()));
    }

    @Override
    public ScheduledExecutorService getScheduledExecutor() {
        return this.executor;
    }

    @Override
    public Clock getClock() {
        return this.clock;
    }

    protected void connectionLog(System.Logger.Level l, String s, Throwable e) {
        this.logger.log(l, this.getConnectionName() + " - " + s, e);
    }

    @Override
    public String getUserName() {
        return this.remoteParty.get().getName();
    }

    public static enum ReadMode {
        ONLY_WHEN_EMPTY,
        READ_MORE;

    }
}

